/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.ErrorDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.TableContents;
import com.tridium.smartTableHx.export.BExportData;
import com.tridium.smartTableHx.export.BExportFileScheme;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.BPdfStyle;
import com.tridium.smartTableHx.export.DownloadDialog;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import java.io.OutputStream;
import javax.baja.file.BExporter;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.pdf.PdfOp;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExportCommand
extends SmartCommand {
    private ExportDialog dialog = new ExportDialog(this.getDisplayName(null), this);
    static /* synthetic */ Class class$com$tridium$smartTableHx$export$ExportCommand;

    public String getName(HxOp hxOp) {
        return "export";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public boolean readonlyEnablePolicy(HxOp hxOp) {
        return true;
    }

    public boolean isTableCommand(HxOp hxOp) {
        return true;
    }

    public void handle(HxOp hxOp) throws Exception {
        if (!this.dialog.isSubmit(hxOp)) {
            this.dialog.open(hxOp);
            return;
        }
        try {
            hxOp = hxOp.mergeFacets(BHxSmartTableView.exportTableFacets);
            BExportData bExportData = (BExportData)this.getExportTab(hxOp).save();
            ExportCommand.validate(bExportData, (BHxSmartTableView)this.getView(), hxOp);
            BExportFileWrapper bExportFileWrapper = ExportCommand.makeExportFile(bExportData, hxOp);
            ExportCommand.redirectToWrapper(bExportFileWrapper, hxOp);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            new ErrorDialog("Cannot Export", (Command)this, throwable).open(hxOp);
        }
    }

    public static TableContents getTableContents(BHxSmartTableView bHxSmartTableView, HxOp hxOp) throws Exception {
        return bHxSmartTableView.writeContents(hxOp);
    }

    public static void validate(BExportData bExportData, BHxSmartTableView bHxSmartTableView, HxOp hxOp) throws Exception {
        TableContents tableContents;
        Object object;
        int n = bHxSmartTableView.getMaxResultSize((Context)hxOp);
        if (bExportData.isCurrentSelection()) {
            object = new Array((Object[])ExportCommand.getSelectionList(hxOp));
            bExportData.setTableContents(ExportCommand.getTableContents(bHxSmartTableView, hxOp), n);
            tableContents = bExportData.getTableContents().getBasicCopy();
            int n2 = 0;
            while (n2 < bExportData.getTableContents().tr.size()) {
                TableContents.Tr tr = (TableContents.Tr)bExportData.getTableContents().tr.get(n2);
                if (object.contains((Object)tr.id)) {
                    tableContents.tr.add((Object)tr);
                }
                ++n2;
            }
            bExportData.setTableContents(tableContents, n);
        } else if (bExportData.isSinglePage()) {
            bExportData.setTableContents(ExportCommand.getTableContents(bHxSmartTableView, hxOp), n);
            bExportData.setTableContents(bExportData.getTableContents().getPage(bHxSmartTableView.getPage(hxOp) - 1, bHxSmartTableView.getPageSize(hxOp)), n);
        } else if (!bHxSmartTableView.supportsPaginatedQuery(hxOp)) {
            bExportData.setTableContents(ExportCommand.getTableContents(bHxSmartTableView, hxOp), n);
        } else {
            int n3 = bHxSmartTableView.getPageSize(hxOp);
            bHxSmartTableView.setPageSize(hxOp, bHxSmartTableView.getMaxResultSize((Context)hxOp));
            bExportData.setTableContents(ExportCommand.getTableContents(bHxSmartTableView, hxOp), n);
            bHxSmartTableView.setPageSize(hxOp, n3);
        }
        if (!bExportData.isPdf()) {
            return;
        }
        object = bExportData.getResolvedStyle();
        tableContents = ((BPdfStyle)((Object)object)).getImage();
        try {
            tableContents.sync();
            if (tableContents.getHeight() == 0.0) {
                throw new IllegalStateException("Please choose a PDF style with a valid image.");
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Please choose a PDF style with a valid image.");
        }
    }

    public Tab getExportTab(HxOp hxOp) throws Exception {
        BExportData bExportData = new BExportData(this.getView().getPageTitle(hxOp));
        return ExportCommand.getExportTab(bExportData, hxOp);
    }

    public static Tab getExportTab(BExportData bExportData, HxOp hxOp) {
        return new Tab(BHxFieldSheet.INSTANCE, hxOp.make("fields", (BObject)bExportData, null));
    }

    public static BExportFileWrapper makeExportFile(BExportData bExportData, HxOp hxOp) throws Exception {
        String string = bExportData.getFileName();
        BExporter bExporter = bExportData.getExporter();
        BExportFileWrapper bExportFileWrapper = ExportCommand.makeExportFileWrapper(string);
        OrdTarget ordTarget = new OrdTarget(hxOp.getBaseOrdTarget(), (BObject)bExportData);
        bExporter.export(PdfOp.make((OrdTarget)ordTarget, (OutputStream)bExportFileWrapper.getOutputStream()));
        bExportFileWrapper.closeOutput();
        return bExportFileWrapper;
    }

    public static BExportFileWrapper makeExportFileWrapper(String string) throws Exception {
        BExportFileWrapper bExportFileWrapper = new BExportFileWrapper(string);
        bExportFileWrapper.init();
        return bExportFileWrapper;
    }

    public static void redirectToWrapper(BExportFileWrapper bExportFileWrapper, HxOp hxOp) throws Exception {
        ExportCommand.redirectToWrapper(bExportFileWrapper, false, hxOp);
    }

    public static void redirectToWrapper(BExportFileWrapper bExportFileWrapper, boolean bl, HxOp hxOp) throws Exception {
        BExportFileScheme.addWrapper(bExportFileWrapper);
        Class clazz = class$com$tridium$smartTableHx$export$ExportCommand;
        if (clazz == null) {
            clazz = class$com$tridium$smartTableHx$export$ExportCommand = ExportCommand.class("[Lcom.tridium.smartTableHx.export.ExportCommand;", false);
        }
        new DownloadDialog(Lexicon.make((Class)clazz).getText("download"), null, bExportFileWrapper, bl).open(hxOp);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ExportCommand(BHxView bHxView) {
        super(bHxView);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ExportDialog
    extends Dialog {
        protected void writeContent(HxOp hxOp) throws Exception {
            Tab tab = ExportCommand.this.getExportTab(hxOp);
            tab.write();
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.alignment.getName()), "0", hxOp);
            HxTabUtil.addEvent("change", HxTabUtil.HIDE_ELEM, HxTabUtil.CALL_NOW, tab.op.scope(BExportData.fileType.getName() + ".value"), tab.op.scope(BExportData.style.getName()), "0", hxOp);
        }

        public ExportDialog(String string, Command command) {
            super(string, command);
        }
    }
}

