/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.export;

import com.tridium.sys.Nre;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BExportFileWrapper
extends BStruct
implements BINavNode {
    public static final Property uuid = BExportFileWrapper.newProperty((int)0, (BValue)BUuid.DEFAULT, null);
    public static final Property fileName = BExportFileWrapper.newProperty((int)0, (String)"", null);
    public static final Property contentType = BExportFileWrapper.newProperty((int)0, (String)"", null);
    public static final Property timestamp = BExportFileWrapper.newProperty((int)0, (BValue)BAbsTime.DEFAULT, null);
    public static final Type TYPE;
    private OutputStream outputStream;
    private InputStream inputStream;
    private File tempFile;
    private int length;
    static /* synthetic */ Class class$com$tridium$smartTableHx$export$BExportFileWrapper;

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid bUuid) {
        this.set(uuid, (BValue)bUuid, null);
    }

    public String getFileName() {
        return this.getString(fileName);
    }

    public void setFileName(String string) {
        this.setString(fileName, string, null);
    }

    public String getContentType() {
        return this.getString(contentType);
    }

    public void setContentType(String string) {
        this.setString(contentType, string, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime bAbsTime) {
        this.set(timestamp, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.tempFile != null) {
            this.outputStream = new FileOutputStream(this.tempFile);
            return this.outputStream;
        }
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    public byte[] getBytes() throws Exception {
        byte[] byArray = new byte[this.length];
        this.getInputStream().read(byArray);
        return byArray;
    }

    public File getFile() {
        return this.tempFile;
    }

    public void closeOutput() throws Exception {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
            if (this.outputStream instanceof ByteArrayOutputStream) {
                this.length = ((ByteArrayOutputStream)this.outputStream).size();
            }
        }
        if (this.tempFile != null) {
            this.length = (int)this.tempFile.length();
        }
    }

    public void closeInput() throws Exception {
        boolean bl;
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.tempFile != null && !(bl = this.tempFile.delete())) {
            this.tempFile.deleteOnExit();
        }
    }

    public InputStream getInputStream() throws Exception {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.tempFile != null) {
            this.inputStream = new FileInputStream(this.tempFile);
            return this.inputStream;
        }
        byte[] byArray = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        this.length = byArray.length;
        this.inputStream = new ByteArrayInputStream(byArray);
        return this.inputStream;
    }

    public void init() throws Exception {
        String string = Nre.getHostModel();
        if (string.equals("Workstation")) {
            this.initTempFile();
        } else {
            this.initBuffer();
        }
    }

    public void initBuffer() throws Exception {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
    }

    public void initTempFile() throws Exception {
        if (this.tempFile == null) {
            this.tempFile = File.createTempFile("" + this.getUuid(), ".tempExport");
        }
    }

    public String getNavName() {
        return this.getFileName();
    }

    public String getNavDisplayName(Context context) {
        return this.getNavName();
    }

    public BINavNode getNavParent() {
        BComponent bComponent = (BComponent)this.getParent();
        if (bComponent != null) {
            return bComponent;
        }
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode getNavChild(String string) {
        return null;
    }

    public BINavNode resolveNavChild(String string) {
        throw new UnresolvedException(string);
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public boolean isNavChild() {
        return true;
    }

    public String getNavDescription(Context context) {
        return this.getType().toString();
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)("exportFile:/" + this.getUuid()));
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BExportFileWrapper() {
        this.setUuid(BUuid.make());
    }

    public BExportFileWrapper(String string) {
        this();
        this.setFileName(string);
    }

    static {
        Class clazz = class$com$tridium$smartTableHx$export$BExportFileWrapper;
        if (clazz == null) {
            clazz = class$com$tridium$smartTableHx$export$BExportFileWrapper = BExportFileWrapper.class("[Lcom.tridium.smartTableHx.export.BExportFileWrapper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

