/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.ui;

import com.tridium.ndio.conv.BThermistorType3Conversion;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.ext.BLinearCalibrationExt;
import com.tridium.ndio.learn.BNdioPointEntry;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.ndio.point.BNdioProxyExt;
import com.tridium.ndio.point.BNdioResistiveInputProxyExt;
import com.tridium.ndio.point.BNdioVoltageInputProxyExt;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioPointManager
extends BPointManager {
    public static final Type TYPE;
    static final Lexicon lex;
    static Lexicon abstractLex;
    static Lexicon ndioLex;
    static BImage ndioFloatIcon;
    static BImage ndioBooleanIcon;
    static BImage ndioMixIcon;
    static final Log log;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colAddress;
    MgrColumn collPollFrequency;
    MgrColumn colConversion;
    MgrColumn colFacets;
    MgrColumn colString;
    MgrColumn[] cols;
    private BNdioPointDeviceExt deviceExt;
    private BNdioPointEntry[] lastLearn;
    static /* synthetic */ Class class$com$tridium$ndio$ui$BNdioPointManager;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController;
    static /* synthetic */ Class class$javax$baja$driver$ui$point$BPointManager;
    static /* synthetic */ Class class$com$tridium$ndio$learn$BNdioPointEntry;

    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        try {
            this.deviceExt = (BNdioPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
            if (this.getCurrentValue() != this.deviceExt) {
                this.registerForComponentEvents((BComponent)this.deviceExt);
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    private final void updateDiscoveryRows(BComponent bComponent) {
        Class clazz = class$com$tridium$ndio$learn$BNdioPointEntry;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$learn$BNdioPointEntry = BNdioPointManager.class("[Lcom.tridium.ndio.learn.BNdioPointEntry;", false);
        }
        BNdioPointEntry[] bNdioPointEntryArray = (BNdioPointEntry[])bComponent.getChildren(clazz);
        this.lastLearn = bNdioPointEntryArray;
        int n = 0;
        while (n < bNdioPointEntryArray.length) {
            bNdioPointEntryArray[n].loadSlots();
            ++n;
        }
        this.getLearn().updateRoots((Object[])bNdioPointEntryArray);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colName = new MgrColumn.Name();
        this.colType = new MgrColumn.Type(1);
        this.colAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNdioProxyExt.address}, 1);
        this.collPollFrequency = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNdioProxyExt.pollFrequency}, 3);
        this.colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.conversion}, 3);
        this.colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
        this.colString = new MgrColumn.ToString(ndioLex.getText("pointManager.out"), 0);
        this.cols = new MgrColumn[]{this.colName, this.colType, this.colAddress, this.collPollFrequency, this.colConversion, this.colString, this.colFacets};
        this.deviceExt = null;
        this.lastLearn = null;
    }

    public BNdioPointManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$ui$BNdioPointManager;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$ui$BNdioPointManager = BNdioPointManager.class("[Lcom.tridium.ndio.ui.BNdioPointManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$javax$baja$workbench$mgr$MgrController;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$workbench$mgr$MgrController = BNdioPointManager.class("[Ljavax.baja.workbench.mgr.MgrController;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        Class clazz3 = class$javax$baja$driver$ui$point$BPointManager;
        if (clazz3 == null) {
            clazz3 = class$javax$baja$driver$ui$point$BPointManager = BNdioPointManager.class("[Ljavax.baja.driver.ui.point.BPointManager;", false);
        }
        abstractLex = Lexicon.make((Class)clazz3);
        ndioLex = Lexicon.make((String)"ndio");
        ndioFloatIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
        ndioBooleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
        ndioMixIcon = BImage.make((String)"module://icons/x16/statusMixed.png");
        log = Log.getLog((String)"ndio");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Model
    extends PointModel {
        protected MgrColumn[] makeColumns() {
            return BNdioPointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            NdioMgrTypeInfo ndioMgrTypeInfo = (NdioMgrTypeInfo)mgrTypeInfo;
            BControlPoint bControlPoint = (BControlPoint)ndioMgrTypeInfo.newInstance();
            return bControlPoint;
        }

        public MgrTypeInfo toType(BComponent bComponent) {
            return new NdioMgrTypeInfo(bComponent);
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<NdioMgrTypeInfo> arrayList = new ArrayList<NdioMgrTypeInfo>();
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioVoltageInputProxyExtPoint"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioResistiveInputProxyExtPoint"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), BThermistorType3Conversion.DEFAULT, "type.NdioThermistorInputProxyExtPoint"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioCounterInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioCounterInputProxyExtPoint"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanInputProxyExt"), Sys.getRegistry().getType("control:BooleanPoint"), null, "type.NdioBooleanInputProxyExtPoint"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageOutputProxyExt"), Sys.getRegistry().getType("control:NumericWritable"), null, "type.NdioVoltageOutputProxyExtWritable"));
            arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanOutputProxyExt"), Sys.getRegistry().getType("control:BooleanWritable"), null, "type.NdioBooleanOutputProxyExtWritable"));
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        Model(BNdioPointManager bNdioPointManager2) {
            super((BPointManager)bNdioPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Learn
    extends MgrLearn {
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNdioPointEntry.ioType, 0), new MgrColumn.Prop(BNdioPointEntry.address, 0)};
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            return false;
        }

        public void jobComplete(BJob bJob) {
            super.jobComplete(bJob);
            BNdioPointManager.this.updateDiscoveryRows((BComponent)bJob);
        }

        public BImage getIcon(Object object) {
            BNdioPointEntry bNdioPointEntry = (BNdioPointEntry)((Object)object);
            if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.universalInput) {
                return ndioMixIcon;
            }
            if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                return ndioFloatIcon;
            }
            return ndioBooleanIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            ArrayList<NdioMgrTypeInfo> arrayList = new ArrayList<NdioMgrTypeInfo>();
            BNdioPointEntry bNdioPointEntry = (BNdioPointEntry)((Object)object);
            if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.universalInput) {
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioVoltageInputProxyExtPoint"));
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioResistiveInputProxyExtPoint"));
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioResistiveInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), BThermistorType3Conversion.DEFAULT, "type.NdioThermistorInputProxyExtPoint"));
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioCounterInputProxyExt"), Sys.getRegistry().getType("control:NumericPoint"), null, "type.NdioCounterInputProxyExtPoint"));
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanInputProxyExt"), Sys.getRegistry().getType("control:BooleanPoint"), null, "type.NdioBooleanInputProxyExtPoint"));
            } else if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioVoltageOutputProxyExt"), Sys.getRegistry().getType("control:NumericWritable"), null, "type.NdioVoltageOutputProxyExtWritable"));
            } else if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.booleanOutput) {
                arrayList.add(new NdioMgrTypeInfo(Sys.getRegistry().getType("ndio:NdioBooleanOutputProxyExt"), Sys.getRegistry().getType("control:BooleanWritable"), null, "type.NdioBooleanOutputProxyExtWritable"));
            } else {
                log.error("didn't find a valid point type: " + (Object)((Object)bNdioPointEntry.getIoType()));
                return new MgrTypeInfo[0];
            }
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BNdioPointEntry bNdioPointEntry = (BNdioPointEntry)((Object)object);
            if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.universalInput) {
                mgrEditRow.setDefaultName(ndioLex.getText("default.universalInputName"));
            } else if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.analogOutput) {
                mgrEditRow.setDefaultName(ndioLex.getText("default.analogOutputName"));
            } else if (bNdioPointEntry.getIoType() == BNdioIoTypeEnum.booleanOutput) {
                mgrEditRow.setDefaultName(ndioLex.getText("default.booleanOutputName"));
            } else {
                mgrEditRow.setDefaultName("somethingWrong");
            }
            mgrEditRow.setCell(BNdioPointManager.this.colAddress, (BValue)BInteger.make((int)bNdioPointEntry.getAddress()));
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            try {
                BNdioPointEntry bNdioPointEntry = (BNdioPointEntry)((Object)object);
                return bNdioPointEntry.is(bComponent);
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        Learn(BNdioPointManager bNdioPointManager2) {
            super((BAbstractManager)bNdioPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class State
    extends MgrState {
        BNdioPointEntry[] lastLearn;

        protected void saveForOrd(BAbstractManager bAbstractManager) {
            super.saveForOrd(bAbstractManager);
            BNdioPointManager bNdioPointManager = (BNdioPointManager)bAbstractManager;
            this.lastLearn = bNdioPointManager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager bAbstractManager) {
            super.restoreForOrd(bAbstractManager);
            BNdioPointManager bNdioPointManager = (BNdioPointManager)bAbstractManager;
            if (this.lastLearn != null) {
                bNdioPointManager.lastLearn = this.lastLearn;
                bNdioPointManager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }

        private final /* synthetic */ void this() {
            this.lastLearn = null;
        }

        State() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Controller
    extends PointController {
        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand iMgrCommand) {
            return null;
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            BNdioPointManager.this.getLearn().setJob(BNdioPointManager.this.deviceExt.submitDiscoveryJob());
            return null;
        }

        Controller(BNdioPointManager bNdioPointManager2) {
            super((BPointManager)bNdioPointManager2);
        }
    }

    static class NdioMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo extType;
        private TypeInfo pntType;
        private String displayName;
        private BProxyConversion converter;

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public TypeInfo getExtTypeInfo() {
            return this.extType;
        }

        public BProxyConversion getConverter() {
            return this.converter;
        }

        public BImage getIcon() {
            return null;
        }

        public BComponent newInstance() {
            BControlPoint bControlPoint = (BControlPoint)this.pntType.getInstance();
            BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)this.extType.getInstance();
            bNdioProxyExt.setConversion(this.converter);
            bControlPoint.setProxyExt((BAbstractProxyExt)bNdioProxyExt);
            BFacets bFacets = bControlPoint.getFacets();
            if (this.converter instanceof BThermistorType3Conversion) {
                bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"));
            } else {
                BIDataValue bIDataValue = (BIDataValue)bNdioProxyExt.getDeviceFacets().get("units");
                if (bIDataValue != null) {
                    bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)bIDataValue);
                }
            }
            bControlPoint.setFacets(bFacets);
            if (bNdioProxyExt instanceof BNdioVoltageInputProxyExt) {
                bControlPoint.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"volt")), 0);
            }
            if (bNdioProxyExt instanceof BNdioResistiveInputProxyExt) {
                if (this.converter instanceof BThermistorType3Conversion) {
                    bControlPoint.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"celsius")), 0);
                } else {
                    bControlPoint.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"ohm")), 0);
                }
            }
            return bControlPoint;
        }

        public boolean isMatchable(BComponent bComponent) {
            return false;
        }

        NdioMgrTypeInfo(TypeInfo typeInfo, TypeInfo typeInfo2, BProxyConversion bProxyConversion, String string) {
            this.extType = typeInfo;
            this.pntType = typeInfo2;
            this.converter = bProxyConversion;
            this.displayName = ndioLex.getText(string);
            if (this.converter == null) {
                this.converter = BDefaultProxyConversion.DEFAULT;
            }
        }

        NdioMgrTypeInfo(BComponent bComponent) {
            BControlPoint bControlPoint = (BControlPoint)bComponent;
            BNdioProxyExt bNdioProxyExt = (BNdioProxyExt)bControlPoint.getProxyExt();
            this.pntType = bControlPoint.getType().getTypeInfo();
            this.extType = bNdioProxyExt.getType().getTypeInfo();
            this.converter = bNdioProxyExt.getConversion();
            this.displayName = this.converter instanceof BThermistorType3Conversion ? ndioLex.getText("type.NdioThermistorInputProxyExtPoint") : (this.pntType.is(BIWritablePoint.TYPE) ? ndioLex.getText("type." + this.extType.getTypeName() + "Writable") : ndioLex.getText("type." + this.extType.getTypeName() + "Point"));
        }
    }
}

