/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio.point;

import com.tridium.ndio.BNdioBoard;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.enums.BNdioIoTypeEnum;
import com.tridium.ndio.enums.BNdioPointTypeEnum;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNdioProxyExt
extends BProxyExt
implements BIPollable,
NdioConstants,
NdioPlatformServiceConstants {
    public static final Property conversion = BNdioProxyExt.newProperty((int)0, (BValue)BDefaultProxyConversion.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"ndio:NdioProxyConversionFE"));
    public static final Property pollFrequency = BNdioProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property pointType = BNdioProxyExt.newProperty((int)0, (BValue)BNdioPointTypeEnum.counterInput, null);
    public static final Property address = BNdioProxyExt.newProperty((int)0, (int)0, null);
    public static final Property previousAddress = BNdioProxyExt.newProperty((int)71, (int)0, null);
    public static final Property synced = BNdioProxyExt.newProperty((int)67, (boolean)false, null);
    public static final Property raw = BNdioProxyExt.newProperty((int)67, (int)0, null);
    public static final Type TYPE;
    protected static final Log log;
    private boolean configFault;
    static /* synthetic */ Class class$com$tridium$ndio$point$BNdioProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BNdioPointTypeEnum getPointType() {
        return (BNdioPointTypeEnum)this.get(pointType);
    }

    public void setPointType(BNdioPointTypeEnum bNdioPointTypeEnum) {
        this.set(pointType, (BValue)bNdioPointTypeEnum, null);
    }

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int n) {
        this.setInt(address, n, null);
    }

    public int getPreviousAddress() {
        return this.getInt(previousAddress);
    }

    public void setPreviousAddress(int n) {
        this.setInt(previousAddress, n, null);
    }

    public boolean getSynced() {
        return this.getBoolean(synced);
    }

    public void setSynced(boolean bl) {
        this.setBoolean(synced, bl, null);
    }

    public long getRaw() {
        return this.getLong(raw);
    }

    public void setRaw(long l) {
        this.setLong(raw, l, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
        }
        this.setPreviousAddress(this.getAddress());
    }

    public void readSubscribed(Context context) throws Exception {
        BNdioNetwork bNdioNetwork = this.getNdioNetwork();
        bNdioNetwork.getPollScheduler().subscribe(this);
    }

    public void readUnsubscribed(Context context) throws Exception {
        BNdioNetwork bNdioNetwork = this.getNdioNetwork();
        bNdioNetwork.getPollScheduler().unsubscribe(this);
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (bComponent instanceof BControlPoint) {
            return bComponent.getParent() instanceof BNdioPointDeviceExt;
        }
        return false;
    }

    public Type getDeviceExtType() {
        return BNdioPointDeviceExt.TYPE;
    }

    protected BNdioBoard getBoard() {
        return (BNdioBoard)this.getDevice();
    }

    protected BNdioNetwork getNdioNetwork() {
        return (BNdioNetwork)this.getNetwork();
    }

    protected BNdioPointDeviceExt getNdioPointDeviceExt() {
        return (BNdioPointDeviceExt)this.getDeviceExt();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)address) && this.getParentPoint() != null) {
            this.getNdioPointDeviceExt().handlePointChanged(this.getParentPoint());
            this.setPreviousAddress(this.getAddress());
            if (!this.isConfigFault()) {
                this.read();
            }
        }
    }

    public abstract void read();

    public boolean write(Context context) {
        return false;
    }

    public void configFail(String string) {
        this.setSynced(false);
        this.configFault = true;
        this.readFail(string);
    }

    public void configOk() {
        this.configFault = false;
        this.readReset();
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public abstract BNdioIoTypeEnum getIoType();

    protected boolean pointSynchronized() {
        if (!this.getNdioNetwork().isKeepAliveStarted()) {
            return false;
        }
        if (this.getBoard().isDown()) {
            return false;
        }
        if (this.getBoard().isFault()) {
            return false;
        }
        if (this.isFatalFault()) {
            return false;
        }
        if (this.isConfigFault()) {
            return false;
        }
        if (this.getSynced()) {
            return true;
        }
        this.setSynced(true);
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.configFault = true;
    }

    public BNdioProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$point$BNdioProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$point$BNdioProxyExt = BNdioProxyExt.class("[Lcom.tridium.ndio.point.BNdioProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"ndio");
    }
}

