/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NdioProperties {
    private static Hashtable properties = new Hashtable();
    private static final Log log = Log.getLog((String)"ndio");
    public static final NdioProperties DEFAULT = new NdioProperties();
    private int[] aoType;
    private int[] aoOverrideMap;
    private int[] doOverrideMap;
    private int configCode;
    private boolean multipleProcessors;
    private int uiCount;
    private int boCount;
    private int aoCount;
    private boolean uiBiEnabled;
    private boolean uiHsEnabled;
    private boolean uiThEnabled;
    private boolean uiPlEnabled;
    private boolean uiVEnabled;
    private boolean uiMaEnabled;

    public static NdioProperties make(int n) {
        log.trace("retrieving properties for config code " + n);
        if (n == 0) {
            return DEFAULT;
        }
        NdioProperties ndioProperties = (NdioProperties)properties.get(Integer.toString(n));
        if (ndioProperties == null) {
            try {
                ndioProperties = new NdioProperties(n);
            }
            catch (Exception exception) {
                log.error("error reading ndio.properties file", (Throwable)exception);
                return DEFAULT;
            }
            properties.put(Integer.toString(n), ndioProperties);
        }
        return ndioProperties;
    }

    private final void loadProperties() throws Exception {
        InputStream inputStream = null;
        Properties properties = new Properties();
        inputStream = this.getClass().getResourceAsStream("/lib/ndio.properties");
        properties.load(inputStream);
        inputStream.close();
        String string = Integer.toString(this.configCode);
        String string2 = properties.getProperty(string + ".multipleProcessors", "0");
        boolean bl = false;
        if (Integer.parseInt(string2) != 0) {
            bl = true;
        }
        this.multipleProcessors = bl;
        string2 = properties.getProperty(string + ".uicount", "0");
        this.uiCount = Integer.parseInt(string2);
        string2 = properties.getProperty(string + ".aocount", "0");
        this.aoCount = Integer.parseInt(string2);
        string2 = properties.getProperty(string + ".docount", "0");
        this.boCount = Integer.parseInt(string2);
        string2 = properties.getProperty(string + ".uidiEnabled", "0");
        boolean bl2 = false;
        if (Integer.parseInt(string2) != 0) {
            bl2 = true;
        }
        this.uiBiEnabled = bl2;
        string2 = properties.getProperty(string + ".uihsEnabled", "0");
        boolean bl3 = false;
        if (Integer.parseInt(string2) != 0) {
            bl3 = true;
        }
        this.uiHsEnabled = bl3;
        string2 = properties.getProperty(string + ".uithEnabled", "0");
        boolean bl4 = false;
        if (Integer.parseInt(string2) != 0) {
            bl4 = true;
        }
        this.uiThEnabled = bl4;
        string2 = properties.getProperty(string + ".uiplEnabled", "0");
        boolean bl5 = false;
        if (Integer.parseInt(string2) != 0) {
            bl5 = true;
        }
        this.uiPlEnabled = bl5;
        string2 = properties.getProperty(string + ".uivEnabled", "0");
        boolean bl6 = false;
        if (Integer.parseInt(string2) != 0) {
            bl6 = true;
        }
        this.uiVEnabled = bl6;
        string2 = properties.getProperty(string + ".uimaEnabled", "0");
        boolean bl7 = false;
        if (Integer.parseInt(string2) != 0) {
            bl7 = true;
        }
        this.uiMaEnabled = bl7;
        int n = 0;
        while (n < this.aoCount) {
            string2 = properties.getProperty(string + ".aoType." + String.valueOf(n), String.valueOf(this.aoType[n]));
            this.aoType[n] = Integer.parseInt(string2);
            string2 = properties.getProperty(string + ".aoOverrideMap." + String.valueOf(n), String.valueOf(this.aoOverrideMap[n]));
            this.aoOverrideMap[n] = Integer.parseInt(string2);
            ++n;
        }
        n = 0;
        while (n < this.boCount) {
            string2 = properties.getProperty(string + ".doOverrideMap." + String.valueOf(n), String.valueOf(this.doOverrideMap[n]));
            this.doOverrideMap[n] = Integer.parseInt(string2);
            ++n;
        }
    }

    public boolean getMultipleProcessors() {
        return this.multipleProcessors;
    }

    public int getUiCount() {
        return this.uiCount;
    }

    public int getBoCount() {
        return this.boCount;
    }

    public int getAoCount() {
        return this.aoCount;
    }

    public boolean getUiBiEnabled() {
        return this.uiBiEnabled;
    }

    public boolean getUiHsEnabled() {
        return this.uiHsEnabled;
    }

    public boolean getUiThEnabled() {
        return this.uiThEnabled;
    }

    public boolean getUiPlEnabled() {
        return this.uiPlEnabled;
    }

    public boolean getUiVEnabled() {
        return this.uiVEnabled;
    }

    public boolean getUiMaEnabled() {
        return this.uiMaEnabled;
    }

    public int getCount(int n) {
        switch (n) {
            case 0: {
                return this.getUiCount();
            }
            case 2: {
                return this.getAoCount();
            }
            case 3: {
                return this.getBoCount();
            }
        }
        return 0;
    }

    public int getAoType(int n) {
        return this.aoType[n - 1];
    }

    int getAoOverrideMap(int n) {
        return this.aoOverrideMap[n - 1] + 1;
    }

    int getDoOverrideMap(int n) {
        return this.doOverrideMap[n - 1] + 1;
    }

    private final /* synthetic */ void this() {
        this.aoType = new int[4];
        this.aoOverrideMap = new int[4];
        this.doOverrideMap = new int[16];
        this.configCode = 0;
        this.multipleProcessors = false;
        this.uiCount = 0;
        this.boCount = 0;
        this.aoCount = 0;
        this.uiBiEnabled = false;
        this.uiHsEnabled = false;
        this.uiThEnabled = false;
        this.uiPlEnabled = false;
        this.uiVEnabled = false;
        this.uiMaEnabled = false;
    }

    private NdioProperties() {
        this.this();
    }

    private NdioProperties(int n) throws Exception {
        this.this();
        this.configCode = n;
        this.loadProperties();
    }
}

