/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndio;

import com.tridium.ndio.BINdioRebootable;
import com.tridium.ndio.BNdioBoardFolder;
import com.tridium.ndio.BNdioNetwork;
import com.tridium.ndio.NdioConstants;
import com.tridium.ndio.NdioProcessor;
import com.tridium.ndio.NdioRebootException;
import com.tridium.ndio.point.BNdioPointDeviceExt;
import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import java.util.Properties;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNdioBoard
extends BDevice
implements BINdioRebootable,
NdioConstants,
NdioPlatformServiceConstants {
    public static final Property ioPort = BNdioBoard.newProperty((int)0, (int)0, null);
    public static final Property previousIoPort = BNdioBoard.newProperty((int)71, (int)0, null);
    public static final Property multipleProcessors = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property firmwareVersion = BNdioBoard.newProperty((int)3, (String)"-", null);
    public static final Property configCode = BNdioBoard.newProperty((int)3, (String)"-", null);
    public static final Property calibrated = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property boCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property aoCount = BNdioBoard.newProperty((int)3, (int)0, null);
    public static final Property uiBiEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiHsEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiThEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiPlEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiVEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property uiMaEnabled = BNdioBoard.newProperty((int)3, (boolean)false, null);
    public static final Property points = BNdioBoard.newProperty((int)0, (BValue)new BNdioPointDeviceExt(), null);
    public static final Property rebootConditionMet = BNdioBoard.newProperty((int)71, (boolean)false, null);
    public static final Type TYPE;
    private static Properties ndioProps;
    private static final Log log;
    public static int PING_OK;
    public static int PING_FAILED_DAEMON;
    public static int PING_FAILED_EXCEPTION;
    private NdioProcessor proc0;
    private NdioProcessor proc1;
    private int pingState;
    static /* synthetic */ Class class$com$tridium$ndio$BNdioBoard;

    public int getIoPort() {
        return this.getInt(ioPort);
    }

    public void setIoPort(int n) {
        this.setInt(ioPort, n, null);
    }

    public int getPreviousIoPort() {
        return this.getInt(previousIoPort);
    }

    public void setPreviousIoPort(int n) {
        this.setInt(previousIoPort, n, null);
    }

    public boolean getMultipleProcessors() {
        return this.getBoolean(multipleProcessors);
    }

    public void setMultipleProcessors(boolean bl) {
        this.setBoolean(multipleProcessors, bl, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String string) {
        this.setString(firmwareVersion, string, null);
    }

    public String getConfigCode() {
        return this.getString(configCode);
    }

    public void setConfigCode(String string) {
        this.setString(configCode, string, null);
    }

    public boolean getCalibrated() {
        return this.getBoolean(calibrated);
    }

    public void setCalibrated(boolean bl) {
        this.setBoolean(calibrated, bl, null);
    }

    public int getUiCount() {
        return this.getInt(uiCount);
    }

    public void setUiCount(int n) {
        this.setInt(uiCount, n, null);
    }

    public int getBoCount() {
        return this.getInt(boCount);
    }

    public void setBoCount(int n) {
        this.setInt(boCount, n, null);
    }

    public int getAoCount() {
        return this.getInt(aoCount);
    }

    public void setAoCount(int n) {
        this.setInt(aoCount, n, null);
    }

    public boolean getUiBiEnabled() {
        return this.getBoolean(uiBiEnabled);
    }

    public void setUiBiEnabled(boolean bl) {
        this.setBoolean(uiBiEnabled, bl, null);
    }

    public boolean getUiHsEnabled() {
        return this.getBoolean(uiHsEnabled);
    }

    public void setUiHsEnabled(boolean bl) {
        this.setBoolean(uiHsEnabled, bl, null);
    }

    public boolean getUiThEnabled() {
        return this.getBoolean(uiThEnabled);
    }

    public void setUiThEnabled(boolean bl) {
        this.setBoolean(uiThEnabled, bl, null);
    }

    public boolean getUiPlEnabled() {
        return this.getBoolean(uiPlEnabled);
    }

    public void setUiPlEnabled(boolean bl) {
        this.setBoolean(uiPlEnabled, bl, null);
    }

    public boolean getUiVEnabled() {
        return this.getBoolean(uiVEnabled);
    }

    public void setUiVEnabled(boolean bl) {
        this.setBoolean(uiVEnabled, bl, null);
    }

    public boolean getUiMaEnabled() {
        return this.getBoolean(uiMaEnabled);
    }

    public void setUiMaEnabled(boolean bl) {
        this.setBoolean(uiMaEnabled, bl, null);
    }

    public BNdioPointDeviceExt getPoints() {
        return (BNdioPointDeviceExt)this.get(points);
    }

    public void setPoints(BNdioPointDeviceExt bNdioPointDeviceExt) {
        this.set(points, (BValue)bNdioPointDeviceExt, null);
    }

    public boolean getRebootConditionMet() {
        return this.getBoolean(rebootConditionMet);
    }

    public void setRebootConditionMet(boolean bl) {
        this.setBoolean(rebootConditionMet, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getNdioNetwork().handleBoardChanged(this);
        this.setPreviousIoPort(this.getIoPort());
        this.doPing();
    }

    public Type getNetworkType() {
        return BNdioNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BNdioNetwork || bComponent instanceof BNdioBoardFolder) {
            bl = true;
        }
        return bl;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        BNdioPlatformService bNdioPlatformService = BNdioNetwork.getPlatformService();
        try {
            if (bNdioPlatformService.isDaemonOk() && this.getIoPort() > 0 && this.getIoPort() < 4) {
                this.processorSpyProps(spyWriter, NdioConstants.IO_PORT_TO_PROC_0[this.getIoPort()]);
                if (this.getMultipleProcessors()) {
                    this.processorSpyProps(spyWriter, NdioConstants.IO_PORT_TO_PROC_1[this.getIoPort()]);
                }
            }
        }
        catch (Exception exception) {}
        super.spy(spyWriter);
    }

    private final void processorSpyProps(SpyWriter spyWriter, int n) throws Exception {
        BNdioPlatformService bNdioPlatformService = BNdioNetwork.getPlatformService();
        spyWriter.startProps();
        spyWriter.trTitle((Object)("Ndio Processor " + n + "Extra Properties"), 2);
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = bNdioPlatformService.readIoType(n);
            n3 = bNdioPlatformService.readIoConfigState(n);
        }
        catch (Exception exception) {}
        if (n2 != 0 && n3 != 0 && n3 != 1) {
            spyWriter.prop((Object)"firstReadTicks", (Object)String.valueOf(bNdioPlatformService.getFirstReadTicks(n)));
            spyWriter.prop((Object)"ioBoardType", n2);
            spyWriter.prop((Object)"ioFirmware", (Object)("" + bNdioPlatformService.getFirmwareIntfNum(n) + '.' + bNdioPlatformService.getFirmwareBuildNum(n)));
            spyWriter.prop((Object)"configCode", bNdioPlatformService.readConfigCode(n) & 0xFFFFFF);
            spyWriter.prop((Object)"ioConfigState", n3);
            spyWriter.prop((Object)"calibrated", bNdioPlatformService.isProcessorCalibrated(n));
            spyWriter.prop((Object)"successTicks", (Object)String.valueOf(bNdioPlatformService.getSuccessTicks(n)));
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < 8) {
                stringBuffer.append("[").append(bNdioPlatformService.readUIType(n, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"definitionUIs", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 8) {
                stringBuffer.append("[").append(bNdioPlatformService.readValue(n, 0, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"uiInValues", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 8) {
                stringBuffer.append("[").append(bNdioPlatformService.readUICount(n, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"uiInCounts", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 16) {
                stringBuffer.append("[").append(bNdioPlatformService.readValue(n, 1, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"ovrInValues", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 16) {
                stringBuffer.append("[").append(bNdioPlatformService.readValue(n, 3, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"doInValues", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 16) {
                stringBuffer.append("[").append(bNdioPlatformService.readOutValue(n, 3, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"doOutValues", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 4) {
                stringBuffer.append("[").append(bNdioPlatformService.readValue(n, 2, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"aoInValues", (Object)stringBuffer.toString());
            stringBuffer = new StringBuffer();
            n4 = 0;
            while (n4 < 4) {
                stringBuffer.append("[").append(bNdioPlatformService.readOutValue(n, 2, n4)).append("]");
                ++n4;
            }
            spyWriter.prop((Object)"aoOutValues", (Object)stringBuffer.toString());
        } else {
            spyWriter.prop((Object)"state", (Object)"undefined");
        }
        spyWriter.endProps();
    }

    public BNdioNetwork getNdioNetwork() {
        return (BNdioNetwork)this.getNetwork();
    }

    protected IFuture postPing() {
        try {
            this.doPing();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public synchronized void doPing() {
        block11: {
            if (!Sys.atSteadyState()) {
                return;
            }
            if (this.isConfigFault() || this.isFatalFault()) {
                return;
            }
            log.trace("pinging board @ " + this.getIoPort());
            if (BNdioNetwork.getPlatformService() != null) {
                if (!BNdioNetwork.getPlatformService().isDaemonOk()) {
                    if (this.getNdioNetwork().hadSuccessfulPing()) {
                        this.setRebootConditionMet(true);
                    }
                    this.pingFail("board @ " + this.getIoPort() + " failed because it couldn't find ndio daemon");
                    if (this.pingState != PING_FAILED_DAEMON) {
                        log.error("board @ " + this.getIoPort() + " failed because it couldn't find ndio daemon");
                        this.pingState = PING_FAILED_DAEMON;
                    }
                    return;
                }
                try {
                    this.proc0.ping();
                    if (this.getMultipleProcessors()) {
                        this.proc1.ping();
                    }
                    this.pingOk();
                    this.pingState = PING_OK;
                }
                catch (NdioRebootException ndioRebootException) {
                    this.setRebootConditionMet(true);
                    this.pingFail(ndioRebootException.getMessage());
                    if (this.pingState != PING_FAILED_EXCEPTION) {
                        log.error(ndioRebootException.getMessage());
                        this.pingState = PING_FAILED_EXCEPTION;
                    }
                }
                catch (Exception exception) {
                    this.pingFail(exception.getMessage());
                    if (this.pingState == PING_FAILED_EXCEPTION) break block11;
                    log.error(exception.getMessage());
                    this.pingState = PING_FAILED_EXCEPTION;
                }
            }
        }
    }

    public int getCount(int n) {
        switch (n) {
            case 0: {
                return this.getUiCount();
            }
            case 2: {
                return this.getAoCount();
            }
            case 3: {
                return this.getBoCount();
            }
        }
        return 0;
    }

    public int getAoType(int n) {
        int n2 = this.proc0.getAoCount();
        if (n > n2) {
            return this.proc1.getAoType(n -= n2);
        }
        return this.proc0.getAoType(n);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && BNdioNetwork.getPlatformService() != null && property == ioPort) {
            this.getNdioNetwork().handleBoardChanged(this);
            this.getPoints().resetPoints();
            this.setPreviousIoPort(this.getIoPort());
            if (!this.isConfigFault()) {
                try {
                    this.doPing();
                }
                catch (Exception exception) {
                    log.error("deviceChanged: " + exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    public int readUIType(int n) throws Exception {
        NdioProcessor ndioProcessor;
        if (n > this.proc0.getUiCount()) {
            ndioProcessor = this.proc1;
            n -= this.proc0.getUiCount();
        } else {
            ndioProcessor = this.proc0;
        }
        return ndioProcessor.readUIType(n);
    }

    public void writeUIType(int n, int n2) throws Exception {
        NdioProcessor ndioProcessor;
        if (n > this.proc0.getUiCount()) {
            ndioProcessor = this.proc1;
            n -= this.proc0.getUiCount();
        } else {
            ndioProcessor = this.proc0;
        }
        ndioProcessor.writeUIType(n, n2);
    }

    public int readValue(int n, int n2) throws Exception {
        NdioProcessor ndioProcessor;
        if (n2 > this.proc0.getCount(n)) {
            ndioProcessor = this.proc1;
            n2 -= this.proc0.getCount(n);
        } else {
            ndioProcessor = this.proc0;
        }
        return ndioProcessor.readValue(n, n2);
    }

    public boolean readOverrideValue(int n, int n2) throws Exception {
        NdioProcessor ndioProcessor;
        if (n2 > this.proc0.getCount(n)) {
            ndioProcessor = this.proc1;
            n2 -= this.proc0.getCount(n);
        } else {
            ndioProcessor = this.proc0;
        }
        int n3 = 0;
        switch (n) {
            case 3: {
                n3 = ndioProcessor.getDoOverrideMap(n2);
                break;
            }
            case 2: {
                n3 = ndioProcessor.getAoOverrideMap(n2);
                break;
            }
            default: {
                return false;
            }
        }
        int n4 = ndioProcessor.readValue(1, n3);
        int n5 = 0;
        if (n4 != 0) {
            n5 = 1;
        }
        boolean bl = 1 - n5;
        return bl;
    }

    public void writeValue(int n, int n2, int n3) throws Exception {
        NdioProcessor ndioProcessor;
        if (n2 > this.proc0.getCount(n)) {
            ndioProcessor = this.proc1;
            n2 -= this.proc0.getCount(n);
        } else {
            ndioProcessor = this.proc0;
        }
        ndioProcessor.writeValue(n, n2, n3);
    }

    public long readUICount(int n) throws Exception {
        NdioProcessor ndioProcessor;
        if (n > this.proc0.getUiCount()) {
            ndioProcessor = this.proc1;
            n -= this.proc0.getUiCount();
        } else {
            ndioProcessor = this.proc0;
        }
        return ndioProcessor.readUICount(n);
    }

    public long readUICountDelta(int n) throws Exception {
        NdioProcessor ndioProcessor;
        if (n > this.proc0.getUiCount()) {
            ndioProcessor = this.proc1;
            n -= this.proc0.getUiCount();
        } else {
            ndioProcessor = this.proc0;
        }
        return ndioProcessor.readUICountDelta(n);
    }

    public void initDevice() {
        if (BNdioNetwork.getPlatformService() != null) {
            try {
                this.proc0 = new NdioProcessor(this.getIoPort(), true);
                boolean bl = BNdioNetwork.getPlatformService().isProcessorCalibrated(this.proc0.getHdwrAddress());
                int n = BNdioNetwork.getPlatformService().readConfigCode(this.proc0.getHdwrAddress());
                this.setMultipleProcessors(this.proc0.getMultipleProcessors());
                if (this.getMultipleProcessors()) {
                    this.proc1 = new NdioProcessor(this.getIoPort(), false);
                    bl &= BNdioNetwork.getPlatformService().isProcessorCalibrated(this.proc1.getHdwrAddress());
                    this.setFirmwareVersion(this.proc0.getFirmwareVersion() + '/' + this.proc1.getFirmwareVersion());
                    this.setConfigCode(String.valueOf(this.proc0.getConfigCode()) + '/' + String.valueOf(this.proc1.getConfigCode()));
                } else {
                    this.proc1 = new NdioProcessor();
                    this.setFirmwareVersion(this.proc0.getFirmwareVersion());
                    this.setConfigCode(String.valueOf(this.proc0.getConfigCode()));
                }
                this.setCalibrated(bl);
                this.setUiCount(this.proc0.getUiCount() + this.proc1.getUiCount());
                this.setBoCount(this.proc0.getBoCount() + this.proc1.getBoCount());
                this.setAoCount(this.proc0.getAoCount() + this.proc1.getAoCount());
                this.setUiBiEnabled(this.proc0.getUiBiEnabled() | this.proc1.getUiBiEnabled());
                this.setUiHsEnabled(this.proc0.getUiHsEnabled() | this.proc1.getUiHsEnabled());
                this.setUiThEnabled(this.proc0.getUiThEnabled() | this.proc1.getUiThEnabled());
                this.setUiPlEnabled(this.proc0.getUiPlEnabled() | this.proc1.getUiPlEnabled());
                this.setUiVEnabled(this.proc0.getUiVEnabled() | this.proc1.getUiVEnabled());
                this.setUiMaEnabled(this.proc0.getUiMaEnabled() | this.proc1.getUiMaEnabled());
            }
            catch (Exception exception) {
                log.error("Unable to init ndio device at ioPort <" + this.getIoPort() + '>');
                this.proc1 = new NdioProcessor(this.getIoPort(), false);
            }
        }
    }

    private final void resetDevice() {
        this.setMultipleProcessors(false);
        this.setFirmwareVersion("-");
        this.setConfigCode("-");
        this.setCalibrated(false);
        this.setUiCount(0);
        this.setBoCount(0);
        this.setAoCount(0);
        this.setUiBiEnabled(false);
        this.setUiHsEnabled(false);
        this.setUiThEnabled(false);
        this.setUiPlEnabled(false);
        this.setUiVEnabled(false);
        this.setUiMaEnabled(false);
    }

    public boolean isConfigFault() {
        boolean bl = false;
        if (this.isFault() && !this.isFatalFault() && !this.getNetwork().isFault()) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.proc0 = new NdioProcessor();
        this.proc1 = new NdioProcessor();
        this.pingState = PING_OK;
    }

    public BNdioBoard() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ndio$BNdioBoard;
        if (clazz == null) {
            clazz = class$com$tridium$ndio$BNdioBoard = BNdioBoard.class("[Lcom.tridium.ndio.BNdioBoard;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ndioProps = null;
        log = Log.getLog((String)"ndio");
        PING_OK = 0;
        PING_FAILED_DAEMON = 1;
        PING_FAILED_EXCEPTION = 3;
    }
}

