/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.app;

import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import javax.baja.app.BAppContainer;
import javax.baja.app.BIAppComponent;
import javax.baja.app.BIAppFolder;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BApp
extends BComponent
implements BIService,
BIStatus,
ServiceListener,
BIAppComponent,
BILicensed {
    public static final Property status = BApp.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BApp.newProperty((int)3, (String)"", null);
    public static final Property enabled = BApp.newProperty((int)0, (boolean)true, null);
    public static final Property version = BApp.newProperty((int)1, (String)"", null);
    public static final Action update = BApp.newAction((int)20, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final Log log;
    private static final Type[] noTypes;
    private boolean fatalFault;
    private String fatalFaultCause;
    private boolean servicesFault;
    private String servicesFaultCause;
    private boolean configFault;
    private String configFaultCause;
    private BAppContainer container;
    static /* synthetic */ Class class$javax$baja$app$BApp;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getVersion() {
        return this.getString(version);
    }

    public void setVersion(String string) {
        this.setString(version, string, null);
    }

    public void update() {
        this.invoke(update, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getRequiredServices() {
        return noTypes;
    }

    public String getAppId() {
        return this.getType().toString();
    }

    public String getAppDisplayName(Context context) {
        return this.getDisplayName(context);
    }

    public BIcon getAppDisplayIcon() {
        return this.getIcon();
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    protected void appOk() {
    }

    protected void appFail() {
    }

    protected static final Type[] append(Type[] typeArray, Type type) {
        return BApp.append(typeArray, new Type[]{type});
    }

    protected static final Type[] append(Type[] typeArray, Type[] typeArray2) {
        Type[] typeArray3 = new Type[typeArray.length + typeArray2.length];
        System.arraycopy(typeArray, 0, typeArray3, 0, typeArray.length);
        System.arraycopy(typeArray2, 0, typeArray3, typeArray.length, typeArray2.length);
        return typeArray3;
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIAppFolder;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 16: {
                this.fwServiceStopped();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)object);
                break;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwServiceStarted() {
        this.setVersion(this.getType().getModule().getVendorVersion().toString());
        this.container = (BAppContainer)Sys.getService((Type)BAppContainer.TYPE);
        Nre.serviceManager.addServiceListener((ServiceListener)this);
        this.checkLicense();
        this.update();
    }

    private final void fwServiceStopped() {
        Nre.serviceManager.removeServiceListener((ServiceListener)this);
    }

    private final void fwDescendantsStarted() {
        this.update();
    }

    private final void fwChanged(Property property) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled)) {
            this.update();
        }
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isOperational() {
        if (this.fatalFault) {
            return false;
        }
        return BApp.isOperational(this.getStatus());
    }

    private static final boolean isOperational(BStatus bStatus) {
        boolean bl = false;
        if (!bStatus.isDisabled() && !bStatus.isFault()) {
            bl = true;
        }
        return bl;
    }

    public void doUpdate() {
        if (!this.isRunning()) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("App Update: " + this.getType());
        }
        this.checkServices();
        boolean bl = this.isDisabled() ^ true;
        BStatus bStatus = this.getStatus();
        int n = 0;
        if (!this.getEnabled()) {
            n |= 1;
        }
        String string = "";
        if (this.fatalFault) {
            n |= 2;
            string = this.fatalFaultCause;
        } else if (this.servicesFault) {
            n |= 2;
            string = this.servicesFaultCause;
        } else if (this.configFault) {
            n |= 2;
            string = this.configFaultCause;
        }
        if (!this.getFaultCause().equals(string)) {
            this.setFaultCause(string);
        }
        if (bStatus.getBits() == n) {
            return;
        }
        BStatus bStatus2 = BStatus.make((int)n);
        this.setStatus(bStatus2);
        if (BApp.isOperational(bStatus) && !BApp.isOperational(bStatus2)) {
            this.appFail();
        } else if (!BApp.isOperational(bStatus) && BApp.isOperational(bStatus2)) {
            this.appOk();
        }
        boolean bl2 = this.isDisabled() ^ true;
        if (bl != bl2) {
            if (bl2) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
        if (Sys.atSteadyState()) {
            this.container.fireAppsModified(null);
        }
    }

    private final void checkServices() {
        this.servicesFault = false;
        Type[] typeArray = this.getRequiredServices();
        int n = 0;
        while (n < typeArray.length) {
            try {
                Sys.getService((Type)typeArray[n]);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                this.servicesFault = true;
                this.servicesFaultCause = "Missing required service: " + typeArray[n].toString();
                break;
            }
            ++n;
        }
        if (!this.servicesFault) {
            this.servicesFaultCause = "";
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final boolean isConfigFault() {
        return this.configFault;
    }

    public final boolean isServicesFault() {
        return this.servicesFault;
    }

    public final void configOk() {
        this.configFault = false;
        this.configFaultCause = "";
        this.update();
    }

    public final void configFail(String string) {
        this.configFault = true;
        this.configFaultCause = string;
        this.update();
    }

    public final void configFatal(String string) {
        this.fatalFault = true;
        this.fatalFaultCause = string;
        this.update();
    }

    public Feature getLicenseFeature() {
        return null;
    }

    private final void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
        }
        catch (Exception exception) {
            this.fatalFault = true;
            this.fatalFaultCause = "Unlicensed: " + exception;
            Log.getLog((String)"service").error("Unlicensed: " + this.toPathString(), (Throwable)exception);
        }
    }

    public final void serviceEvent(BServiceEvent bServiceEvent) {
        if (bServiceEvent.getId() == 0 || bServiceEvent.getId() == 1) {
            this.update();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFaultCause = "";
        this.servicesFaultCause = "";
        this.configFaultCause = "";
        this.container = null;
    }

    public BApp() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$app$BApp;
        if (clazz == null) {
            clazz = class$javax$baja$app$BApp = BApp.class("[Ljavax.baja.app.BApp;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"app.png");
        log = Log.getLog((String)"app");
        noTypes = new Type[0];
    }
}

