/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.tcp;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.DebugStream;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BTcpCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.spy.SpyWriter;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TcpLinkLayer
implements ILinkLayer {
    private static int nextSessionId = 1;
    Vector evlisteners;
    private Log log;
    private NComm comm;
    private BTcpCommConfig comCfg;
    private NLinkMessageFactory lnkFac;
    private ServerSocket srvSock;
    private boolean done;
    private Statistics stats;
    Hashtable sessions;
    IntHashMap sessionsById;
    LinkServer receive;
    Thread rcvThread;

    public void start() throws Exception {
        this.log().trace("start TcpLinkLayer");
        this.done = false;
        InetAddress inetAddress = this.myIp();
        this.srvSock = inetAddress == null ? new ServerSocket(this.myPort()) : new ServerSocket(this.myPort(), 5, inetAddress);
        this.receive = new LinkServer();
        this.rcvThread = new Thread((Runnable)this.receive, this.comCfg.getResourcePrefix() + ".LinkServer");
        this.rcvThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        try {
            this.done = true;
            if (this.srvSock != null) {
                this.srvSock.close();
            }
        }
        catch (Throwable throwable) {}
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            LinkSession linkSession = (LinkSession)enumeration.nextElement();
            LinkSession linkSession2 = linkSession;
            synchronized (linkSession2) {
                linkSession.listening = false;
                linkSession.close();
                linkSession.notify();
            }
        }
        this.sessions.clear();
    }

    public void verifySettings(BCommConfig bCommConfig) throws Exception {
        if (this.srvSock == null || this.srvSock.getLocalPort() != this.myPort()) {
            ServerSocket serverSocket = this.srvSock;
            this.srvSock = new ServerSocket(this.myPort());
            serverSocket.close();
        }
    }

    private final int myPort() {
        return this.comCfg.getAddress().getPort();
    }

    private final InetAddress myIp() {
        BIpAddress bIpAddress = this.comCfg.getAddress();
        if (bIpAddress.getIpAddress().equalsIgnoreCase("local")) {
            return null;
        }
        return bIpAddress.getInetAddress();
    }

    public void sendMessage(LinkMessage linkMessage) throws Exception {
        String string;
        if (this.done) {
            return;
        }
        BIpAddress bIpAddress = (BIpAddress)((Object)linkMessage.address);
        LinkSession linkSession = (LinkSession)this.sessionsById.get(bIpAddress.getSessionId());
        if (linkSession == null && (linkSession = (LinkSession)this.sessions.get(string = linkMessage.address.toString())) == null) {
            linkSession = new LinkSession((BIpAddress)((Object)linkMessage.address));
            this.log().trace("created LinkSession for " + linkMessage.address);
            this.sessions.put(string, linkSession);
        }
        this.log().trace("sendMessage to " + linkMessage.address);
        linkSession.doSend(linkMessage);
        ++this.stats.msgSent;
    }

    public int createSession(BIpAddress bIpAddress) throws Exception {
        int n = this.getNextSessionId();
        LinkSession linkSession = new LinkSession(bIpAddress, n);
        this.sessionsById.put(n, (Object)linkSession);
        this.log().trace("created LinkSession " + n + " for " + (Object)((Object)bIpAddress));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSession(int n) throws Exception {
        LinkSession linkSession = (LinkSession)this.sessionsById.remove(n);
        if (linkSession == null) {
            return;
        }
        this.log().trace("close LinkSession " + n + " for " + (Object)((Object)linkSession.addr));
        LinkSession linkSession2 = linkSession;
        synchronized (linkSession2) {
            linkSession.listening = false;
            linkSession.close();
            linkSession.notify();
            return;
        }
    }

    private final synchronized int getNextSessionId() {
        int n = nextSessionId++;
        if (nextSessionId < 0) {
            nextSessionId = 1;
        }
        return n;
    }

    public void registerTcpEvenListener(ITcpEventListener iTcpEventListener) {
        if (!this.evlisteners.contains(iTcpEventListener)) {
            this.evlisteners.add(iTcpEventListener);
        }
    }

    public void unregisterTcpEvenListener(ITcpEventListener iTcpEventListener) {
        this.evlisteners.remove(iTcpEventListener);
    }

    private final void socketTerminated(BIpAddress bIpAddress, boolean bl) {
        int n = 0;
        while (n < this.evlisteners.size()) {
            ((ITcpEventListener)this.evlisteners.elementAt(n)).socketTerminated(bIpAddress, bl);
            ++n;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        LinkSession[] linkSessionArray;
        spyWriter.startProps("TcpLinkLayer");
        spyWriter.prop((Object)"done", this.done);
        spyWriter.prop((Object)"srvSock inet address", (Object)(this.srvSock != null ? this.srvSock.getInetAddress().toString() : "n/a"));
        spyWriter.prop((Object)"srvSock port", (Object)(this.srvSock != null ? Integer.toString(this.srvSock.getLocalPort()) : "n/a"));
        spyWriter.prop((Object)"number of linkSessions", this.sessions.size());
        spyWriter.endProps();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"sessions", 8);
        spyWriter.w((Object)"<tr>").th((Object)"id").th((Object)"server").th((Object)"ip").th((Object)"port").th((Object)"myPort").th((Object)"bound").th((Object)"listening").th((Object)"soTimeout").w((Object)"</tr>\n");
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            linkSessionArray = (LinkSession[])enumeration.nextElement();
            this.spySession(spyWriter, (LinkSession)linkSessionArray);
        }
        spyWriter.endTable();
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"sessionsById", 8);
        spyWriter.w((Object)"<tr>").th((Object)"id").th((Object)"server").th((Object)"ip").th((Object)"port").th((Object)"myPort").th((Object)"bound").th((Object)"listening").th((Object)"soTimeout").w((Object)"</tr>\n");
        linkSessionArray = (LinkSession[])this.sessionsById.toArray((Object[])new LinkSession[this.sessionsById.size()]);
        int n = 0;
        while (n < linkSessionArray.length) {
            this.spySession(spyWriter, linkSessionArray[n]);
            ++n;
        }
        spyWriter.endTable();
        SpyUtil.spy(spyWriter, "TcpLink Statistics", this.stats);
    }

    private final void spySession(SpyWriter spyWriter, LinkSession linkSession) {
        String string = "n/a";
        try {
            string = Integer.toString(linkSession.sock.getSoTimeout());
        }
        catch (Throwable throwable) {}
        spyWriter.w((Object)"<tr>");
        spyWriter.td((Object)Integer.toString(linkSession.addr.getSessionId()));
        spyWriter.td((Object)Boolean.toString(linkSession.server));
        spyWriter.td((Object)linkSession.addr.getIpAddress());
        spyWriter.td((Object)(linkSession.sock != null ? Integer.toString(linkSession.sock.getPort()) : "n/a"));
        spyWriter.td((Object)(linkSession.sock != null ? Integer.toString(linkSession.sock.getLocalPort()) : "n/a"));
        spyWriter.td((Object)(linkSession.sock != null ? Boolean.toString(linkSession.sock.isBound()) : "n/a"));
        spyWriter.td((Object)Boolean.toString(linkSession.listening));
        spyWriter.td((Object)string);
        spyWriter.w((Object)"</tr>\n");
    }

    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)(this.comCfg.getResourcePrefix() + ".Link"));
        }
        return this.log;
    }

    private final /* synthetic */ void this() {
        this.evlisteners = new Vector();
        this.srvSock = null;
        this.done = true;
        this.stats = new Statistics();
        this.sessions = new Hashtable(30);
        this.sessionsById = new IntHashMap(30);
        this.receive = null;
    }

    public TcpLinkLayer(NComm nComm, BTcpCommConfig bTcpCommConfig) {
        this.this();
        this.comm = nComm;
        this.comCfg = bTcpCommConfig;
        this.lnkFac = bTcpCommConfig.getLinkMessageFactory();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkServer
    implements Runnable {
        int cnt;

        public void run() {
            while (!TcpLinkLayer.this.done) {
                try {
                    Socket socket = TcpLinkLayer.this.srvSock.accept();
                    LinkSession linkSession = new LinkSession(socket);
                    Thread thread = new Thread((Runnable)linkSession, TcpLinkLayer.this.comCfg.getResourcePrefix() + ".In.LinkSession" + this.cnt++);
                    thread.start();
                    ++((TcpLinkLayer)TcpLinkLayer.this).stats.acceptedConnections;
                }
                catch (Throwable throwable) {
                    if (TcpLinkLayer.this.done) {
                        return;
                    }
                    throwable.printStackTrace();
                    TcpLinkLayer.this.log().error("Exception caught in LinkReceiver. " + throwable);
                }
            }
        }

        private final /* synthetic */ void this() {
            this.cnt = 0;
        }

        private LinkServer() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkSession
    implements Runnable {
        Socket sock;
        BIpAddress addr;
        boolean listening;
        boolean server;
        boolean sent;
        int timeOut;
        DebugStream debIn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            LinkSession linkSession = this;
            synchronized (linkSession) {
                this.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                this.listening = true;
            }
            try {
                this.sock.setSoTimeout(this.timeOut);
            }
            catch (SocketException socketException) {
                TcpLinkLayer.this.log().error("Unable to set socket timeout " + (Object)((Object)this.addr), (Throwable)socketException);
            }
            while (this.listening) {
                boolean bl = TcpLinkLayer.this.log().isTraceOn();
                try {
                    LinkMessage linkMessage = TcpLinkLayer.this.lnkFac.getLinkMessage();
                    linkMessage.address = this.addr;
                    InputStream inputStream = this.sock.getInputStream();
                    if (bl) {
                        inputStream = this.debIn.reset(inputStream);
                    }
                    boolean bl2 = linkMessage.receive(inputStream);
                    if (bl && this.debIn.hasDebug()) {
                        TcpLinkLayer.this.log().trace("rcvd:" + (bl2 ? "" : "frag:") + this.debIn.debugString());
                    }
                    if (bl2) {
                        TcpLinkLayer.this.comm.receiveMessage(linkMessage);
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.msgReceived;
                        this.sent = false;
                        continue;
                    }
                    TcpLinkLayer.this.lnkFac.releaseLinkMessage(linkMessage);
                    if (this.listening) {
                        TcpLinkLayer.this.log().trace("Remote socket closed for " + (Object)((Object)this.addr));
                    }
                    this.terminate();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.sent) continue;
                    if (this.listening) {
                        TcpLinkLayer.this.log().trace("Timeout LinkSession for " + (Object)((Object)this.addr));
                        if (bl) {
                            socketTimeoutException.printStackTrace();
                        }
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.receiveError;
                    }
                    this.terminate();
                }
                catch (Throwable throwable) {
                    if (this.listening) {
                        TcpLinkLayer.this.log().error("Exception caught in LinkReceiver for " + (Object)((Object)this.addr) + '\n');
                        if (bl) {
                            throwable.printStackTrace();
                        }
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.receiveError;
                    }
                    this.terminate();
                }
            }
        }

        private final synchronized void listen() throws Exception {
            Object object;
            if (this.sock == null) {
                this.sock = new Socket();
            }
            if (!this.sock.isConnected()) {
                try {
                    TcpLinkLayer.this.log().trace("connect socket " + (Object)((Object)this.addr));
                    object = new InetSocketAddress(this.addr.getInetAddress(), this.addr.getPort());
                    this.sock.connect((SocketAddress)object, 1000);
                }
                catch (Exception exception) {
                    this.sock = null;
                    throw new NCommException("Can not connect to " + (Object)((Object)this.addr), exception);
                }
            }
            if (!this.listening) {
                TcpLinkLayer.this.log().trace("start rcvThread " + (Object)((Object)this.addr));
                object = new Thread((Runnable)this, TcpLinkLayer.this.comCfg.getResourcePrefix() + ".LinkSession");
                ((Thread)object).start();
                try {
                    this.wait(1000L);
                }
                catch (Throwable throwable) {}
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doSend(LinkMessage linkMessage) throws Exception {
            try {
                this.listen();
                if (TcpLinkLayer.this.log().isTraceOn()) {
                    TcpLinkLayer.this.log().trace("send:" + DrByteArrayUtil.toString((byte[])linkMessage.getByteArray(), (int)linkMessage.getLength()));
                }
                this.sock.getOutputStream().write(linkMessage.getByteArray(), 0, linkMessage.getLength());
                this.sent = true;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                TcpLinkLayer.this.lnkFac.releaseLinkMessage(linkMessage);
                throw throwable;
            }
            {
                Object var3_4 = null;
                TcpLinkLayer.this.lnkFac.releaseLinkMessage(linkMessage);
                return;
            }
        }

        void close() {
            this.listening = false;
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable throwable) {
                System.out.println("close Can't close sock: " + throwable);
            }
        }

        void terminate() {
            TcpLinkLayer.this.log().trace("terminate " + (Object)((Object)this.addr));
            this.listening = false;
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable throwable) {
                System.out.println("terminate Can't close sock: " + throwable);
            }
            TcpLinkLayer.this.sessions.remove(this.addr.toString());
            TcpLinkLayer.this.sessionsById.remove(this.addr.getSessionId());
            TcpLinkLayer.this.socketTerminated(this.addr, this.server);
        }

        private final /* synthetic */ void this() {
            this.listening = false;
            this.sent = false;
            this.timeOut = 0;
            this.debIn = new DebugStream(TcpLinkLayer.this.lnkFac.getLinkMaxLength());
        }

        LinkSession(BIpAddress bIpAddress) throws Exception {
            this.this();
            this.addr = (BIpAddress)bIpAddress.newCopy(true);
            this.server = false;
            this.timeOut = TcpLinkLayer.this.comCfg.getSendSocketTO() * 1000;
        }

        LinkSession(BIpAddress bIpAddress, int n) throws Exception {
            this.this();
            this.addr = (BIpAddress)bIpAddress.newCopy(true);
            this.addr.setSessionId(n);
            this.server = false;
            this.timeOut = 0;
        }

        LinkSession(Socket socket) throws Exception {
            this.this();
            this.sock = socket;
            this.addr = new BIpAddress(this.sock.getInetAddress(), this.sock.getPort());
            this.addr.setSessionId(TcpLinkLayer.this.getNextSessionId());
            TcpLinkLayer.this.sessions.put(this.addr.toString(), this);
            this.server = true;
            this.timeOut = TcpLinkLayer.this.comCfg.getServerSocketTO() * 1000;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Statistics {
        public long msgSent;
        public long msgReceived;
        public long receiveError;
        public long acceptedConnections;

        private final /* synthetic */ void this() {
            this.msgSent = 0L;
            this.msgReceived = 0L;
            this.receiveError = 0L;
            this.acceptedConnections = 0L;
        }

        public Statistics() {
            this.this();
        }
    }
}

