/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.serial;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.DebugStream;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BSerialCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.io.InputStream;
import javax.baja.log.Log;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SerialLinkLayer
implements ILinkLayer {
    private static final int UNAVAILABLE = 1;
    private static final int RECEIVING = 2;
    private static final int TUNNEL_WAIT = 3;
    private static final int TUNNELING = 4;
    private static final int DONE = 5;
    DebugStream debIn;
    private Log log;
    private NComm comm;
    private BSerialCommConfig serCfg;
    private NLinkMessageFactory lnkFac;
    private BISerialPort port;
    private String portName;
    private Statistics stats;
    private int state;
    LinkReceive receive;
    Thread rcvThread;

    public void start() throws Exception {
        this.log().trace("start SerialLinkLayer");
        this.state = 1;
        this.receive = new LinkReceive();
        this.rcvThread = new Thread((Runnable)this.receive, this.serCfg.getResourcePrefix() + ".LinkReceive");
        this.rcvThread.start();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        try {
            this.state = 5;
            LinkReceive linkReceive = this.receive;
            synchronized (linkReceive) {
                this.receive.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                if (this.rcvThread != null) {
                    this.rcvThread.interrupt();
                }
                this.rcvThread = null;
                this.closePort();
                return;
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void verifySettings(BCommConfig bCommConfig) throws Exception {
        this.serCfg = (BSerialCommConfig)bCommConfig;
        if (this.port == null || !this.portName.equals(this.serCfg.getPortName())) {
            this.stop();
            this.start();
        } else if (!(this.port.getFlowControlMode().equals((Object)this.serCfg.getFlowControlMode()) && this.port.getBaudRate().equals((Object)this.serCfg.getBaudRate()) && this.port.getDataBits().equals((Object)this.serCfg.getDataBits()) && this.port.getStopBits().equals((Object)this.serCfg.getStopBits()) && this.port.getParity().equals((Object)this.serCfg.getParity()))) {
            this.setCommParams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void open() throws Exception {
        BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        ((BComponent)bISerialService).lease();
        try {
            this.portName = this.serCfg.getPortName();
            if (this.portName.equals("none")) {
                throw new BajaRuntimeException("comm port not initialized");
            }
            this.port = bISerialService.openPort(this.portName, this.serCfg.getResourcePrefix());
        }
        catch (PortNotFoundException portNotFoundException) {
            String string = "'" + this.serCfg.getPortName() + "' not a valid comm port.";
            this.reportFault(string, (Exception)((Object)portNotFoundException));
        }
        catch (PortDeniedException portDeniedException) {
            String string = "Denied opening comm port '" + this.serCfg.getPortName() + '\'';
            this.reportFault(string, (Exception)((Object)portDeniedException));
        }
        catch (Exception exception) {
            String string = "Exception opening comm port '" + this.serCfg.getPortName() + '\'';
            this.reportFault(string, exception);
        }
        this.setCommParams();
        LinkReceive linkReceive = this.receive;
        synchronized (linkReceive) {
            this.state = 2;
            this.receive.notify();
            return;
        }
    }

    private final void setCommParams() throws Exception {
        String string;
        try {
            this.port.setSerialPortParams(this.serCfg.getBaudRate(), this.serCfg.getDataBits(), this.serCfg.getStopBits(), this.serCfg.getParity());
            this.port.setFlowControlMode(this.serCfg.getFlowControlMode());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string = "Unsupported comm parameter for " + this.serCfg.getPortName();
            this.reportFault(string, unsupportedOperationException);
        }
        catch (Exception exception) {
            string = "Exception setting comm parameters for " + this.serCfg.getPortName();
            this.reportFault(string, exception);
        }
        try {
            int n = this.serCfg.getReceiveTimeout();
            if (n == 0) {
                this.port.disableReceiveTimeout();
            } else {
                this.port.enableReceiveTimeout(n);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string = "Can't set receiveTimeout on " + this.serCfg.getPortName();
            this.reportFault(string, unsupportedOperationException);
        }
    }

    private final void reportFault(String string, Exception exception) throws Exception {
        this.log().error(string, (Throwable)exception);
        this.state = 1;
        this.closePort();
        throw exception;
    }

    private final void closePort() {
        if (this.port == null) {
            return;
        }
        try {
            this.port.close();
        }
        catch (Throwable throwable) {}
        this.port = null;
    }

    public synchronized void sendMessage(LinkMessage linkMessage) throws Exception {
        if (this.state == 3 || this.state == 4) {
            throw new NCommException("Link layer blocked for tunneling.");
        }
        if (this.state != 2) {
            throw new NCommException("Link layer in fault state.");
        }
        if (this.log().isTraceOn()) {
            this.log().trace("send:" + DrByteArrayUtil.toString((byte[])linkMessage.getByteArray(), (int)linkMessage.getLength()));
        }
        this.port.getOutputStream().write(linkMessage.getByteArray(), 0, linkMessage.getLength());
        ++this.stats.msgSent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BISerialPort tunnelLock() {
        LinkReceive linkReceive = this.receive;
        // MONITORENTER : linkReceive
        if (this.state != 2) {
            // MONITOREXIT : linkReceive
            return null;
        }
        this.state = 3;
        while (this.state != 4 && this.state != 5) {
            try {
                this.receive.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.stats.tunnelSessions;
        if (this.state != 5) return this.port;
        // MONITOREXIT : linkReceive
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseLock() {
        LinkReceive linkReceive = this.receive;
        synchronized (linkReceive) {
            if (this.state != 5) {
                this.state = 2;
                this.receive.notify();
            }
            return;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("SerialLinkLayer");
        spyWriter.prop((Object)"state", (Object)this.stateToString());
        spyWriter.endProps();
        SpyUtil.spy(spyWriter, "SerialLink Statistics", this.stats);
    }

    private final String stateToString() {
        switch (this.state) {
            case 1: {
                return "UNAVAILABLE";
            }
            case 2: {
                return "RECEIVING";
            }
            case 3: {
                return "TUNNEL_WAIT";
            }
            case 4: {
                return "TUNNELING";
            }
            case 5: {
                return "DONE";
            }
        }
        return "Unknown state " + Integer.toString(this.state);
    }

    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Log log() {
        if (this.log == null) {
            if (this.serCfg == null) {
                return Log.getLog((String)".SerialLink");
            }
            this.log = Log.getLog((String)(this.serCfg.getResourcePrefix() + ".Link"));
        }
        return this.log;
    }

    static /* synthetic */ int access$1() {
        return 5;
    }

    static /* synthetic */ int access$3() {
        return 3;
    }

    static /* synthetic */ int access$4() {
        return 4;
    }

    static /* synthetic */ int access$6() {
        return 2;
    }

    private final /* synthetic */ void this() {
        this.port = null;
        this.portName = "";
        this.stats = new Statistics();
        this.state = 1;
        this.receive = null;
    }

    public SerialLinkLayer(NComm nComm, BSerialCommConfig bSerialCommConfig) {
        this.this();
        this.comm = nComm;
        this.serCfg = bSerialCommConfig;
        this.lnkFac = bSerialCommConfig.getLinkMessageFactory();
        this.debIn = new DebugStream(this.lnkFac.getLinkMaxLength());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LinkReceive
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (SerialLinkLayer.this.state != 5) {
                try {
                    LinkReceive linkReceive = this;
                    synchronized (linkReceive) {
                        if (SerialLinkLayer.this.state == 3) {
                            SerialLinkLayer.this.state = 4;
                            this.notify();
                        }
                        while (SerialLinkLayer.this.state != 2 && SerialLinkLayer.this.state != 5) {
                            this.wait();
                        }
                    }
                    if (SerialLinkLayer.this.state == 5) {
                        return;
                    }
                    boolean bl = SerialLinkLayer.this.log().isTraceOn();
                    LinkMessage linkMessage = SerialLinkLayer.this.lnkFac.getLinkMessage();
                    InputStream inputStream = SerialLinkLayer.this.port.getInputStream();
                    if (bl) {
                        inputStream = SerialLinkLayer.this.debIn.reset(inputStream);
                    }
                    boolean bl2 = linkMessage.receive(inputStream);
                    if (bl && SerialLinkLayer.this.debIn.hasDebug()) {
                        SerialLinkLayer.this.log().trace("rcvd:" + (bl2 ? "" : "frag:") + SerialLinkLayer.this.debIn.debugString());
                    }
                    if (bl2) {
                        SerialLinkLayer.this.comm.receiveMessage(linkMessage);
                        ++((SerialLinkLayer)SerialLinkLayer.this).stats.msgReceived;
                        continue;
                    }
                    SerialLinkLayer.this.lnkFac.releaseLinkMessage(linkMessage);
                }
                catch (Throwable throwable) {
                    if (SerialLinkLayer.this.state == 5) {
                        return;
                    }
                    throwable.printStackTrace();
                    SerialLinkLayer.this.log().error("Exception caught in LinkReceiver. " + throwable);
                    ++((SerialLinkLayer)SerialLinkLayer.this).stats.receiveError;
                }
            }
        }

        private LinkReceive() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Statistics {
        public long msgSent;
        public long msgReceived;
        public long receiveError;
        public long tunnelSessions;

        private final /* synthetic */ void this() {
            this.msgSent = 0L;
            this.msgReceived = 0L;
            this.receiveError = 0L;
            this.tunnelSessions = 0L;
        }

        public Statistics() {
            this.this();
        }
    }
}

