/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx.awt.se;

import com.tridium.pdf.gx.PdfStream;
import com.tridium.pdf.gx.awt.se.PdfGraphicsSE;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BajaRuntimeException;

public class PathSupportSE {
    public static void doPath(PdfGraphicsSE pdfGraphicsSE, IPathGeom iPathGeom) {
        try {
            PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = null;
            block14: for (int i = 0; i < iPathGeom.size(); ++i) {
                IPathGeom.Segment segment = iPathGeom.segment(i);
                switch (segment.getCommand()) {
                    case 'M': 
                    case 'm': {
                        IPathGeom.MoveTo moveTo = (IPathGeom.MoveTo)segment;
                        double d = pdfGraphicsSE.transX(moveTo.getX());
                        double d2 = pdfGraphicsSE.transY(moveTo.getY());
                        pdfStream.println(d + " " + d2 + " m");
                        point2.set(d, d2);
                        point3 = null;
                        continue block14;
                    }
                    case 'L': 
                    case 'l': {
                        IPathGeom.LineTo lineTo = (IPathGeom.LineTo)segment;
                        double d = pdfGraphicsSE.transX(lineTo.getX());
                        double d2 = pdfGraphicsSE.transY(lineTo.getY());
                        pdfStream.println(d + " " + d2 + " l");
                        point2.set(d, d2);
                        point3 = null;
                        continue block14;
                    }
                    case 'H': 
                    case 'h': {
                        continue block14;
                    }
                    case 'V': 
                    case 'v': {
                        continue block14;
                    }
                    case 'Q': 
                    case 'q': {
                        point3 = PathSupportSE.quadTo(pdfGraphicsSE, (IPathGeom.QuadTo)segment, point, point2);
                        continue block14;
                    }
                    case 'T': 
                    case 't': {
                        point3 = PathSupportSE.smoothQuadTo(pdfGraphicsSE, (IPathGeom.SmoothQuadTo)segment, point, point2, point3);
                        continue block14;
                    }
                    case 'C': 
                    case 'c': {
                        point3 = PathSupportSE.curveTo(pdfGraphicsSE, (IPathGeom.CurveTo)segment, point, point2);
                        continue block14;
                    }
                    case 'S': 
                    case 's': {
                        point3 = PathSupportSE.smoothCurveTo(pdfGraphicsSE, (IPathGeom.SmoothCurveTo)segment, point, point2, point3);
                        continue block14;
                    }
                    case 'A': 
                    case 'a': {
                        PathSupportSE.arcTo(pdfGraphicsSE, (IPathGeom.ArcTo)segment, point2);
                        point3 = null;
                        continue block14;
                    }
                    case 'Z': 
                    case 'z': {
                        point3 = null;
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException(segment.toString());
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected static Point quadTo(PdfGraphicsSE pdfGraphicsSE, IPathGeom.QuadTo quadTo, Point point, Point point2) throws IOException {
        double d = pdfGraphicsSE.transX(quadTo.getX());
        double d2 = pdfGraphicsSE.transY(quadTo.getY());
        double d3 = pdfGraphicsSE.transX(quadTo.getX1());
        double d4 = pdfGraphicsSE.transY(quadTo.getY1());
        if (quadTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d3 += point2.x;
            d4 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
        pdfStream.println(d3 + " " + d4 + " " + d + " " + d2 + " v");
        point2.set(d, d2);
        point.set(d3, d4);
        return point;
    }

    protected static Point smoothQuadTo(PdfGraphicsSE pdfGraphicsSE, IPathGeom.SmoothQuadTo smoothQuadTo, Point point, Point point2, Point point3) throws IOException {
        double d = pdfGraphicsSE.transX(smoothQuadTo.getX());
        double d2 = pdfGraphicsSE.transY(smoothQuadTo.getY());
        double d3 = point2.x;
        double d4 = point2.y;
        if (point3 != null) {
            d3 += point2.x - point3.x;
            d4 -= point2.y - point3.y;
        }
        if (smoothQuadTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
        pdfStream.println(d3 + " " + d4 + " " + d + " " + d2 + " v");
        point2.set(d, d2);
        point.set(d3, d4);
        return point;
    }

    protected static Point curveTo(PdfGraphicsSE pdfGraphicsSE, IPathGeom.CurveTo curveTo, Point point, Point point2) throws IOException {
        double d = pdfGraphicsSE.transX(curveTo.getX());
        double d2 = pdfGraphicsSE.transY(curveTo.getY());
        double d3 = pdfGraphicsSE.transX(curveTo.getX1());
        double d4 = pdfGraphicsSE.transY(curveTo.getY1());
        double d5 = pdfGraphicsSE.transX(curveTo.getX2());
        double d6 = pdfGraphicsSE.transY(curveTo.getY2());
        if (curveTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d3 += point2.x;
            d4 -= point2.y;
            d5 += point2.x;
            d6 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
        pdfStream.println(d3 + " " + d4 + " " + d5 + " " + d6 + " " + d + " " + d2 + " c");
        point2.set(d, d2);
        point.set(d5, d6);
        return point;
    }

    protected static Point smoothCurveTo(PdfGraphicsSE pdfGraphicsSE, IPathGeom.SmoothCurveTo smoothCurveTo, Point point, Point point2, Point point3) throws IOException {
        double d = pdfGraphicsSE.transX(smoothCurveTo.getX());
        double d2 = pdfGraphicsSE.transY(smoothCurveTo.getY());
        double d3 = point2.x;
        double d4 = point2.y;
        double d5 = pdfGraphicsSE.transX(smoothCurveTo.getX2());
        double d6 = pdfGraphicsSE.transY(smoothCurveTo.getY2());
        if (point3 != null) {
            d3 += point2.x - point3.x;
            d4 -= point2.y - point3.y;
        }
        if (smoothCurveTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d5 += point2.x;
            d6 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
        pdfStream.println(d3 + " " + d4 + " " + d5 + " " + d6 + " " + d + " " + d2 + " c");
        point2.set(d, d2);
        point.set(d5, d6);
        return point;
    }

    protected static void arcTo(PdfGraphicsSE pdfGraphicsSE, IPathGeom.ArcTo arcTo, Point point) throws IOException {
        double d = arcTo.getRadiusX();
        double d2 = arcTo.getRadiusY();
        double d3 = arcTo.getXAxisRotation();
        double d4 = point.x;
        double d5 = point.y;
        double d6 = pdfGraphicsSE.transX(arcTo.getX());
        double d7 = pdfGraphicsSE.transY(arcTo.getY());
        if (arcTo.isRelative()) {
            d6 += d4;
            d7 += d5;
        }
        double d8 = d;
        double d9 = d2;
        double d10 = Math.sqrt(Math.pow(d6 - d4, 2.0) + Math.pow(d7 - d5, 2.0));
        double d11 = Math.acos((d8 * d8 + d9 * d9 - d10 * d10) / (2.0 * d8 * d9));
        if (arcTo.getLargeArcFlag() && arcTo.getSweepFlag() && d11 == 0.0) {
            d11 = 360.0;
        }
        PdfStream pdfStream = pdfGraphicsSE.getTarget().getContentStream();
        Arc2D arc2D = PathSupportSE.computeArc(d4, d5, d, d2, d3, arcTo.getLargeArcFlag(), arcTo.getSweepFlag(), d6, d7);
        arc2D.setArcType(2);
        if (d11 == 360.0) {
            arc2D.setArcByCenter(d4, d5 - d2, d, 0.0, d11, 2);
            d3 = 90.0;
        }
        System.out.println("PathSupport.arcTo angle extent " + arc2D.getAngleExtent());
        System.out.println("PathSupport.arcTo angle start " + arc2D.getAngleStart());
        System.out.println("PathSupport.arcTo center x " + arc2D.getCenterX());
        System.out.println("PathSupport.arcTo center y " + arc2D.getCenterY());
        System.out.println("PathSupport.arcTo height " + arc2D.getHeight());
        System.out.println("PathSupport.arcTo width " + arc2D.getWidth());
        System.out.println("PathSupport.arcTo X " + arc2D.getX());
        System.out.println("PathSupport.arcTo Y " + arc2D.getY());
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(d3), arc2D.getCenterX(), arc2D.getCenterY());
        PathIterator pathIterator = arc2D.getPathIterator(affineTransform);
        int n = 0;
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            ++n;
            int n2 = pathIterator.currentSegment(fArray);
            if (Float.isNaN(fArray[0])) {
                pathIterator.next();
                continue;
            }
            switch (n2) {
                case 4: {
                    pdfStream.println("h");
                    break;
                }
                case 3: {
                    pdfStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + fArray[3] + " " + fArray[4] + " " + fArray[5] + " c");
                    break;
                }
                case 1: {
                    pdfStream.println(fArray[0] + " " + fArray[1] + " l");
                    break;
                }
                case 0: {
                    pdfStream.println(fArray[0] + " " + fArray[1] + " m");
                    break;
                }
                case 2: {
                    pdfStream.println(fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + fArray[3] + " v");
                }
            }
            pathIterator.next();
        }
        point.set(d6, d7);
    }

    public static Arc2D computeArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d12 * d10 + d13 * d11;
        double d15 = -d13 * d10 + d12 * d11;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl == bl2 ? 1.0 : -1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        d20 = d20 < 0.0 ? 0.0 : d20;
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + (d12 * d22 - d13 * d23);
        double d27 = d25 + (d13 * d22 + d12 * d23);
        double d28 = (-d14 - d22) / d3;
        double d29 = (-d15 - d23) / d4;
        double d30 = (d14 - d22) / d3;
        double d31 = (d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        d19 = d29 < 0.0 ? -1.0 : 1.0;
        double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        d33 = d28 * d30 + d29 * d31;
        d19 = d28 * d31 - d29 * d30 < 0.0 ? -1.0 : 1.0;
        double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        if (!bl2 && d35 > 0.0) {
            d35 -= 360.0;
        } else if (bl2 && d35 < 0.0) {
            d35 += 360.0;
        }
        d35 %= 360.0;
        d34 %= 360.0;
        Arc2D.Double double_ = new Arc2D.Double();
        double_.x = d26 - d3;
        double_.y = d27 - d4;
        double_.width = d3 * 2.0;
        double_.height = d4 * 2.0;
        double_.start = -d34;
        double_.extent = -d35;
        return double_;
    }
}

