/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfStream
extends PdfObject {
    protected boolean debug;
    protected ByteArrayOutputStream byteArray;
    protected DeflaterOutputStream deflater;

    public void print(byte by) throws IOException {
        if (this.debug) {
            this.byteArray.write(by);
        } else {
            this.deflater.write(by);
        }
    }

    public void print(byte[] byArray) throws IOException {
        if (this.debug) {
            this.byteArray.write(byArray);
        } else {
            this.deflater.write(byArray);
        }
    }

    public void print(String string) throws IOException {
        if (this.debug) {
            this.byteArray.write(string.getBytes());
        } else {
            this.deflater.write(string.getBytes());
        }
    }

    public void println(String string) throws IOException {
        this.print(string + '\n');
    }

    public void toPdf() throws IOException {
        PdfDocument pdfDocument = this.getParent();
        if (!this.debug) {
            this.deflater.flush();
            this.deflater.close();
        }
        byte[] byArray = this.byteArray.toByteArray();
        pdfDocument.markOffset(this.getObjectId());
        pdfDocument.writeln("" + this.getObjectId() + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("<< /Length " + byArray.length);
        if (!this.debug) {
            pdfDocument.write("/Filter/FlateDecode");
        }
        pdfDocument.write(" >>");
        pdfDocument.writeln("stream");
        pdfDocument.write(byArray);
        pdfDocument.writeln("\nendstream");
        pdfDocument.writeln("endobj");
    }

    private final /* synthetic */ void this() {
        this.debug = false;
    }

    public PdfStream(PdfDocument pdfDocument, int n, int n2) {
        super(pdfDocument, n, n2);
        this.this();
        this.byteArray = new ByteArrayOutputStream();
        if (!this.debug) {
            this.deflater = new DeflaterOutputStream((OutputStream)this.byteArray, new Deflater(0));
        }
    }
}

