/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfImageMaskStream;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfImageStream
extends PdfStream {
    private static int maskNum = 0;
    protected int imageWidth;
    protected int imageHeight;
    private int bitsPerComponent;
    private String colorSpace;
    private PdfImageMaskStream mask;

    public void setImageSize(int n, int n2) {
        this.imageWidth = n;
        this.imageHeight = n2;
        if (this.mask != null) {
            this.mask.imageWidth = n;
            this.mask.imageHeight = n2;
        }
    }

    public void setColorSpace(String string) {
        this.colorSpace = string;
    }

    public void setBitsPerComponent(int n) {
        this.bitsPerComponent = n;
    }

    public void mask(byte by) throws IOException {
        if (this.mask == null) {
            this.mask = this.getParent().createImageMaskStream();
            PdfPage pdfPage = this.getParent().getCurrentPage();
            pdfPage.addXObject("Mask" + maskNum++, this.mask);
        }
        this.mask.print(by);
    }

    public void toPdf() throws IOException {
        PdfDocument pdfDocument = this.getParent();
        if (!this.debug) {
            this.deflater.flush();
            this.deflater.close();
        }
        byte[] byArray = this.byteArray.toByteArray();
        pdfDocument.markOffset(this.getObjectId());
        pdfDocument.writeln("" + this.getObjectId() + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("<< /Type /XObject /Subtype /Image");
        pdfDocument.write(" /Width " + this.imageWidth + " /Height " + this.imageHeight);
        pdfDocument.write(" /ColorSpace /" + this.colorSpace + " /BitsPerComponent " + this.bitsPerComponent);
        if (this.mask != null) {
            pdfDocument.write(" /Mask " + this.mask.getObjectId() + " 0 R");
        }
        pdfDocument.write(" /Length " + byArray.length);
        if (!this.debug) {
            pdfDocument.writeln(" /Filter /FlateDecode >>");
        } else {
            pdfDocument.writeln(" >>");
        }
        pdfDocument.writeln("stream");
        pdfDocument.write(byArray);
        pdfDocument.writeln("\nendstream");
        pdfDocument.writeln("endobj");
    }

    private final /* synthetic */ void this() {
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.bitsPerComponent = 8;
        this.colorSpace = "DeviceRGB";
        this.mask = null;
    }

    public PdfImageStream(PdfDocument pdfDocument, int n, int n2) {
        super(pdfDocument, n, n2);
        this.this();
    }
}

