/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfObject;
import java.io.IOException;
import javax.baja.gx.BFont;
import javax.baja.gx.RectGeom;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfFont
extends PdfObject {
    public static final int FLAG_FIXED_PITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALL_CAP = 65536;
    public static final int FLAG_SMALL_CAP = 131072;
    public static final int FLAG_FORCE_BOLD = 262144;
    private int scale;
    private String subType;
    private String baseFont;
    private int firstChar;
    private int lastChar;
    private double[] widths;
    private int ascent;
    private int capHeight;
    private int descent;
    private int flags;
    private RectGeom fontBox;
    private int italicAngle;
    private int stemV;
    private int stemH;
    private int avgWidth;
    private int leading;
    private int maxWidth;
    private int missingWidth;
    private int xHeight;

    public void toPdf() throws IOException {
        PdfDocument pdfDocument = this.getParent();
        pdfDocument.markOffset(this.getObjectId());
        pdfDocument.writeln("" + this.getObjectId() + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("<< /Type /Font /Subtype /" + this.subType);
        pdfDocument.write(" /BaseFont /" + this.baseFont);
        pdfDocument.write(" /FirstChar " + this.firstChar + " /LastChar " + this.lastChar);
        pdfDocument.write(" /Widths " + (this.getObjectId() + 1) + " 0 R");
        pdfDocument.write(" /FontDescriptor " + (this.getObjectId() + 2) + " 0 R");
        pdfDocument.writeln(" /Encoding /WinAnsiEncoding >>");
        pdfDocument.writeln("endobj");
        pdfDocument.markOffset(this.getObjectId() + 1);
        pdfDocument.writeln("" + (this.getObjectId() + 1) + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("[ ");
        int n = 0;
        while (n < this.lastChar) {
            if (n > 0 && n % 16 == 0) {
                pdfDocument.writeln("" + (int)this.widths[n] + ' ');
            } else {
                pdfDocument.write("" + (int)this.widths[n] + ' ');
            }
            ++n;
        }
        pdfDocument.writeln("]");
        pdfDocument.writeln("endobj");
        pdfDocument.markOffset(this.getObjectId() + 2);
        pdfDocument.writeln("" + (this.getObjectId() + 2) + ' ' + this.getGenerationNum() + " obj");
        pdfDocument.write("<< /Type /FontDescriptor /FontName /" + this.baseFont);
        pdfDocument.write(" /Flags " + this.flags);
        pdfDocument.write(" /FontBBox [" + this.fontBox.x + ' ' + this.fontBox.y);
        pdfDocument.write(" " + this.fontBox.width + ' ' + this.fontBox.height + ']');
        pdfDocument.write(" /StemV " + this.stemV);
        pdfDocument.write(" /CapHeight " + this.capHeight);
        pdfDocument.write(" /Ascent " + this.ascent);
        pdfDocument.write(" /Descent " + this.descent);
        pdfDocument.write(" /Leading " + this.leading);
        pdfDocument.write(" /MaxWidth " + this.maxWidth);
        pdfDocument.write(" /AvgWidth " + this.avgWidth);
        pdfDocument.write(" /ItalicAngle " + this.italicAngle);
        pdfDocument.writeln(" >>");
        pdfDocument.writeln("endobj");
    }

    private final /* synthetic */ void this() {
        this.subType = "TrueType";
        this.ascent = 0;
        this.capHeight = 0;
        this.descent = 0;
        this.flags = 0;
        this.fontBox = new RectGeom();
        this.italicAngle = 0;
        this.stemV = 0;
        this.stemH = 0;
        this.avgWidth = 0;
        this.leading = 0;
        this.maxWidth = 0;
        this.missingWidth = 0;
        this.xHeight = 0;
    }

    public PdfFont(BFont bFont, PdfDocument pdfDocument, int n, int n2) {
        super(pdfDocument, n, n2);
        this.this();
        MicroFontPeer microFontPeer = (MicroFontPeer)PdfGraphics.env.makeFontPeer(bFont);
        double d = 13.4;
        this.baseFont = microFontPeer.getPostScriptName();
        this.firstChar = 0;
        this.lastChar = 255;
        this.ascent = (int)((double)microFontPeer.getPdfAscent() * d);
        this.capHeight = (int)((double)microFontPeer.getPdfAscent() * d);
        this.descent = (int)(-((double)microFontPeer.getPdfDescent() * d));
        this.flags = 4;
        this.leading = (int)((double)microFontPeer.getPdfLeading() * d);
        this.stemV = (int)(bFont.getSize() * d);
        this.italicAngle = 0;
        byte[] byArray = microFontPeer.getPdfWidths();
        this.widths = new double[byArray.length];
        this.avgWidth = 0;
        this.maxWidth = 0;
        int n3 = 0;
        while (n3 < this.lastChar) {
            this.widths[n3] = (int)((double)byArray[n3] * d);
            this.avgWidth = (int)((double)this.avgWidth + this.widths[n3]);
            this.maxWidth = (int)Math.max((double)this.maxWidth, this.widths[n3]);
            ++n3;
        }
        this.avgWidth /= this.lastChar;
        this.fontBox.set(0.0, (double)this.descent, (double)this.maxWidth, (double)(this.ascent + this.descent));
    }

    public PdfFont(MicroFontPeer microFontPeer, PdfDocument pdfDocument, int n, int n2) {
        super(pdfDocument, n, n2);
        this.this();
        double d = 13.4;
        this.baseFont = microFontPeer.getPostScriptName();
        this.firstChar = 0;
        this.lastChar = 255;
        this.ascent = (int)((double)microFontPeer.getPdfAscent() * d);
        this.capHeight = (int)((double)microFontPeer.getPdfAscent() * d);
        this.descent = (int)(-((double)microFontPeer.getPdfDescent() * d));
        this.flags = 4;
        this.leading = (int)((double)microFontPeer.getPdfLeading() * d);
        this.stemV = (int)(microFontPeer.getSize() * d);
        this.italicAngle = 0;
        byte[] byArray = microFontPeer.getPdfWidths();
        this.widths = new double[byArray.length];
        this.avgWidth = 0;
        this.maxWidth = 0;
        int n3 = 0;
        while (n3 < this.lastChar) {
            this.widths[n3] = (int)((double)byArray[n3] * d);
            this.avgWidth = (int)((double)this.avgWidth + this.widths[n3]);
            this.maxWidth = (int)Math.max((double)this.maxWidth, this.widths[n3]);
            ++n3;
        }
        this.avgWidth /= this.lastChar;
        this.fontBox.set(0.0, (double)this.descent, (double)this.maxWidth, (double)(this.ascent + this.descent));
    }
}

