/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.pdf.gx.PdfFont;
import com.tridium.pdf.gx.PdfFontReference;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfImageMaskStream;
import com.tridium.pdf.gx.PdfImageStream;
import com.tridium.pdf.gx.PdfObject;
import com.tridium.pdf.gx.PdfPage;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.gx.BFont;
import javax.baja.gx.Insets;
import javax.baja.gx.Size;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PdfDocument {
    private static byte[] bytes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static long seq = System.currentTimeMillis();
    private static final String version = "1.4";
    private PdfGraphics graphics;
    private OutputStream out;
    private int offset;
    private int numObjects;
    private int rootId;
    private int pageTreeId;
    private Vector fonts;
    private Hashtable fontHash;
    private Vector pages;
    private PdfPage currentPage;
    private Size pageSize;
    private Insets margins;
    private Hashtable xref;

    public void start() {
        this.writeln("%PDF-1.4");
        byte[] byArray = new byte[]{37, -86, -85, -84, -83, 10};
        this.write(byArray);
    }

    public void end() {
        try {
            if (this.currentPage != null) {
                this.currentPage.toPdf();
            }
            this.writeFooter();
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public PdfPage addNewPage() {
        try {
            if (this.currentPage != null) {
                this.currentPage.toPdf();
            }
            this.currentPage = new PdfPage(this, this.numObjects++, 0);
            this.pages.add(this.currentPage);
            this.graphics.setPage(this.currentPage);
            return this.currentPage;
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public PdfPage getCurrentPage() {
        return this.currentPage;
    }

    public int getCurrentPageNumber() {
        return this.pages.size();
    }

    public Size getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(double d, double d2) {
        this.pageSize.set(d, d2);
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(double d, double d2, double d3, double d4) {
        this.margins.set(d, d2, d3, d4);
    }

    public PdfGraphics getGraphics() {
        return this.graphics;
    }

    public PdfStream createStream() {
        return new PdfStream(this, this.numObjects++, 0);
    }

    public PdfImageStream createImageStream() {
        return new PdfImageStream(this, this.numObjects++, 0);
    }

    public PdfImageMaskStream createImageMaskStream() {
        return new PdfImageMaskStream(this, this.numObjects++, 0);
    }

    public int getFontId(BFont bFont) {
        Integer n;
        String string = bFont.getName();
        if (bFont.isBold()) {
            string = string + 'B';
        }
        if (bFont.isItalic()) {
            string = string + 'I';
        }
        if ((n = (Integer)this.fontHash.get(string)) == null) {
            PdfFont pdfFont = new PdfFont(bFont, this, this.numObjects, 0);
            this.numObjects += 3;
            this.fonts.add(pdfFont);
            this.fontHash.put(string, new Integer(pdfFont.getObjectId()));
            return pdfFont.getObjectId();
        }
        return n;
    }

    public int getFontId(MicroFontPeer microFontPeer) {
        String string = microFontPeer.getPostScriptName();
        Integer n = (Integer)this.fontHash.get(string);
        if (n == null) {
            PdfFont pdfFont = new PdfFont(microFontPeer, this, this.numObjects, 0);
            this.numObjects += 3;
            this.fonts.add(pdfFont);
            this.fontHash.put(string, new Integer(pdfFont.getObjectId()));
            return pdfFont.getObjectId();
        }
        return n;
    }

    public int getReferenceFontId(String string, int n) {
        Integer n2 = (Integer)this.fontHash.get(string);
        if (n2 == null) {
            PdfFontReference pdfFontReference = new PdfFontReference(this, this.numObjects, 0, n, Lexicon.make((String)"pdf").getText("pdf.font"));
            this.numObjects += 3;
            this.fonts.add(pdfFontReference);
            this.fontHash.put(string, new Integer(pdfFontReference.getObjectId()));
            return pdfFontReference.getObjectId();
        }
        return n2;
    }

    public int getPageTreeId() {
        return this.pageTreeId;
    }

    public void markOffset(int n) {
        this.xref.put(new Integer(n), new Integer(this.offset));
    }

    public void writeFooter() throws IOException {
        PdfObject pdfObject;
        this.markOffset(this.rootId);
        this.writeln(this.rootId + " 0 obj");
        this.writeln("<< /Type /Catalog /Pages " + this.pageTreeId + " 0 R >>");
        this.writeln("endobj");
        String string = "<< /Type /Pages /Kids [";
        Enumeration enumeration = this.pages.elements();
        while (enumeration.hasMoreElements()) {
            pdfObject = (PdfPage)enumeration.nextElement();
            string = string + pdfObject.getObjectId() + ' ' + pdfObject.getGenerationNum() + " R ";
        }
        string = string + "] /Count " + this.pages.size() + " >>";
        this.markOffset(this.pageTreeId);
        this.writeln(this.pageTreeId + " 0 obj");
        this.writeln(string);
        this.writeln("endobj");
        enumeration = this.fonts.elements();
        while (enumeration.hasMoreElements()) {
            PdfObject pdfObject2;
            pdfObject = (PdfObject)enumeration.nextElement();
            if (pdfObject instanceof PdfFontReference) {
                pdfObject2 = (PdfFontReference)pdfObject;
                ((PdfFontReference)pdfObject2).toPdf();
                continue;
            }
            pdfObject2 = (PdfFont)pdfObject;
            ((PdfFont)pdfObject2).toPdf();
        }
        int n = this.offset;
        this.writeln("xref");
        this.writeln("0 " + (this.xref.size() + 1));
        this.writeln("0000000000 65535 f ");
        int n2 = 1;
        while (n2 < this.numObjects) {
            Integer n3 = (Integer)this.xref.get(new Integer(n2));
            if (n3 != null) {
                int n4 = n3;
                StringBuffer stringBuffer = new StringBuffer("0000000000" + n4);
                while (stringBuffer.length() > 10) {
                    stringBuffer.deleteCharAt(0);
                }
                this.writeln(stringBuffer.toString() + " 00000 n ");
            }
            ++n2;
        }
        this.writeln("trailer");
        this.writeln("<< /Size " + (this.xref.size() + 1) + " /Root " + this.rootId + " 0 R /ID " + PdfDocument.createInfoId(PdfDocument.createDocumentId()) + ">>");
        this.writeln("startxref");
        this.writeln("" + n);
        this.writeln("%%EOF");
    }

    private static final byte[] createDocumentId() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().freeMemory();
        String string = "" + l + '+' + l2 + '+' + seq++;
        return messageDigest.digest(string.getBytes());
    }

    private static final String createInfoId(byte[] byArray) {
        byte[] byArray2 = new byte[2];
        StringBuffer stringBuffer = new StringBuffer(90);
        stringBuffer.append('[');
        stringBuffer.append('<');
        int n = 0;
        while (n < 16) {
            byArray2[0] = bytes[byArray[n] >> 4 & 0xF];
            byArray2[1] = bytes[byArray[n] & 0xF];
            stringBuffer.append(new String(byArray2));
            ++n;
        }
        stringBuffer.append('>');
        stringBuffer.append('<');
        n = 0;
        while (n < 16) {
            byArray2[0] = bytes[byArray[n] >> 4 & 0xF];
            byArray2[1] = bytes[byArray[n] & 0xF];
            stringBuffer.append(new String(byArray2));
            ++n;
        }
        stringBuffer.append('>');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void write(byte[] byArray) {
        try {
            this.offset += byArray.length;
            this.out.write(byArray);
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void write(String string) {
        try {
            this.offset += string.length();
            this.out.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public void writeln(String string) {
        try {
            this.offset += string.length() + 1;
            this.out.write(string.getBytes());
            this.out.write(10);
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    private final /* synthetic */ void this() {
        this.pageSize = new Size(612.0, 792.0);
        this.margins = new Insets(36.0, 36.0, 36.0, 36.0);
    }

    public PdfDocument(OutputStream outputStream) {
        this(outputStream, 612, 792);
    }

    public PdfDocument(OutputStream outputStream, int n, int n2) {
        this.this();
        this.out = outputStream;
        this.pages = new Vector();
        this.xref = new Hashtable();
        this.rootId = 1;
        this.pageTreeId = 2;
        this.numObjects = 3;
        this.fonts = new Vector();
        this.fontHash = new Hashtable();
        this.pageSize.set((double)n, (double)n2);
        try {
            this.graphics = (PdfGraphics)Sys.newInstance((String)"pdf", (String)"com.tridium.pdf.gx.awt.se.PdfGraphicsSE");
        }
        catch (Exception exception) {
            this.graphics = new PdfGraphics();
        }
    }
}

