/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.sys.BajaRuntimeException;

public class PathSupport {
    public static void doPath(PdfGraphics pdfGraphics, IPathGeom iPathGeom) {
        try {
            PdfStream pdfStream = pdfGraphics.target.getContentStream();
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = null;
            int n = 0;
            while (n < iPathGeom.size()) {
                IPathGeom.Segment segment = iPathGeom.segment(n);
                switch (segment.getCommand()) {
                    case 'M': 
                    case 'm': {
                        IPathGeom.MoveTo moveTo = (IPathGeom.MoveTo)segment;
                        double d = pdfGraphics.transX(moveTo.getX());
                        double d2 = pdfGraphics.transY(moveTo.getY());
                        pdfStream.println("" + d + ' ' + d2 + " m");
                        point3 = null;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        IPathGeom.LineTo lineTo = (IPathGeom.LineTo)segment;
                        double d = pdfGraphics.transX(lineTo.getX());
                        double d2 = pdfGraphics.transY(lineTo.getY());
                        pdfStream.println("" + d + ' ' + d2 + " l");
                        point3 = null;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        break;
                    }
                    case 'V': 
                    case 'v': {
                        break;
                    }
                    case 'Q': 
                    case 'q': {
                        point3 = PathSupport.quadTo(pdfGraphics, (IPathGeom.QuadTo)segment, point, point2);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        point3 = PathSupport.smoothQuadTo(pdfGraphics, (IPathGeom.SmoothQuadTo)segment, point, point2, point3);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        point3 = PathSupport.curveTo(pdfGraphics, (IPathGeom.CurveTo)segment, point, point2);
                        break;
                    }
                    case 'S': 
                    case 's': {
                        point3 = PathSupport.smoothCurveTo(pdfGraphics, (IPathGeom.SmoothCurveTo)segment, point, point2, point3);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        PathSupport.arcTo(pdfGraphics, (IPathGeom.ArcTo)segment, point2);
                        point3 = null;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        point3 = null;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(segment.toString());
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    protected static Point quadTo(PdfGraphics pdfGraphics, IPathGeom.QuadTo quadTo, Point point, Point point2) throws IOException {
        double d = pdfGraphics.transX(quadTo.getX());
        double d2 = pdfGraphics.transY(quadTo.getY());
        double d3 = pdfGraphics.transX(quadTo.getX1());
        double d4 = pdfGraphics.transY(quadTo.getY1());
        if (quadTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d3 += point2.x;
            d4 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphics.target.getContentStream();
        pdfStream.println("" + d3 + ' ' + d4 + ' ' + d + ' ' + d2 + " v");
        point2.set(d, d2);
        point.set(d3, d4);
        return point;
    }

    protected static Point smoothQuadTo(PdfGraphics pdfGraphics, IPathGeom.SmoothQuadTo smoothQuadTo, Point point, Point point2, Point point3) throws IOException {
        double d = pdfGraphics.transX(smoothQuadTo.getX());
        double d2 = pdfGraphics.transY(smoothQuadTo.getY());
        double d3 = point2.x;
        double d4 = point2.y;
        if (point3 != null) {
            d3 += point2.x - point3.x;
            d4 -= point2.y - point3.y;
        }
        if (smoothQuadTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphics.target.getContentStream();
        pdfStream.println("" + d3 + ' ' + d4 + ' ' + d + ' ' + d2 + " v");
        point2.set(d, d2);
        point.set(d3, d4);
        return point;
    }

    protected static Point curveTo(PdfGraphics pdfGraphics, IPathGeom.CurveTo curveTo, Point point, Point point2) throws IOException {
        double d = pdfGraphics.transX(curveTo.getX());
        double d2 = pdfGraphics.transY(curveTo.getY());
        double d3 = pdfGraphics.transX(curveTo.getX1());
        double d4 = pdfGraphics.transY(curveTo.getY1());
        double d5 = pdfGraphics.transX(curveTo.getX2());
        double d6 = pdfGraphics.transY(curveTo.getY2());
        if (curveTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d3 += point2.x;
            d4 -= point2.y;
            d5 += point2.x;
            d6 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphics.target.getContentStream();
        pdfStream.println("" + d3 + ' ' + d4 + ' ' + d5 + ' ' + d6 + ' ' + d + ' ' + d2 + " c");
        point2.set(d, d2);
        point.set(d5, d6);
        return point;
    }

    protected static Point smoothCurveTo(PdfGraphics pdfGraphics, IPathGeom.SmoothCurveTo smoothCurveTo, Point point, Point point2, Point point3) throws IOException {
        double d = pdfGraphics.transX(smoothCurveTo.getX());
        double d2 = pdfGraphics.transY(smoothCurveTo.getY());
        double d3 = point2.x;
        double d4 = point2.y;
        double d5 = pdfGraphics.transX(smoothCurveTo.getX2());
        double d6 = pdfGraphics.transY(smoothCurveTo.getY2());
        if (point3 != null) {
            d3 += point2.x - point3.x;
            d4 -= point2.y - point3.y;
        }
        if (smoothCurveTo.isRelative()) {
            d += point2.x;
            d2 -= point2.y;
            d5 += point2.x;
            d6 -= point2.y;
        }
        PdfStream pdfStream = pdfGraphics.target.getContentStream();
        pdfStream.println("" + d3 + ' ' + d4 + ' ' + d5 + ' ' + d6 + ' ' + d + ' ' + d2 + " c");
        point2.set(d, d2);
        point.set(d5, d6);
        return point;
    }

    protected static void arcTo(PdfGraphics pdfGraphics, IPathGeom.ArcTo arcTo, Point point) throws IOException {
        System.out.println("PathSupport.arcTo converting arc to PDF: " + arcTo.toString());
        double d = arcTo.getRadiusX();
        double d2 = arcTo.getRadiusY();
        double d3 = point.x;
        double d4 = point.y;
        double d5 = pdfGraphics.transX(arcTo.getX());
        double d6 = pdfGraphics.transY(arcTo.getY());
        System.out.println("Starting point: " + d3 + " , " + d4);
        if (arcTo.isRelative()) {
            d5 += d3;
            d6 += d4;
        }
        double d7 = d;
        double d8 = d2;
        double d9 = Math.sqrt(Math.pow(d5 - d3, 2) + Math.pow(d6 - d4, 2));
        double d10 = Math.acos((d7 * d7 + d8 * d8 - d9 * d9) / ((double)2 * d7 * d8));
        if (arcTo.getLargeArcFlag() && arcTo.getSweepFlag() && d10 == 0.0) {
            d10 = 360.0;
        }
        PdfStream pdfStream = pdfGraphics.target.getContentStream();
        point.set(d5, d6);
    }
}

