/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.Index;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.rdb.jdbc.RdbmsDialect;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.rdb.ddl.BOnDelete;
import javax.baja.rdb.ddl.Column;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.rdb.ddl.CreateIndex;
import javax.baja.rdb.ddl.CreateSequence;
import javax.baja.rdb.ddl.CreateTable;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rdb.ddl.DropSequence;
import javax.baja.rdb.ddl.DropTable;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TableBuilder {
    private static final int FINDEXED = 2;
    private static final int FUNIQUE = 4;
    private static final int FCLOB = 8;
    private static final int FWIDTH = 16;
    private BOrionDatabase db;
    private OrionType type;
    private RdbmsDialect dialect;
    private BIOrionObject instance;
    private String tableName;
    private Property[] properties;
    private Property identity;
    static /* synthetic */ Class class$javax$baja$rdb$ddl$DdlCommand;
    static /* synthetic */ Class class$javax$baja$rdb$ddl$Constraint;
    static /* synthetic */ Class class$javax$baja$rdb$ddl$CreateIndex;

    public DdlCommand[] createTable() {
        Class clazz = class$javax$baja$rdb$ddl$DdlCommand;
        if (clazz == null) {
            clazz = class$javax$baja$rdb$ddl$DdlCommand = TableBuilder.class("[Ljavax.baja.rdb.ddl.DdlCommand;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)new CreateTable(this.getTableName(), this.makeColumns(), this.makeConstraints()));
        if (this.dialect.getInsertionMode() == 0 && this.identity != null) {
            array.add((Object)new CreateSequence(this.dialect.getSequenceName(this.getTableName())));
        }
        array.addAll((Object[])this.makeSingleColumnIndexes());
        array.addAll((Object[])this.makeExtraIndexes());
        return (DdlCommand[])array.trim();
    }

    public DdlCommand[] dropTable() {
        Class clazz = class$javax$baja$rdb$ddl$DdlCommand;
        if (clazz == null) {
            clazz = class$javax$baja$rdb$ddl$DdlCommand = TableBuilder.class("[Ljavax.baja.rdb.ddl.DdlCommand;", false);
        }
        Array array = new Array(clazz);
        array.add((Object)new DropTable(this.getTableName()));
        if (this.dialect.getInsertionMode() == 0 && this.identity != null) {
            array.add((Object)new DropSequence(this.dialect.getSequenceName(this.getTableName())));
        }
        return (DdlCommand[])array.trim();
    }

    private final Column[] makeColumns() {
        Column[] columnArray = new Column[this.properties.length];
        int n = 0;
        while (n < this.properties.length) {
            Property property = this.properties[n];
            if (BOrionObject.isIdentity(property)) {
                TableBuilder.checkFacets("IDENTITY", property, 30);
                if (!property.getType().is(BInteger.TYPE)) {
                    throw new OrionException("IDENTITY property must be of type BInteger: " + property);
                }
                columnArray[n] = Column.makeIdentity((String)property.getName(), (boolean)BOrionObject.isKey(property));
            } else if (BOrionObject.isKey(property)) {
                TableBuilder.checkFacets("KEY", property, 14);
                columnArray[n] = Column.makeKey((String)property.getName(), (Type)property.getType(), (BValue)this.instance.get(property), (int)BOrionObject.getWidth(property));
            } else if (BOrionObject.isUnique(property)) {
                TableBuilder.checkFacets("UNIQUE", property, 10);
                columnArray[n] = Column.makeUnique((String)property.getName(), (Type)property.getType(), (BValue)this.instance.get(property), (int)BOrionObject.getWidth(property));
            } else if (BOrionObject.isClob(property)) {
                TableBuilder.checkFacets("CLOB", property, 18);
                if (!property.getType().is(BString.TYPE)) {
                    throw new OrionException("CLOB property must be of type BString: " + property);
                }
                columnArray[n] = Column.makeClob((String)property.getName());
            } else {
                columnArray[n] = Column.make((String)property.getName(), (Type)property.getType(), (BValue)this.instance.get(property), (int)BOrionObject.getWidth(property));
            }
            ++n;
        }
        return columnArray;
    }

    private static final void checkFacets(String string, Property property, int n) {
        if ((n & 2) != 0) {
            if (BOrionObject.isIndexed(property)) {
                throw new OrionException(string + " property should not specify INDEXED: " + property);
            }
        } else if ((n & 4) != 0) {
            if (BOrionObject.isUnique(property)) {
                throw new OrionException(string + " property should not specify UNIQUE: " + property);
            }
        } else if ((n & 8) != 0) {
            if (BOrionObject.isClob(property)) {
                throw new OrionException(string + " property should not specify CLOB: " + property);
            }
        } else if ((n & 0x10) != 0 && BOrionObject.getWidth(property) != -1) {
            throw new OrionException(string + " property should not specify WIDTH: " + property);
        }
    }

    public Constraint[] makeConstraints() {
        Class clazz = class$javax$baja$rdb$ddl$Constraint;
        if (clazz == null) {
            clazz = class$javax$baja$rdb$ddl$Constraint = TableBuilder.class("[Ljavax.baja.rdb.ddl.Constraint;", false);
        }
        Array array = new Array(clazz);
        Property[] propertyArray = this.type.getKey();
        String[] stringArray = new String[propertyArray.length];
        int n = 0;
        while (n < propertyArray.length) {
            stringArray[n] = propertyArray[n].getName();
            ++n;
        }
        BClustered bClustered = BClustered.unspecified;
        int n2 = 0;
        while (n2 < propertyArray.length) {
            if (BOrionObject.isClustered(propertyArray[n2]).equals((Object)BClustered.nonClustered)) {
                bClustered = BClustered.nonClustered;
                break;
            }
            ++n2;
        }
        array.add((Object)Constraint.makePrimaryKey((String)this.db.getConstraintName(this.type, null, "PK", true), (String[])stringArray, (BClustered)bClustered));
        n2 = 0;
        while (n2 < this.properties.length) {
            Property property = this.properties[n2];
            if (property.getType() == BRef.TYPE) {
                array.add((Object)this.makeForeignKeyConstraint(property));
            } else if (BOrionObject.isUnique(property)) {
                array.add((Object)Constraint.makeUnique((String)this.db.getConstraintName(this.type, property, "UQ", false), (String[])new String[]{property.getName()}, (BClustered)BOrionObject.isClustered(property)));
            }
            ++n2;
        }
        return (Constraint[])array.trim();
    }

    private final Constraint makeForeignKeyConstraint(Property property) {
        BRef bRef = (BRef)property.getDefaultValue();
        BTypeSpec bTypeSpec = bRef.getTargetTypeSpec();
        OrionType orionType = (OrionType)bTypeSpec.getResolvedType();
        Property[] propertyArray = orionType.getKey();
        if (propertyArray.length != 1) {
            throw new OrionException("Ref targets must have exactly one key column");
        }
        return Constraint.makeForeignKey((String)this.db.getConstraintName(this.type, property, "FK", false), (String)property.getName(), (String)this.db.getTableName(orionType), (String)propertyArray[0].getName(), (BOnDelete)BOrionObject.getOnDelete(property));
    }

    public CreateIndex[] makeSingleColumnIndexes() {
        Class clazz = class$javax$baja$rdb$ddl$CreateIndex;
        if (clazz == null) {
            clazz = class$javax$baja$rdb$ddl$CreateIndex = TableBuilder.class("[Ljavax.baja.rdb.ddl.CreateIndex;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < this.properties.length) {
            Property property = this.properties[n];
            if (BOrionObject.isIndexed(property)) {
                array.add((Object)new CreateIndex(this.db.getIndexName(this.type, property), this.getTableName(), BOrionObject.isUnique(property), BOrionObject.isClustered(property), new CreateIndex.Column[]{new CreateIndex.Column(property.getName(), BOrionObject.isDescending(property))}));
            }
            ++n;
        }
        return (CreateIndex[])array.trim();
    }

    public CreateIndex[] makeExtraIndexes() {
        Class clazz = class$javax$baja$rdb$ddl$CreateIndex;
        if (clazz == null) {
            clazz = class$javax$baja$rdb$ddl$CreateIndex = TableBuilder.class("[Ljavax.baja.rdb.ddl.CreateIndex;", false);
        }
        Array array = new Array(clazz);
        Index[] indexArray = this.instance.getIndexes();
        int n = 0;
        while (n < indexArray.length) {
            if (indexArray[n].getName().length() > this.dialect.getMaxIndexName()) {
                throw new OrionException("Index name '" + indexArray[n].getName() + "' is too long.");
            }
            array.add((Object)TableBuilder.makeIndex(indexArray[n], this.getTableName()));
            ++n;
        }
        return (CreateIndex[])array.trim();
    }

    private static final CreateIndex makeIndex(Index index, String string) {
        return new CreateIndex(index.getName(), string, index.isUnique(), TableBuilder.makeColumns(index));
    }

    private static final CreateIndex.Column[] makeColumns(Index index) {
        Property[] propertyArray = index.getProperties();
        CreateIndex.Column[] columnArray = new CreateIndex.Column[propertyArray.length];
        int n = 0;
        while (n < propertyArray.length) {
            columnArray[n] = new CreateIndex.Column(propertyArray[n].getName(), BOrionObject.isDescending(propertyArray[n]));
            ++n;
        }
        return columnArray;
    }

    public String getTableName() {
        return this.tableName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TableBuilder(BOrionDatabase bOrionDatabase, OrionType orionType) {
        this.db = bOrionDatabase;
        this.type = orionType;
        this.dialect = (RdbmsDialect)bOrionDatabase.getRdbms().getRdbmsContext();
        this.instance = (BIOrionObject)orionType.getInstance();
        this.properties = orionType.getPersistentProperties();
        this.tableName = bOrionDatabase.getTableName(orionType);
        this.identity = null;
        int n = 0;
        while (n < this.properties.length) {
            if (BOrionObject.isIdentity(this.properties[n])) {
                if (this.identity == null) {
                    this.identity = this.properties[n];
                } else {
                    throw new OrionException("Only one identity column per table is allowed: " + this.properties[n].getName());
                }
            }
            ++n;
        }
    }
}

