/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.util.Array;
import javax.baja.util.TextUtil;

public class OrionSessionManager {
    private static Log LOG = Log.getLog((String)"orion.sessionManager");
    private static HashMap stacks = new HashMap();
    private static long count = 0L;
    private static long totalCount = 0L;
    private static int CLOSED_MAX_ENTRIES = 10;
    private static long peakActiveCount = 0L;
    private static HashMap peakStacks = new HashMap();
    private static BAbsTime peakActiveTime = BAbsTime.DEFAULT;
    private static LinkedHashMap closedStacks = new LinkedHashMap(CLOSED_MAX_ENTRIES){

        protected final boolean removeEldestEntry(Map.Entry entry) {
            boolean bl = false;
            if (this.size() > CLOSED_MAX_ENTRIES) {
                bl = true;
            }
            return bl;
        }
    };
    private static Array longestStacks = new Array();

    public static String getSessionId(DbOrionSession dbOrionSession) {
        return "" + System.identityHashCode(dbOrionSession);
    }

    public void openSpy(DbOrionSession dbOrionSession) {
        if (!LOG.isTraceOn()) {
            return;
        }
        totalCount = Long.MAX_VALUE > totalCount ? ++totalCount : ++count;
        try {
            throw new Exception("OpenStackTrace");
        }
        catch (Exception exception) {
            stacks.put(OrionSessionManager.getSessionId(dbOrionSession), new TimedStackTrace(exception));
            if (count > peakActiveCount) {
                peakActiveTime = BAbsTime.now();
                peakActiveCount = count;
                peakStacks.clear();
                peakStacks.putAll(stacks);
            }
            return;
        }
    }

    public void closeSpy(DbOrionSession dbOrionSession) {
        if (!LOG.isTraceOn()) {
            return;
        }
        String string = OrionSessionManager.getSessionId(dbOrionSession);
        TimedStackTrace timedStackTrace = (TimedStackTrace)stacks.remove(string);
        if (timedStackTrace != null) {
            --count;
        } else {
            timedStackTrace = new TimedStackTrace(null);
        }
        try {
            throw new Exception("ClosedStackTrace");
        }
        catch (Exception exception) {
            BRelTime bRelTime;
            timedStackTrace.setClose(exception);
            closedStacks.put(string, timedStackTrace);
            if (peakStacks.get(string) != null) {
                peakStacks.put(string, timedStackTrace);
            }
            if ((bRelTime = timedStackTrace.delta()).getMillis() > 0L) {
                longestStacks.add((Object)timedStackTrace);
                longestStacks = longestStacks.sort();
                if (longestStacks.size() >= CLOSED_MAX_ENTRIES) {
                    longestStacks.remove(CLOSED_MAX_ENTRIES - 1);
                }
            }
            return;
        }
    }

    public static long getPeakActiveCount() {
        return peakActiveCount;
    }

    public OrionSessionManager() {
        SummaryPage summaryPage = new SummaryPage();
        Nre.spySysManagers.add("orionSessionManager", (Spy)summaryPage);
    }

    static class TimedStackTrace
    implements Comparable {
        BAbsTime openTime = BAbsTime.now();
        BAbsTime closeTime;
        Exception openTrace;
        Exception closeTrace;

        void setClose(Exception exception) {
            this.closeTime = BAbsTime.now();
            this.closeTrace = exception;
        }

        public int compareTo(Object object) {
            return ((TimedStackTrace)object).delta().compareTo((Object)this.delta());
        }

        BRelTime delta() {
            if (this.closeTime != null) {
                return this.openTime.delta(this.closeTime);
            }
            return this.openTime.delta(BAbsTime.now());
        }

        TimedStackTrace(Exception exception) {
            this.openTrace = exception;
        }
    }

    public static class SummaryPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            BFacets bFacets = BFacets.make((String)"showMilliseconds", (boolean)true);
            spyWriter.startProps("Closed Stats");
            if (!LOG.isTraceOn()) {
                spyWriter.prop((Object)"Orion Session Manager Not Active", (Object)"<a href='spy:/logSetup/trace-orion.sessionManager'>Click here to turn orion.sessionManager Log to 'trace' </a>");
                spyWriter.endProps();
                return;
            }
            spyWriter.prop((Object)"Closed Count", (Object)("" + (totalCount - count)));
            spyWriter.prop((Object)"Recently Closed Stack Traces", (Object)"<a href='closed'>View</a>");
            spyWriter.prop((Object)"Longest Closed Stack Traces", (Object)"<a href='longestClosed'>View</a>");
            spyWriter.endProps();
            spyWriter.startProps("Peak Open Stats");
            spyWriter.prop((Object)"Peak Open Count", (Object)("" + peakActiveCount));
            spyWriter.prop((Object)"Peak Open Time", (Object)peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
            spyWriter.prop((Object)"Peak Open Stack Traces", (Object)"<a href='peakStacks'>View</a>");
            spyWriter.endProps();
            spyWriter.startProps("Currently Open Stats");
            spyWriter.prop((Object)"Open Count", (Object)("" + count));
            Collection collection = stacks.values();
            Set set = stacks.keySet();
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = set.toArray();
            if (count != (long)objectArray2.length) {
                spyWriter.prop((Object)"Acknowledged Open Count", (Object)("" + (count - (long)objectArray2.length)));
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                RemoveSpy removeSpy = new RemoveSpy(objectArray2[n], "" + n, stacks);
                this.add("" + n, (Spy)removeSpy);
                spyWriter.prop((Object)("Open Session " + objectArray2[n]), (Object)("<a href='" + n + "'>Acknowledge</a>"));
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                spyWriter.prop((Object)"Open Time ", (Object)timedStackTrace.delta());
                Exception exception = timedStackTrace.openTrace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                --n;
            }
            spyWriter.endProps();
        }

        public SummaryPage() {
            this.add("closed", (Spy)new ClosedSpy());
            this.add("peakStacks", (Spy)new PeakStacksSpy());
            this.add("longestClosed", (Spy)new LongestClosedSpy());
        }
    }

    public static class PeakStacksSpy
    extends SpyDir {
        public void write(SpyWriter spyWriter) {
            spyWriter.startProps();
            Collection collection = peakStacks.values();
            Set set = peakStacks.keySet();
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = set.toArray();
            spyWriter.prop((Object)"Peak Open Time", (Object)peakActiveTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
            spyWriter.prop((Object)"Peak Open Stacks Count", (Object)("" + objectArray2.length));
            if (peakActiveCount != (long)objectArray2.length) {
                peakActiveCount = objectArray2.length;
            }
            if (objectArray.length > 1) {
                spyWriter.prop((Object)"", (Object)"<a href='resetStats'>Reset Stats</a>");
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                if (timedStackTrace.closeTrace == null) {
                    spyWriter.prop((Object)("Open Session " + objectArray2[n]), (Object)"");
                } else {
                    spyWriter.prop((Object)("Closed Session " + objectArray2[n]), (Object)"");
                }
                if (timedStackTrace.closeTrace == null) {
                    spyWriter.prop((Object)"Time Session has been Open ", (Object)timedStackTrace.delta());
                } else {
                    spyWriter.prop((Object)"Time Session was Open ", (Object)timedStackTrace.delta());
                }
                Exception exception = timedStackTrace.openTrace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                --n;
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return "peakStacks";
        }

        public PeakStacksSpy() {
            this.add("resetStats", (Spy)new RemoveAllSpy("resetStats", "Peak Stats Reset", "Return to Peak Stats", peakStacks));
        }
    }

    public static class LongestClosedSpy
    extends SpyDir {
        public void write(SpyWriter spyWriter) {
            spyWriter.startProps();
            spyWriter.prop((Object)"", (Object)"<a href='removeAllLongest'>Reset Longest</a>");
            Object[] objectArray = longestStacks.trim();
            int n = 0;
            while (n < objectArray.length) {
                spyWriter.prop((Object)("Closed Session " + n), (Object)"");
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                spyWriter.prop((Object)"Time Session was Open ", (Object)timedStackTrace.delta());
                spyWriter.prop((Object)"Close Time", (Object)timedStackTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception exception = timedStackTrace.closeTrace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                ++n;
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return "longestClosed";
        }

        public LongestClosedSpy() {
            this.add("removeAllLongest", (Spy)new RemoveAllLongSpy("removeAllLongest", "Longest Stack Traces Reset", "Return"));
        }
    }

    public static class ClosedSpy
    extends SpyDir {
        public void write(SpyWriter spyWriter) {
            spyWriter.startProps();
            Collection collection = closedStacks.values();
            Set set = closedStacks.keySet();
            Object[] objectArray = collection.toArray();
            Object[] objectArray2 = set.toArray();
            spyWriter.prop((Object)"Recently Closed Stack Traces Count", (Object)("" + objectArray2.length));
            if (objectArray.length > 1) {
                spyWriter.prop((Object)"", (Object)"<a href='removeAll'>Acknowledge All</a>");
            }
            int n = objectArray.length - 1;
            while (n >= 0) {
                RemoveSpy removeSpy = new RemoveSpy(objectArray2[n], "" + n, closedStacks);
                this.add("" + n, (Spy)removeSpy);
                spyWriter.prop((Object)("Closed Session " + objectArray2[n]), (Object)("<a href='" + n + "'>Acknowledge</a>"));
                TimedStackTrace timedStackTrace = (TimedStackTrace)objectArray[n];
                spyWriter.prop((Object)"Time Session was Open ", (Object)timedStackTrace.delta());
                spyWriter.prop((Object)"Close Time", (Object)timedStackTrace.closeTime.toString((Context)BFacets.make((String)"showMilliseconds", (boolean)true)));
                Exception exception = timedStackTrace.closeTrace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                String[] stringArray = TextUtil.split((String)((Object)stringWriter).toString(), (char)'\n');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 == 0) {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    } else {
                        spyWriter.prop((Object)"", (Object)stringArray[n2].toString());
                    }
                    ++n2;
                }
                --n;
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return "closed";
        }

        public ClosedSpy() {
            this.add("removeAll", (Spy)new RemoveAllSpy("removeAll", "All Closed Stack Traces Acknowledged", "Return to Closed Traces Summary", closedStacks));
        }
    }

    public static class RemoveAllSpy
    extends SpyDir {
        private Object key;
        private String title;
        private HashMap hashMap;
        private String ackMsg;
        private String navMsg;

        public void write(SpyWriter spyWriter) {
            this.hashMap.clear();
            if (peakStacks == this.hashMap) {
                peakActiveCount = 0L;
            }
            spyWriter.startProps();
            spyWriter.prop((Object)this.ackMsg, (Object)("<a href='..'>" + this.navMsg + "</a>"));
            spyWriter.endProps();
        }

        public String getTitle() {
            return this.title;
        }

        public RemoveAllSpy(String string, String string2, String string3, HashMap hashMap) {
            this.title = string;
            this.hashMap = hashMap;
            this.ackMsg = string2;
            this.navMsg = string3;
        }
    }

    public static class RemoveAllLongSpy
    extends SpyDir {
        private Object key;
        private String title;
        private HashMap hashMap;
        private String ackMsg;
        private String navMsg;

        public void write(SpyWriter spyWriter) {
            longestStacks.clear();
            spyWriter.startProps();
            spyWriter.prop((Object)this.ackMsg, (Object)("<a href='..'>" + this.navMsg + "</a>"));
            spyWriter.endProps();
        }

        public String getTitle() {
            return this.title;
        }

        public RemoveAllLongSpy(String string, String string2, String string3) {
            this.title = string;
            this.ackMsg = string2;
            this.navMsg = string3;
        }
    }

    public static class RemoveSpy
    extends SpyDir {
        private Object key;
        private String title;
        private HashMap hashMap;

        public void write(SpyWriter spyWriter) {
            this.hashMap.remove(this.key);
            spyWriter.startProps();
            if (this.hashMap instanceof LinkedHashMap) {
                spyWriter.prop((Object)"Stack Trace Acknowledged", (Object)"<a href='..'>Return to Closed Traces Summary</a>");
            } else {
                spyWriter.prop((Object)"Stack Trace Acknowledged", (Object)"<a href='..'>Return to Orion Session Manager</a>");
            }
            spyWriter.endProps();
        }

        public String getTitle() {
            return this.title;
        }

        public RemoveSpy(Object object, String string, HashMap hashMap) {
            this.key = object;
            this.title = string;
            this.hashMap = hashMap;
        }
    }
}

