/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public class MapHelper {
    private static final AgentFilter filter = AgentFilter.is((Type)BIMappable.TYPE);

    public BIOrionObject mapForRead(BObject bObject) {
        return this.map(bObject, true);
    }

    public BIOrionObject mapForUpdate(BObject bObject) {
        return this.map(bObject, false);
    }

    public BIOrionObject mapForInsert(BObject bObject) {
        return this.map(bObject, false);
    }

    public BIOrionObject mapForDelete(BObject bObject) {
        return this.map(bObject, false);
    }

    public static BIOrionObject getOrionObjectInstance(BObject bObject) throws NoSuchAgentException, OrionException {
        AgentList agentList = bObject.getAgents().filter(filter);
        if (agentList.size() != 1) {
            if (agentList.size() == 0) {
                throw new NoSuchAgentException("There is no BIMappable orion object registered as an agent for objects of type: " + bObject.getType());
            }
            throw new OrionException("There can only be one BIMappable orion object registered on a BObject. Type " + bObject.getType() + " has " + agentList.size() + " agents registered.");
        }
        return (BIOrionObject)agentList.get(0).getInstance();
    }

    private final BIOrionObject map(BObject bObject, boolean bl) {
        BIOrionObject bIOrionObject = MapHelper.getOrionObjectInstance(bObject);
        OrionType orionType = (OrionType)bIOrionObject.getType();
        ((BIMappable)((Object)bIOrionObject)).mapFrom(bObject);
        Property[] propertyArray = orionType.getPersistentProperties();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            boolean bl2 = false;
            if (!(bl || BOrionObject.isKey(propertyArray[n]) || BOrionObject.isDbSourced(propertyArray[n]))) {
                bl2 = true;
            }
            bIOrionObject.setModified(property, bl2);
            ++n;
        }
        return bIOrionObject;
    }
}

