/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.util;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;

public abstract class CountingUtil {
    public static int getCount(OrionType orionType, OrionSession orionSession) {
        BSqlQuery bSqlQuery = BSqlQuery.make(orionType);
        return CountingUtil.getCount(bSqlQuery, orionSession);
    }

    public static int getCount(OrionType orionType, Property property, BSimple bSimple, OrionSession orionSession) {
        BSqlField bSqlField = new BSqlField(orionType, property);
        BExpression bExpression = Predicates.eq((BExpression)bSqlField, (BSimple)bSimple);
        return CountingUtil.getCount(orionType, bExpression, orionSession);
    }

    public static int getCount(OrionType orionType, BExpression bExpression, OrionSession orionSession) {
        BSqlQuery bSqlQuery = BSqlQuery.make(orionType);
        bSqlQuery.where(bExpression);
        return CountingUtil.getCount(bSqlQuery, orionSession);
    }

    public static int getCount(BQuery bQuery, OrionSession orionSession) {
        bQuery.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        if (bQuery.hasOrdering()) {
            bQuery.remove((BComplex)bQuery.getOrdering());
        }
        OrionCursor orionCursor = orionSession.select(bQuery);
        orionCursor.next();
        BDynamicOrionObject bDynamicOrionObject = (BDynamicOrionObject)orionCursor.get();
        OrionType orionType = bDynamicOrionObject.getOrionType();
        Property[] propertyArray = orionType.getProperties();
        int n = ((BInteger)bDynamicOrionObject.get(propertyArray[0])).getInt();
        return n;
    }
}

