/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.fox.encoding.BogCodec;
import com.tridium.fox.encoding.DecoderFactory;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionModule;
import com.tridium.orion.BOrionRoot;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.Ddl;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxDbSpec;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.query.BExpression;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class OrionRequest {
    private BOrionChannel channel;
    static /* synthetic */ Class class$com$tridium$orion$BOrionDatabase;

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        if (string == "ping") {
            return this.ping(foxRequest);
        }
        if (string == "root") {
            return this.loadOrionRoot(foxRequest);
        }
        if (string == "closeSession") {
            return this.closeSession(foxRequest);
        }
        if (string == "commit") {
            return this.commit(foxRequest);
        }
        if (string == "rollback") {
            return this.rollback(foxRequest);
        }
        if (string == "exists") {
            return this.exists(foxRequest);
        }
        if (string == "updateRaw") {
            return this.updateRaw(foxRequest);
        }
        if (string == "qupdate") {
            return this.qupdate(foxRequest);
        }
        if (string == "deleteRaw") {
            return this.deleteRaw(foxRequest);
        }
        if (string == "insertRaw") {
            return this.insertRaw(foxRequest);
        }
        if (string == "invokeDdl") {
            return this.invokeDdl(foxRequest);
        }
        if (string == "getRdbmsTypeSpec") {
            return this.getRdbmsTypeSpec(foxRequest);
        }
        if (string == "qdelete") {
            return this.qdelete(foxRequest);
        }
        if (string == "getDbs") {
            return this.getOrionDatabases(foxRequest);
        }
        if (string == "listModules") {
            return this.listModules(foxRequest);
        }
        if (string == "listTypes") {
            return this.listTypes(foxRequest);
        }
        if (string == "getDbForApp") {
            return this.getDbForApp(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public BTypeSpec getRdbmsTypeSpec(FoxOrionSession foxOrionSession) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("getRdbmsTypeSpec");
        this.channel.setSession(foxOrionSession, foxRequest);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return BTypeSpec.make((String)foxResponse.getString("result"));
    }

    private final FoxResponse getRdbmsTypeSpec(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BLocalOrionDatabase bLocalOrionDatabase = (BLocalOrionDatabase)orionSession.getOrionDatabase();
            foxResponse.add("result", bLocalOrionDatabase.getRdbms().getType().getTypeSpec().toString());
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public void invokeDdl(FoxOrionSession foxOrionSession, String string) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("invokeDdl");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("sql", string);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
    }

    private final FoxResponse invokeDdl(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            DbOrionSession dbOrionSession = (DbOrionSession)this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            Ddl ddl = new Ddl(dbOrionSession);
            BPermissions bPermissions = this.channel.getPermissionsFor(dbOrionSession.getOrionDatabase());
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            ddl.invokeDdl(foxRequest.getString("sql"));
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public void ping() throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("ping");
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        if (!foxResponse.getBoolean("enabled")) {
            throw new OrionException("Target disabled.");
        }
    }

    private final FoxResponse ping(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            boolean bl = false;
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            bl = bOrionService.getStatus().isDisabled() ^ true;
            foxResponse.add("enabled", bl);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public BOrionRoot loadOrionRoot() throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("root");
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        String string = foxResponse.getString("p", null);
        if (string == null) {
            return null;
        }
        BPermissions bPermissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(foxResponse.getString("p"));
        BCategoryMask bCategoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxResponse.getString("c"));
        BOrionRoot bOrionRoot = new BOrionRoot(bPermissions);
        bOrionRoot.setCategoryMask(bCategoryMask, Context.decoding);
        return bOrionRoot;
    }

    private final FoxResponse loadOrionRoot(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace bOrionSpace = bOrionService.getOrionSpace();
            BComponent bComponent = bOrionSpace.getRootComponent();
            BPermissions bPermissions = this.channel.getPermissionsFor(bComponent);
            if (!bPermissions.hasOperatorRead()) {
                return foxResponse;
            }
            foxResponse.add("p", this.channel.getPermissionsFor(bComponent).encodeToString());
            foxResponse.add("c", bComponent.getCategoryMask().encodeToString());
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public void closeSession(FoxOrionSession foxOrionSession) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("closeSession");
        this.channel.setSession(foxOrionSession, foxRequest);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        foxOrionSession.closed();
    }

    private final FoxResponse closeSession(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            int n = foxRequest.getInt("sessionId");
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, false);
            orionSession.close();
            this.channel.unregisterSession(n);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public void commit(FoxOrionSession foxOrionSession) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("commit");
        this.channel.setSession(foxOrionSession, foxRequest);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
    }

    private final FoxResponse commit(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            orionSession.commit();
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public void rollback(FoxOrionSession foxOrionSession) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("rollback");
        this.channel.setSession(foxOrionSession, foxRequest);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
    }

    private final FoxResponse rollback(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            orionSession.rollback();
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public BOrionModule[] listModules(BFoxOrionDatabase bFoxOrionDatabase) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("listModules");
        foxRequest.add("dbId", bFoxOrionDatabase.getId());
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        FoxTuple[] foxTupleArray = foxResponse.list("m");
        BOrionModule[] bOrionModuleArray = new BOrionModule[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            String string = foxMessage.getString("n");
            BCategoryMask bCategoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxMessage.getString("c"));
            BPermissions bPermissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(foxMessage.getString("p"));
            bOrionModuleArray[n] = new BOrionModule(string, bPermissions);
            bOrionModuleArray[n].setCategoryMask(bCategoryMask, Context.decoding);
            ++n;
        }
        return bOrionModuleArray;
    }

    private final FoxResponse listModules(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            String string = foxRequest.getString("dbId");
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase bOrionDatabase = bOrionService.getOrionDatabase(string);
            BOrionModule[] bOrionModuleArray = bOrionDatabase.getModules();
            int n = 0;
            while (n < bOrionModuleArray.length) {
                BPermissions bPermissions = this.channel.getPermissionsFor(bOrionModuleArray[n]);
                if (bPermissions.hasOperatorRead()) {
                    FoxMessage foxMessage = new FoxMessage("m");
                    foxMessage.add("n", bOrionModuleArray[n].getName());
                    foxMessage.add("c", bOrionModuleArray[n].getCategoryMask().encodeToString());
                    foxMessage.add("p", bPermissions.encodeToString());
                    foxResponse.add("m", foxMessage);
                }
                ++n;
            }
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public BOrionType[] listTypes(BFoxOrionDatabase bFoxOrionDatabase, BOrionModule bOrionModule) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.channel.makeRequest("listTypes");
        foxRequest.add("dbId", bFoxOrionDatabase.getId());
        if (bOrionModule != null) {
            foxRequest.add("m", bOrionModule.getModuleName());
        }
        if ((foxResponse = this.channel.sendSync(foxRequest)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        FoxTuple[] foxTupleArray = foxResponse.list("t");
        BOrionType[] bOrionTypeArray = new BOrionType[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            String string = foxMessage.getString("m");
            String string2 = foxMessage.getString("t");
            BCategoryMask bCategoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxMessage.getString("c"));
            BPermissions bPermissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(foxMessage.getString("p"));
            bOrionTypeArray[n] = new BOrionType(string, string2, bPermissions);
            bOrionTypeArray[n].setCategoryMask(bCategoryMask, Context.decoding);
            ++n;
        }
        return bOrionTypeArray;
    }

    private final FoxResponse listTypes(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            String string = foxRequest.getString("dbId");
            String string2 = foxRequest.getString("m", null);
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionDatabase bOrionDatabase = bOrionService.getOrionDatabase(string);
            BOrionModule bOrionModule = string2 == null ? null : bOrionDatabase.getModule(string2);
            BOrionType[] bOrionTypeArray = bOrionService.getOrionSpace().listTypes(bOrionDatabase, bOrionModule);
            int n = 0;
            while (n < bOrionTypeArray.length) {
                BPermissions bPermissions = this.channel.getPermissionsFor(bOrionTypeArray[n]);
                if (bPermissions.hasOperatorRead()) {
                    FoxMessage foxMessage = new FoxMessage("t");
                    foxMessage.add("m", bOrionTypeArray[n].getModule().getModuleName());
                    foxMessage.add("t", bOrionTypeArray[n].getTypeName());
                    foxMessage.add("c", bOrionTypeArray[n].getCategoryMask().encodeToString());
                    foxMessage.add("p", bPermissions.encodeToString());
                    foxResponse.add("t", foxMessage);
                }
                ++n;
            }
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public String getDbForApp(BOrd bOrd) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("getDbForApp");
        foxRequest.add("appOrd", bOrd.encodeToString());
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        return foxResponse.getString("dbId", null);
    }

    private final FoxResponse getDbForApp(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            BOrd bOrd = (BOrd)BOrd.DEFAULT.decodeFromString(foxRequest.getString("appOrd"));
            BIOrionApp bIOrionApp = (BIOrionApp)bOrd.get();
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionSpace bOrionSpace = bOrionService.getOrionSpace();
            BOrionDatabase bOrionDatabase = bOrionSpace.getOrionDatabaseForApp(bIOrionApp);
            if (bOrionDatabase != null) {
                foxResponse.add("dbId", bOrionDatabase.getId());
            }
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public boolean exists(FoxOrionSession foxOrionSession, OrionType orionType, PropertyValue[] propertyValueArray) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("exists");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("objType", orionType.getOrionTypeId().encodeToString());
        this.channel.encodePropertyValues((FoxMessage)foxRequest, "key", propertyValueArray);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getBoolean("result");
    }

    private final FoxResponse exists(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BOrionTypeId bOrionTypeId = (BOrionTypeId)BOrionTypeId.DEFAULT.decodeFromString(foxRequest.getString("objType"));
            OrionType orionType = orionSession.getOrionDatabase().getType(bOrionTypeId);
            PropertyValue[] propertyValueArray = this.channel.decodePropertyValues(orionType, (FoxMessage)foxRequest, "key");
            BIOrionObject bIOrionObject = orionSession.read(orionType, propertyValueArray);
            boolean bl = false;
            if (bIOrionObject != null && this.channel.getPermissionsFor(bIOrionObject).hasOperatorRead()) {
                bl = true;
            }
            foxResponse.add("result", bl);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public int qupdate(FoxOrionSession foxOrionSession, BSqlUpdate bSqlUpdate) throws Exception {
        FoxRequest foxRequest = this.channel.makeRequest("qupdate");
        this.channel.setSession(foxOrionSession, foxRequest);
        BogCodec.add((FoxMessage)foxRequest, (String)"update", (BValue)bSqlUpdate, null);
        FoxResponse foxResponse = this.channel.sendSync(foxRequest);
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getInt("result");
    }

    private final FoxResponse qupdate(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BSqlUpdate bSqlUpdate = (BSqlUpdate)((Object)DecoderFactory.decode((FoxMessage)foxRequest, (String)"update", null));
            foxResponse.add("result", orionSession.update(bSqlUpdate));
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public int updateRaw(FoxOrionSession foxOrionSession, String string, BSimple[] bSimpleArray) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.channel.makeRequest("updateRaw");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("sql", string);
        if (bSimpleArray != null) {
            this.channel.encodeParameters((FoxMessage)foxRequest, bSimpleArray);
        }
        if ((foxResponse = this.channel.sendSync(foxRequest)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getInt("result");
    }

    private final FoxResponse updateRaw(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BPermissions bPermissions = this.channel.getPermissionsFor(orionSession.getOrionDatabase());
            String string = foxRequest.getString("sql");
            BSimple[] bSimpleArray = this.channel.decodeParameters((FoxMessage)foxRequest);
            int n = 0;
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            n = orionSession.update(string, bSimpleArray);
            foxResponse.add("result", n);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public int qdelete(FoxOrionSession foxOrionSession, OrionType orionType, BExpression bExpression) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.channel.makeRequest("qdelete");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("typeId", orionType.getOrionTypeId().encodeToString());
        boolean bl = false;
        if (bExpression != null) {
            bl = true;
        }
        foxRequest.add("hasCondition", bl);
        if (bExpression != null) {
            BogCodec.add((FoxMessage)foxRequest, (String)"condition", (BValue)bExpression, null);
        }
        if ((foxResponse = this.channel.sendSync(foxRequest)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getInt("result");
    }

    private final FoxResponse qdelete(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            OrionType orionType = orionSession.getOrionDatabase().getType(BOrionTypeId.make(foxRequest.getString("typeId")));
            BExpression bExpression = null;
            if (foxRequest.getBoolean("hasCondition")) {
                bExpression = (BExpression)DecoderFactory.decode((FoxMessage)foxRequest, (String)"condition", null);
            }
            foxResponse.add("result", orionSession.delete(orionType, bExpression));
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public int insertRaw(FoxOrionSession foxOrionSession, String string, BSimple[] bSimpleArray) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.channel.makeRequest("insertRaw");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("sql", string);
        if (bSimpleArray != null) {
            this.channel.encodeParameters((FoxMessage)foxRequest, bSimpleArray);
        }
        if ((foxResponse = this.channel.sendSync(foxRequest)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getInt("result");
    }

    private final FoxResponse insertRaw(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BPermissions bPermissions = this.channel.getPermissionsFor(orionSession.getOrionDatabase());
            int n = 0;
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            String string = foxRequest.getString("sql");
            BSimple[] bSimpleArray = this.channel.decodeParameters((FoxMessage)foxRequest);
            n = orionSession.insert(string, bSimpleArray);
            foxResponse.add("result", n);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public int deleteRaw(FoxOrionSession foxOrionSession, String string, BSimple[] bSimpleArray) throws Exception {
        FoxResponse foxResponse;
        FoxRequest foxRequest = this.channel.makeRequest("deleteRaw");
        this.channel.setSession(foxOrionSession, foxRequest);
        foxRequest.add("sql", string);
        if (bSimpleArray != null) {
            this.channel.encodeParameters((FoxMessage)foxRequest, bSimpleArray);
        }
        if ((foxResponse = this.channel.sendSync(foxRequest)).getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        this.channel.assignSessionId(foxOrionSession, (FoxMessage)foxResponse);
        return foxResponse.getInt("result");
    }

    private final FoxResponse deleteRaw(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            OrionSession orionSession = this.channel.getSession((FoxMessage)foxRequest, foxResponse, true);
            BPermissions bPermissions = this.channel.getPermissionsFor(orionSession.getOrionDatabase());
            int n = 0;
            if (!bPermissions.hasAdminWrite()) {
                throw new PermissionException("Insufficient Permission");
            }
            String string = foxRequest.getString("sql");
            BSimple[] bSimpleArray = this.channel.decodeParameters((FoxMessage)foxRequest);
            n = orionSession.delete(string, bSimpleArray);
            foxResponse.add("result", n);
            return foxResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public FoxDbSpec[] getOrionDatabases() throws Exception {
        FoxResponse foxResponse = this.channel.sendSync(this.channel.makeRequest("getDbs"));
        if (foxResponse.getString("exception", null) != null) {
            throw Fox.exceptionTranslator.messageToException((FoxMessage)foxResponse);
        }
        FoxTuple[] foxTupleArray = foxResponse.list("db");
        FoxDbSpec[] foxDbSpecArray = new FoxDbSpec[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            FoxMessage foxMessage = (FoxMessage)foxTupleArray[n];
            BCategoryMask bCategoryMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(foxMessage.getString("c"));
            BPermissions bPermissions = (BPermissions)BPermissions.DEFAULT.decodeFromString(foxMessage.getString("p"));
            foxDbSpecArray[n] = new FoxDbSpec(foxMessage.getString("name"), foxMessage.getString("id"), bCategoryMask, bPermissions);
            ++n;
        }
        return foxDbSpecArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final FoxResponse getOrionDatabases(FoxRequest foxRequest) throws Exception {
        try {
            FoxResponse foxResponse = new FoxResponse(foxRequest);
            BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
            BOrionRoot bOrionRoot = (BOrionRoot)bOrionService.getOrionSpace().getRootComponent();
            Class clazz = class$com$tridium$orion$BOrionDatabase;
            if (clazz == null) {
                clazz = class$com$tridium$orion$BOrionDatabase = OrionRequest.class("[Lcom.tridium.orion.BOrionDatabase;", false);
            }
            Array array = new Array(clazz);
            SlotCursor slotCursor = bOrionRoot.getProperties();
            while (true) {
                Class clazz2;
                if ((clazz2 = class$com$tridium$orion$BOrionDatabase) == null) {
                    clazz2 = OrionRequest.class("[Lcom.tridium.orion.BOrionDatabase;", false);
                }
                if (!slotCursor.next(clazz2)) {
                    return foxResponse;
                }
                BOrionDatabase bOrionDatabase = (BOrionDatabase)slotCursor.get();
                BPermissions bPermissions = this.channel.getPermissionsFor(bOrionDatabase);
                if (!bPermissions.hasOperatorRead()) continue;
                FoxMessage foxMessage = new FoxMessage("db");
                foxMessage.add("name", bOrionDatabase.getName());
                foxMessage.add("id", bOrionDatabase.getId());
                foxMessage.add("c", bOrionDatabase.getCategoryMask().encodeToString());
                foxMessage.add("p", bPermissions.encodeToString());
                foxResponse.add("db", foxMessage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.exceptionToResponse(exception);
        }
    }

    public FoxResponse exceptionToResponse(Throwable throwable) {
        FoxResponse foxResponse = new FoxResponse();
        foxResponse.add("exception", throwable.toString());
        return foxResponse;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    OrionRequest(BOrionChannel bOrionChannel) {
        this.channel = bOrionChannel;
    }
}

