/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.sql.BatchStatement;
import javax.baja.util.Array;

public abstract class FoxBatch
implements BatchStatement {
    protected final FoxOrionSession session;
    protected final BOrionChannel channel;
    protected final OrionType type;
    protected final Array arr;
    protected int chunkSize;

    public void add(BIOrionObject bIOrionObject) {
        if (!bIOrionObject.getOrionType().equals(this.type)) {
            throw new OrionException("Type mismatch: object type (" + bIOrionObject.getOrionType() + ")  is not the same as the batch type (" + this.type + ").");
        }
        this.arr.add((Object)bIOrionObject);
    }

    public BIOrionObject get(int n) {
        return (BIOrionObject)this.arr.get(n);
    }

    public int size() {
        return this.arr.size();
    }

    public void clear() {
        this.arr.clear();
    }

    public OrionType getOrionType() {
        return this.type;
    }

    public void setChunkSize(int n) {
        if (n < 0) {
            throw new OrionException("Invalid chunkSize of '" + n + "'.  The chunkSize must be >= 0.");
        }
        this.chunkSize = n;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public FoxBatch(FoxOrionSession foxOrionSession, BOrionChannel bOrionChannel, OrionType orionType) {
        this.session = foxOrionSession;
        this.channel = bOrionChannel;
        this.type = orionType;
        this.arr = new Array(orionType.getTypeClass());
    }
}

