/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.audit.BOrionAuditWorker;
import com.tridium.orion.priv.db.ColumnDefinition;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.SessionHelper;
import com.tridium.orion.priv.db.sql.SqlHelper;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.util.Exprs;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BTypeSpec;

public class Update
extends SessionHelper {
    public int update(BSqlUpdate bSqlUpdate) {
        UpdateVisitor updateVisitor = new UpdateVisitor(this.db);
        updateVisitor.visit(bSqlUpdate);
        this.logBQuery(updateVisitor);
        return this.updateOrDelete("UPDATE", updateVisitor.getQueryString(), updateVisitor.getParameters());
    }

    public void update(BIOrionObject bIOrionObject) {
        this.update(bIOrionObject, false);
    }

    public void update(BIOrionObject bIOrionObject, boolean bl) {
        if (!this.canWrite(bIOrionObject)) {
            return;
        }
        if (bl || this.needsUpdate(bIOrionObject)) {
            if (bIOrionObject.beforeUpdate(this.session)) {
                this.doUpdate(bIOrionObject, bl);
                if (bIOrionObject.isAuditable() && this.session.getUser() != null) {
                    Property[] propertyArray = bIOrionObject.getOrionType().getProperties();
                    int n = 0;
                    while (n < propertyArray.length) {
                        if (!BOrionObject.isKey(propertyArray[n]) && (bl || bIOrionObject.isModified(propertyArray[n])) && !Flags.isNoAudit((BComplex)((BComplex)bIOrionObject), (Slot)propertyArray[n])) {
                            BOrionAuditWorker.auditModified(bIOrionObject, propertyArray[n], this.session);
                        }
                        ++n;
                    }
                }
                bIOrionObject.clearAllModified();
                bIOrionObject.afterUpdate(this.session);
            } else if (this.log.isTraceOn()) {
                this.log.trace("VETOED UPDATE: " + bIOrionObject);
            }
        }
    }

    private final boolean needsUpdate(BIOrionObject bIOrionObject) {
        OrionType orionType = bIOrionObject.getOrionType();
        Property[] propertyArray = orionType.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (BOrionObject.isKey(propertyArray[n])) {
                if (bIOrionObject.isModified(propertyArray[n])) {
                    throw new OrionException("Keys cannot be modified");
                }
            } else if (bIOrionObject.isModified(propertyArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final int doUpdate(BIOrionObject bIOrionObject, boolean bl) {
        OrionType orionType = bIOrionObject.getOrionType();
        TableDefinition tableDefinition = TableDefinition.get(this.db, orionType);
        Property[] propertyArray = orionType.getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            if (BOrionObject.isKey(propertyArray[n]) && bIOrionObject.isModified(propertyArray[n])) {
                throw new OrionException("Keys cannot be modified");
            }
            ++n;
        }
        String string = Update.buildUpdateSql(tableDefinition, orionType, bl, bIOrionObject);
        try {
            RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, string);
            Update.loadUpdateStatement(rdbmsPreparedStatement, tableDefinition, orionType, bl, bIOrionObject);
            int n2 = rdbmsPreparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new OrionException("Unexpected row count during update: " + n2);
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public static String buildUpdateSql(TableDefinition tableDefinition, OrionType orionType, boolean bl, BIOrionObject bIOrionObject) {
        Property[] propertyArray = orionType.getProperties();
        Property[] propertyArray2 = orionType.getKey();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(tableDefinition.getTableName()).append(" SET ");
        int n = 0;
        int n2 = 0;
        while (n2 < propertyArray.length) {
            if (!BOrionObject.isKey(propertyArray[n2]) && (bl || bIOrionObject.isModified(propertyArray[n2]))) {
                if (n++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(propertyArray[n2].getName()).append(" = ?");
            }
            ++n2;
        }
        stringBuffer.append(" WHERE ");
        n2 = 0;
        while (n2 < propertyArray2.length) {
            if (n2 > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("(");
            stringBuffer.append(propertyArray2[n2].getName());
            stringBuffer.append(" = ?)");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void loadUpdateStatement(RdbmsPreparedStatement rdbmsPreparedStatement, TableDefinition tableDefinition, OrionType orionType, boolean bl, BIOrionObject bIOrionObject) {
        Property[] propertyArray = orionType.getProperties();
        Property[] propertyArray2 = orionType.getKey();
        int n = 1;
        ColumnDefinition[] columnDefinitionArray = tableDefinition.getColumns();
        int n2 = 0;
        while (n2 < propertyArray.length) {
            if (!BOrionObject.isKey(propertyArray[n2]) && (bl || bIOrionObject.isModified(propertyArray[n2]))) {
                columnDefinitionArray[n2].getTranslator().setPreparedStatementValue(rdbmsPreparedStatement, n++, bIOrionObject.get(propertyArray[n2]), (Context)propertyArray[n2].getFacets());
            }
            ++n2;
        }
        ColumnDefinition[] columnDefinitionArray2 = tableDefinition.getKeyColumns();
        int n3 = 0;
        while (n3 < columnDefinitionArray2.length) {
            columnDefinitionArray2[n3].getTranslator().setPreparedStatementValue(rdbmsPreparedStatement, n++, bIOrionObject.get(propertyArray2[n3]), (Context)columnDefinitionArray2[n3].getProperty().getFacets());
            ++n3;
        }
    }

    public Update(DbOrionSession dbOrionSession) {
        super(dbOrionSession);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class UpdateVisitor
    extends SqlVisitor {
        static /* synthetic */ Class class$javax$baja$sys$BSimple;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void visit(BSqlUpdate bSqlUpdate) {
            this.initialize();
            this.helper = new SqlHelper(this.db, null);
            if (bSqlUpdate.getUpdateTable().equals((Object)BTypeSpec.DEFAULT)) {
                throw new OrionException("Cannot update. updateTable is not set.");
            }
            this.queryText.append("UPDATE ");
            this.visit(new BSqlExtent(bSqlUpdate.getUpdateTable()));
            this.queryText.append("SET ");
            try {
                this.setUseParameterSubstitution(true);
                this.visit(bSqlUpdate.getUpdateMap());
                if (bSqlUpdate.hasCondition()) {
                    this.queryText.append("WHERE ");
                    this.visit(bSqlUpdate.getCondition());
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.setUseParameterSubstitution(false);
                throw throwable;
            }
            {
                Object var3_4 = null;
            }
            this.setUseParameterSubstitution(false);
        }

        public void visit(BFieldExpression bFieldExpression) {
            this.queryText.append(this.resolveFieldName(bFieldExpression));
        }

        private final String resolveFieldName(BFieldExpression bFieldExpression) {
            return bFieldExpression instanceof BSqlField ? ((BSqlField)bFieldExpression).getAliasedField(this.db) : bFieldExpression.getField();
        }

        /*
         * Unable to fully structure code
         */
        protected void visit(BVector var1_1) {
            var2_2 = var1_1.getSlots();
            var3_3 = 0;
            if (true) ** GOTO lbl12
            do {
                if (var3_3 > 0) {
                    this.queryText.append(", ");
                }
                this.queryText.append(var2_2.property().getName()).append(" = ");
                this.visit(Exprs.simple((BSimple)var2_2.get().asSimple()));
                ++var3_3;
lbl12:
                // 2 sources

                if ((v0 = UpdateVisitor.class$javax$baja$sys$BSimple) != null) continue;
                v0 = UpdateVisitor.class("[Ljavax.baja.sys.BSimple;", false);
            } while (var2_2.next(v0));
            this.queryText.append(' ');
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public UpdateVisitor(BLocalOrionDatabase bLocalOrionDatabase) {
            super(bLocalOrionDatabase);
        }
    }
}

