/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.sql.SqlVisitor;
import com.tridium.orion.priv.db.trans.TranslatorFactory;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.jdbc.trans.BColumnTranslator;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.log.Log;
import javax.baja.query.BQuery;
import javax.baja.query.BTypedExtent;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SessionHelper {
    protected Log log;
    protected Log queryLog;
    protected final DbOrionSession session;
    protected final BLocalOrionDatabase db;
    protected final RdbmsDialect dialect;
    protected final Connection conn;

    static String firstWord(String string) {
        int n = string.indexOf(32);
        return n == -1 ? string : string.substring(0, n);
    }

    public BPermissions getPermissionsFor(BIOrionObject bIOrionObject) {
        return this.getPermissionsFor((BObject)bIOrionObject);
    }

    public BPermissions getPermissionsFor(BObject bObject) {
        if (bObject instanceof BIProtected) {
            return ((BIProtected)bObject).getPermissions((Context)this.session);
        }
        return BPermissions.all;
    }

    public boolean canRead(BIOrionObject bIOrionObject) {
        return this.canRead((BObject)bIOrionObject);
    }

    public boolean canRead(BObject bObject) {
        return this.getPermissionsFor(bObject).hasOperatorRead();
    }

    public boolean canWrite(BIOrionObject bIOrionObject) {
        return this.canWrite((BObject)bIOrionObject);
    }

    public boolean canWrite(BObject bObject) {
        return this.getPermissionsFor(bObject).hasOperatorWrite();
    }

    public BPermissions getPermissionsForQuery(BQuery bQuery) {
        Object object;
        int n;
        BSqlJoin[] bSqlJoinArray;
        Object object2;
        if (this.session.getUser() == null) {
            return BPermissions.all;
        }
        int n2 = BPermissions.all.getMask();
        if (bQuery.hasExtent()) {
            object2 = bQuery.getExtent();
            if (!object2.isTypedExtent()) {
                return this.getPermissionsFor((BObject)this.db);
            }
            bSqlJoinArray = ((BTypedExtent)object2).listTypes();
            n = 0;
            while (n < bSqlJoinArray.length) {
                if (bSqlJoinArray[n] instanceof OrionType) {
                    object = this.db.getType((OrionType)((Object)bSqlJoinArray[n]));
                    if (object == null) {
                        return this.getPermissionsFor((BObject)this.db);
                    }
                    n2 &= this.getPermissionsFor((BObject)object).getMask();
                } else {
                    return this.getPermissionsFor((BObject)this.db);
                }
                ++n;
            }
        }
        if (bQuery instanceof BSqlQuery && (bSqlJoinArray = ((BSqlQuery)((Object)(object2 = (BSqlQuery)bQuery))).getJoins()) != null) {
            n = 0;
            while (n < bSqlJoinArray.length) {
                object = bSqlJoinArray[n].getJoinTable().listTypes();
                int n3 = 0;
                while (n3 < ((Type[])object).length) {
                    if (object[n3] instanceof OrionType) {
                        BOrionType bOrionType = this.db.getType((OrionType)object[n3]);
                        if (bOrionType == null) {
                            return this.getPermissionsFor((BObject)this.db);
                        }
                        n2 &= this.getPermissionsFor((BObject)bOrionType).getMask();
                    } else {
                        return this.getPermissionsFor((BObject)this.db);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        return BPermissions.make((int)n2);
    }

    public int updateOrDelete(String string, String string2) {
        if (!this.getPermissionsFor((BObject)this.db).hasAdminWrite()) {
            return 0;
        }
        String string3 = SessionHelper.firstWord(string2.trim()).toUpperCase();
        if (!string3.equals(string)) {
            throw new OrionException("Invalid '" + string + "' statement: " + string2);
        }
        if (this.log.isTraceOn()) {
            this.log.trace(string2);
        }
        try {
            return this.conn.createStatement().executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public int updateOrDelete(String string, String string2, BSimple[] bSimpleArray) {
        if (!this.getPermissionsFor((BObject)this.db).hasAdminWrite()) {
            return 0;
        }
        String string3 = SessionHelper.firstWord(string2.trim()).toUpperCase();
        if (!string3.equals(string)) {
            throw new OrionException("Invalid '" + string + "' statement: " + string2);
        }
        try {
            RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, string2);
            int n = 0;
            while (n < bSimpleArray.length) {
                BColumnTranslator bColumnTranslator = TranslatorFactory.make(this.dialect, (BValue)bSimpleArray[n]);
                bColumnTranslator.setPreparedStatementValue(rdbmsPreparedStatement, n + 1, (BValue)bSimpleArray[n], null);
                ++n;
            }
            return rdbmsPreparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    protected void logBQuery(SqlVisitor sqlVisitor) {
        if (this.queryLog.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer().append(sqlVisitor.getQueryString()).append(" : [");
            BSimple[] bSimpleArray = sqlVisitor.getParameters();
            int n = 0;
            while (n < bSimpleArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                try {
                    stringBuffer.append(bSimpleArray[n].encodeToString());
                }
                catch (Exception exception) {
                    stringBuffer.append(bSimpleArray[n].toString());
                }
                ++n;
            }
            stringBuffer.append("]\n");
            if (this.queryLog.isTraceOn()) {
                this.queryLog.trace(stringBuffer.toString());
            }
        }
    }

    private final /* synthetic */ void this() {
        this.log = Log.getLog((String)"orion.jdbc");
        this.queryLog = Log.getLog((String)"orion.queryToSql");
    }

    public SessionHelper(DbOrionSession dbOrionSession) {
        this.this();
        this.session = dbOrionSession;
        this.db = (BLocalOrionDatabase)dbOrionSession.getOrionDatabase();
        this.dialect = (RdbmsDialect)this.db.getRdbms().getRdbmsContext();
        this.conn = dbOrionSession.getConnection();
    }
}

