/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbCursor;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.EmptyOrionCursor;
import com.tridium.orion.priv.db.QueryResolveCursor;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.AutoResolveVisitor;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.priv.db.sql.PaginatedCursor;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import javax.baja.query.BQuery;
import javax.baja.security.BPermissions;
import javax.baja.sys.BSimple;

public class Select
extends Fetch {
    public OrionCursor select(BQuery bQuery) {
        BSqlQuery bSqlQuery;
        BPermissions bPermissions = this.getPermissionsForQuery(bQuery);
        if (!bPermissions.hasOperatorRead()) {
            AutoResolveVisitor autoResolveVisitor = new AutoResolveVisitor(this.db, this);
            autoResolveVisitor.visit(bQuery);
            OrionType orionType = autoResolveVisitor.getResultType();
            return new EmptyOrionCursor(this.session, orionType);
        }
        if (bQuery.getExtent().list().length > 1) {
            throw new OrionException("Orion does not support BQuerys with multiple base extents. Use BSqlQuery and add join statements.");
        }
        AutoResolveVisitor autoResolveVisitor = new AutoResolveVisitor(this.db, this);
        autoResolveVisitor.visit(bQuery);
        this.logBQuery(autoResolveVisitor);
        OrionCursor orionCursor = null;
        try {
            orionCursor = new QueryResolveCursor(this.session, autoResolveVisitor, this.makeQueryResultSet(autoResolveVisitor.getQueryString(), autoResolveVisitor.getParameters()));
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
        if (bQuery instanceof BSqlQuery && (bSqlQuery = (BSqlQuery)bQuery).hasPage() && !autoResolveVisitor.dbSupportsPagination()) {
            orionCursor = new PaginatedCursor(orionCursor, bSqlQuery.getPage());
        }
        return orionCursor;
    }

    public OrionCursor select(OrionType orionType, String string, BSimple[] bSimpleArray) {
        if (orionType.isDynamic() && !this.db.getPermissions(this.session).hasAdminRead()) {
            throw new OrionException("Admin permissions required.");
        }
        String string2 = Select.firstWord(string.trim()).toUpperCase();
        if (!string2.equals("SELECT")) {
            throw new OrionException("Invalid SELECT statement: " + string);
        }
        try {
            DbCursor dbCursor = new DbCursor(this.session, orionType, this.makeQueryResultSet(string, bSimpleArray), true, true);
            return dbCursor;
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public OrionCursor select(OrionType orionType, PropertyValue propertyValue) {
        return this.select(orionType, new PropertyValue[]{propertyValue});
    }

    public OrionCursor select(OrionType orionType, PropertyValue[] propertyValueArray) {
        TableDefinition tableDefinition = TableDefinition.get(this.db, orionType);
        String string = this.buildPreparedSelect(tableDefinition, propertyValueArray);
        try {
            RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, string);
            this.loadPreparedSelect(tableDefinition, propertyValueArray, rdbmsPreparedStatement);
            return new DbCursor(this.session, orionType, rdbmsPreparedStatement.executeQuery(), false, false);
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public Select(DbOrionSession dbOrionSession) {
        super(dbOrionSession);
    }
}

