/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbBatchDelete;
import com.tridium.orion.priv.db.DbBatchInsert;
import com.tridium.orion.priv.db.DbBatchPersist;
import com.tridium.orion.priv.db.DbBatchUpdate;
import com.tridium.orion.priv.db.sql.Ddl;
import com.tridium.orion.priv.db.sql.Delete;
import com.tridium.orion.priv.db.sql.Insert;
import com.tridium.orion.priv.db.sql.LinkedScan;
import com.tridium.orion.priv.db.sql.Read;
import com.tridium.orion.priv.db.sql.Scan;
import com.tridium.orion.priv.db.sql.Select;
import com.tridium.orion.priv.db.sql.Update;
import com.tridium.orion.priv.util.MapHelper;
import com.tridium.orion.priv.util.OrionSessionManager;
import com.tridium.orion.sql.BSqlUpdate;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.log.Log;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DbOrionSession
implements OrionSession {
    private static OrionSessionManager sessionManager = new OrionSessionManager();
    private static Log LOG = Log.getLog((String)"orion.jdbc");
    private static final int MAX_PREP_CACHE = 50;
    private Context context;
    private final BLocalOrionDatabase db;
    private Connection conn;
    private Ddl ddlHelper;
    private Delete deleteHelper;
    private Insert insertHelper;
    private LinkedScan linkedHelper;
    private MapHelper mapHelper;
    private Read readHelper;
    private Scan scanHelper;
    private Select selectHelper;
    private Update updateHelper;
    private LinkedHashMap prepCache;

    public BOrionDatabase getOrionDatabase() {
        return this.db;
    }

    public RdbmsContext getRdbmsContext() {
        return this.db.getRdbms().getRdbmsContext();
    }

    public void setAutoCommit(boolean bl) {
        try {
            this.conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            throw new OrionException("Operation failed.", sQLException);
        }
    }

    public boolean getAutoCommit() {
        try {
            return this.conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw new OrionException("Operation failed.", sQLException);
        }
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            throw new OrionException("Commit failed.", sQLException);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            throw new OrionException("Rollback failed.", sQLException);
        }
    }

    public boolean isOpen() {
        try {
            boolean bl = false;
            if (this.conn != null && !this.conn.isClosed()) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new OrionException("Operation failed.");
        }
    }

    public void close() {
        try {
            if (!this.conn.getAutoCommit()) {
                this.rollback();
            }
            this.conn.close();
            this.prepCache.clear();
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
        this.db.sessionClosed(this);
        sessionManager.closeSpy(this);
    }

    public String getTableName(OrionType orionType) {
        return this.db.getTableName(orionType);
    }

    public void invokeDdl(DdlCommand ddlCommand) {
        this.ddlHelper.invokeDdl(ddlCommand.getDdl(this.getRdbmsContext()));
    }

    public void insert(BIOrionObject bIOrionObject) {
        this.insertHelper.insert(bIOrionObject);
    }

    public int insert(String string) {
        return this.insertHelper.updateOrDelete("INSERT", string);
    }

    public int insert(String string, BSimple[] bSimpleArray) {
        return this.insertHelper.updateOrDelete("INSERT", string, bSimpleArray);
    }

    public void mappedInsert(BObject bObject) {
        this.insertHelper.insert(this.mapHelper.mapForInsert(bObject));
    }

    public int update(BSqlUpdate bSqlUpdate) {
        return this.updateHelper.update(bSqlUpdate);
    }

    public int update(String string) {
        return this.updateHelper.updateOrDelete("UPDATE", string);
    }

    public int update(String string, BSimple[] bSimpleArray) {
        return this.updateHelper.updateOrDelete("UPDATE", string, bSimpleArray);
    }

    public void update(BIOrionObject bIOrionObject) {
        this.updateHelper.update(bIOrionObject, false);
    }

    public void update(BIOrionObject bIOrionObject, boolean bl) {
        this.updateHelper.update(bIOrionObject, bl);
    }

    public void mappedUpdate(BObject bObject) {
        this.updateHelper.update(this.mapHelper.mapForUpdate(bObject));
    }

    public void persist(BIOrionObject bIOrionObject) {
        if (this.exists(bIOrionObject)) {
            this.update(bIOrionObject, true);
        } else {
            this.insert(bIOrionObject);
        }
    }

    public int delete(OrionType orionType, BExpression bExpression) {
        return this.deleteHelper.delete(orionType, bExpression);
    }

    public int delete(String string) {
        return this.deleteHelper.updateOrDelete("DELETE", string);
    }

    public int delete(String string, BSimple[] bSimpleArray) {
        return this.deleteHelper.updateOrDelete("DELETE", string, bSimpleArray);
    }

    public boolean mappedDelete(BObject bObject) {
        return this.deleteHelper.delete(this.mapHelper.mapForDelete(bObject));
    }

    public boolean delete(BIOrionObject bIOrionObject) {
        return this.deleteHelper.delete(bIOrionObject);
    }

    public OrionCursor select(BQuery bQuery) {
        return this.selectHelper.select(bQuery);
    }

    public OrionCursor select(OrionType orionType, String string) {
        return this.selectHelper.select(orionType, string, null);
    }

    public OrionCursor select(OrionType orionType, String string, BSimple[] bSimpleArray) {
        return this.selectHelper.select(orionType, string, bSimpleArray);
    }

    public OrionCursor select(OrionType orionType, PropertyValue propertyValue) {
        return this.selectHelper.select(orionType, propertyValue);
    }

    public OrionCursor select(OrionType orionType, PropertyValue[] propertyValueArray) {
        return this.selectHelper.select(orionType, propertyValueArray);
    }

    public BIOrionObject mappedRead(BObject bObject) {
        BIOrionObject bIOrionObject = this.mapHelper.mapForRead(bObject);
        if (this.readHelper.read(bIOrionObject) == null) {
            return null;
        }
        return bIOrionObject;
    }

    public boolean exists(BIOrionObject bIOrionObject) {
        return this.readHelper.exists(bIOrionObject.getOrionType(), PropertyValue.makeKeys(bIOrionObject));
    }

    public boolean exists(OrionType orionType, PropertyValue[] propertyValueArray) {
        return this.readHelper.exists(orionType, propertyValueArray);
    }

    public BIOrionObject read(BQuery bQuery) {
        return this.readHelper.read(bQuery);
    }

    public BIOrionObject read(BIOrionObject bIOrionObject) {
        return this.readHelper.read(bIOrionObject);
    }

    public BIOrionObject read(OrionType orionType, BSimple bSimple) {
        return this.readHelper.read(orionType, bSimple);
    }

    public BIOrionObject read(OrionType orionType, PropertyValue propertyValue) {
        return this.readHelper.read(orionType, propertyValue);
    }

    public BIOrionObject read(OrionType orionType, PropertyValue[] propertyValueArray) {
        return this.readHelper.read(orionType, propertyValueArray);
    }

    public BIOrionObject read(OrionType orionType, String string) {
        return this.readHelper.read(orionType, string, null);
    }

    public BIOrionObject read(OrionType orionType, String string, BSimple[] bSimpleArray) {
        return this.readHelper.read(orionType, string, bSimpleArray);
    }

    public OrionCursor scan(OrionType orionType) {
        return this.scanHelper.scan(orionType);
    }

    public OrionCursor linkedScan(BIOrionObject bIOrionObject, OrionType orionType, OrionType orionType2) {
        return this.linkedHelper.linkedScan(bIOrionObject, orionType, orionType2);
    }

    public BOrionDatabase getDb() {
        return this.db;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Context getBase() {
        return this.context;
    }

    public String getLanguage() {
        if (this.context != null) {
            return this.context.getLanguage();
        }
        return Sys.getLanguage();
    }

    public BFacets getFacets() {
        if (this.context != null) {
            return this.context.getFacets();
        }
        return BFacets.DEFAULT;
    }

    public BObject getFacet(String string) {
        if (this.context != null) {
            return this.context.getFacet(string);
        }
        return null;
    }

    public BUser getUser() {
        if (this.context != null) {
            return this.context.getUser();
        }
        return null;
    }

    public RdbmsPreparedStatement makeStatement(BOrionDatabase bOrionDatabase, Connection connection, String string) throws SQLException {
        RdbmsPreparedStatement rdbmsPreparedStatement = (RdbmsPreparedStatement)this.prepCache.get(string);
        if (rdbmsPreparedStatement == null) {
            rdbmsPreparedStatement = new RdbmsPreparedStatement(connection, string);
            this.prepCache.put(string, rdbmsPreparedStatement);
            if (LOG.isTraceOn()) {
                LOG.trace("cached " + string);
            }
        }
        return rdbmsPreparedStatement;
    }

    public RdbmsPreparedStatement makeAutoKeyStatement(BOrionDatabase bOrionDatabase, Connection connection, String string, int n) throws SQLException {
        String string2 = "AUTOKEY(" + n + "):" + string;
        RdbmsPreparedStatement rdbmsPreparedStatement = (RdbmsPreparedStatement)this.prepCache.get(string2);
        if (rdbmsPreparedStatement == null) {
            rdbmsPreparedStatement = new RdbmsPreparedStatement(connection, string, n);
            this.prepCache.put(string2, rdbmsPreparedStatement);
            if (LOG.isTraceOn()) {
                LOG.trace("cached autokey " + n + ", " + string);
            }
        }
        return rdbmsPreparedStatement;
    }

    public BatchStatement batchInsert(OrionType orionType) {
        return new DbBatchInsert(this, orionType);
    }

    public BatchStatement batchUpdate(OrionType orionType) {
        return new DbBatchUpdate(this, orionType);
    }

    public BatchStatement batchPersist(OrionType orionType) {
        return new DbBatchPersist(this, orionType);
    }

    public BatchStatement batchDelete(OrionType orionType) {
        return new DbBatchDelete(this, orionType);
    }

    public Connection getUnderylingConnection() {
        return this.conn;
    }

    static /* synthetic */ int access$0() {
        return 50;
    }

    private final /* synthetic */ void this() {
        this.prepCache = new LinkedHashMap(){

            protected final boolean removeEldestEntry(Map.Entry entry) {
                boolean bl = false;
                if (this.size() > 50) {
                    bl = true;
                }
                return bl;
            }
        };
    }

    public DbOrionSession(BLocalOrionDatabase bLocalOrionDatabase, Context context) {
        this.this();
        this.db = bLocalOrionDatabase;
        this.context = context;
        try {
            this.conn = bLocalOrionDatabase.getRdbms().getConnection();
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
        this.ddlHelper = new Ddl(this);
        this.deleteHelper = new Delete(this);
        this.insertHelper = new Insert(this);
        this.linkedHelper = new LinkedScan(this);
        this.mapHelper = new MapHelper();
        this.readHelper = new Read(this);
        this.scanHelper = new Scan(this);
        this.selectHelper = new Select(this);
        this.updateHelper = new Update(this);
        sessionManager.openSpy(this);
    }
}

