/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbBatch;
import com.tridium.orion.priv.db.DbBatchInsert;
import com.tridium.orion.priv.db.DbBatchUpdate;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Fetch;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbBatchPersist
extends DbBatch {
    private final Fetch fetch;
    private final DbBatchUpdate batchUpdate;
    private final DbBatchInsert batchInsert;

    public void execute() {
        if (this.arr.size() == 0) {
            return;
        }
        TableDefinition tableDefinition = TableDefinition.get(this.db, this.type);
        try {
            BIOrionObject bIOrionObject = (BIOrionObject)this.arr.get(0);
            PropertyValue[] propertyValueArray = PropertyValue.makeKeys(bIOrionObject);
            RdbmsPreparedStatement rdbmsPreparedStatement = this.session.makeStatement(this.db, this.conn, this.fetch.buildPreparedSelect(tableDefinition, propertyValueArray));
            int n = 0;
            while (n < this.arr.size()) {
                bIOrionObject = (BIOrionObject)this.arr.get(n);
                propertyValueArray = PropertyValue.makeKeys(bIOrionObject);
                this.fetch.loadPreparedSelect(tableDefinition, propertyValueArray, rdbmsPreparedStatement);
                ResultSet resultSet = rdbmsPreparedStatement.executeQuery();
                boolean bl = resultSet.next();
                if (bl) {
                    this.batchUpdate.add(bIOrionObject);
                } else {
                    this.batchInsert.add(bIOrionObject);
                }
                ++n;
            }
            this.batchUpdate.execute();
            this.batchInsert.execute();
        }
        catch (SQLException sQLException) {
            throw new OrionException(sQLException);
        }
    }

    public DbBatchPersist(DbOrionSession dbOrionSession, OrionType orionType) {
        super(dbOrionSession, orionType);
        this.fetch = new Fetch(dbOrionSession);
        this.batchUpdate = new DbBatchUpdate(dbOrionSession, orionType);
        this.batchInsert = new DbBatchInsert(dbOrionSession, orionType);
    }
}

