/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.rdb.jdbc.RdbmsDialect;
import java.sql.Connection;
import javax.baja.log.Log;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DbBatch
implements BatchStatement {
    protected final Log log;
    protected final DbOrionSession session;
    protected final BLocalOrionDatabase db;
    protected final RdbmsDialect dialect;
    protected final Connection conn;
    protected final OrionType type;
    protected final Array arr;
    protected final TableDefinition tableDef;
    protected int chunkSize;

    public void add(BIOrionObject bIOrionObject) {
        if (!bIOrionObject.getOrionType().equals(this.type)) {
            throw new OrionException("Type mismatch: object type (" + bIOrionObject.getOrionType() + ")  is not the same as the batch type (" + this.type + ").");
        }
        this.arr.add((Object)bIOrionObject);
    }

    public BIOrionObject get(int n) {
        return (BIOrionObject)this.arr.get(n);
    }

    public int size() {
        return this.arr.size();
    }

    public void clear() {
        this.arr.clear();
    }

    public OrionType getOrionType() {
        return this.type;
    }

    public void setChunkSize(int n) {
        if (n < 0) {
            throw new OrionException("Invalid chunkSize of '" + n + "'.  The chunkSize must be >= 0.");
        }
        this.chunkSize = n;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    private final /* synthetic */ void this() {
        this.log = Log.getLog((String)"orion.jdbc");
    }

    public DbBatch(DbOrionSession dbOrionSession, OrionType orionType) {
        this.this();
        this.session = dbOrionSession;
        this.db = (BLocalOrionDatabase)dbOrionSession.getOrionDatabase();
        this.dialect = (RdbmsDialect)this.db.getRdbms().getRdbmsContext();
        this.conn = dbOrionSession.getConnection();
        this.type = orionType;
        this.arr = new Array(orionType.getTypeClass());
        this.tableDef = TableDefinition.get(this.db, orionType);
    }
}

