/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.audit;

import com.tridium.orion.BAuditMode;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.audit.BOrionAudit;
import com.tridium.orion.priv.audit.BOrionAuditType;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOrionAuditWorker
extends BThreadPoolWorker {
    public static final Property maxThreads = BOrionAuditWorker.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property maxQueueSize = BOrionAuditWorker.newProperty((int)0, (int)50000, (BFacets)BFacets.makeInt(null, (int)5000, (int)Integer.MAX_VALUE));
    public static final Type TYPE;
    HashMap sessions;
    Queue queue;
    ThreadPoolWorker worker;
    static /* synthetic */ Class class$com$tridium$orion$priv$audit$BOrionAuditWorker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int n) {
        this.setInt(maxQueueSize, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static void auditCreated(BIOrionObject bIOrionObject, OrionSession orionSession) {
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode bAuditMode = bOrionService.getAuditMode();
        if (!bAuditMode.equals((Object)BAuditMode.none)) {
            bOrionService.getAuditWorker().postAsync(bIOrionObject, BOrionAuditType.created, orionSession.getUser().getUsername(), orionSession.getOrionDatabase());
        }
    }

    public static void auditDeleted(BIOrionObject bIOrionObject, OrionSession orionSession) {
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode bAuditMode = bOrionService.getAuditMode();
        if (!bAuditMode.equals((Object)BAuditMode.none)) {
            bOrionService.getAuditWorker().postAsync(bIOrionObject, BOrionAuditType.deleted, orionSession.getUser().getUsername(), orionSession.getOrionDatabase());
        }
    }

    public static void auditModified(BIOrionObject bIOrionObject, Property property, OrionSession orionSession) {
        BOrionService bOrionService = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BAuditMode bAuditMode = bOrionService.getAuditMode();
        if (!bAuditMode.equals((Object)BAuditMode.none)) {
            bOrionService.getAuditWorker().postAsync(bIOrionObject, property, BOrionAuditType.modified, orionSession.getUser().getUsername(), orionSession.getOrionDatabase());
        }
    }

    public IFuture postAsync(BIOrionObject bIOrionObject, BOrionAuditType bOrionAuditType, String string, BOrionDatabase bOrionDatabase) {
        return this.postAsync(bIOrionObject, null, bOrionAuditType, string, bOrionDatabase);
    }

    public IFuture postAsync(BIOrionObject bIOrionObject, Property property, BOrionAuditType bOrionAuditType, String string, BOrionDatabase bOrionDatabase) {
        OrionAuditEvent orionAuditEvent = new OrionAuditEvent(bIOrionObject, property, bOrionAuditType, string, bOrionDatabase);
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        while (true) {
            try {
                this.queue.enqueue((Object)orionAuditEvent);
                return null;
            }
            catch (QueueFullException queueFullException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    throw new QueueFullException("Unable to Sleep");
                }
            }
        }
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new Queue(this.getMaxQueueSize());
            this.worker = new AuditThreadPoolWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    protected String getWorkerThreadName() {
        return "BOrionAuditWorker:" + this.getParent().getName();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals((Object)maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }

    public OrionSession getAuditSession(BOrionDatabase bOrionDatabase) {
        OrionSession orionSession = (OrionSession)this.sessions.get(bOrionDatabase);
        if (orionSession == null) {
            orionSession = bOrionDatabase.createSession(null);
            this.sessions.put(bOrionDatabase, orionSession);
        }
        return orionSession;
    }

    public void cleanupSessions() {
        Object[] objectArray = this.sessions.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            OrionSession orionSession = (OrionSession)objectArray[n];
            orionSession.close();
            orionSession = null;
            ++n;
        }
        this.sessions.clear();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sessions = new HashMap();
    }

    public BOrionAuditWorker() {
        this.this();
    }

    public BOrionAuditWorker(int n) {
        super(n);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$orion$priv$audit$BOrionAuditWorker;
        if (clazz == null) {
            clazz = class$com$tridium$orion$priv$audit$BOrionAuditWorker = BOrionAuditWorker.class("[Lcom.tridium.orion.priv.audit.BOrionAuditWorker;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class OrionAuditEvent
    implements Runnable {
        BIOrionObject obj;
        BOrionDatabase db;
        BOrionAuditType auditType;
        String username;
        Property property;

        public void run() {
            OrionSession orionSession = BOrionAuditWorker.this.getAuditSession(this.db);
            BOrionService bOrionService = (BOrionService)BOrionAuditWorker.this.getParent();
            if (this.auditType.equals((Object)BOrionAuditType.created)) {
                BOrionAudit.auditCreated(this.obj, this.username, bOrionService.getAuditMode(), orionSession);
            } else if (this.auditType.equals((Object)BOrionAuditType.deleted)) {
                BOrionAudit.auditDeleted(this.obj, this.username, bOrionService.getAuditMode(), orionSession);
            } else if (this.auditType.equals((Object)BOrionAuditType.modified)) {
                BOrionAudit.auditModified(this.obj, this.property, this.username, bOrionService.getAuditMode(), orionSession);
            }
        }

        public OrionAuditEvent(BIOrionObject bIOrionObject, Property property, BOrionAuditType bOrionAuditType, String string, BOrionDatabase bOrionDatabase) {
            this.obj = bIOrionObject;
            this.auditType = bOrionAuditType;
            this.username = string;
            this.property = property;
            this.db = bOrionDatabase;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class AuditThreadPoolWorker
    extends ThreadPoolWorker {
        protected void threadStarted() {
            Thread.currentThread().setPriority(1);
        }

        protected void threadStopped() {
            BOrionAuditWorker.this.cleanupSessions();
        }

        public AuditThreadPoolWorker(Worker.ITodo iTodo) {
            super(iTodo);
        }
    }
}

