/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.virtual;

import com.tridium.example.virtual.PersistentVirtualCacheCallbacks;
import java.io.File;
import javax.baja.io.BogDecoder;
import javax.baja.io.BogEncoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualCacheCallbacks;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPersistentVirtualGateway
extends BVirtualGateway {
    public static final Property bogFileName = BPersistentVirtualGateway.newProperty((int)64, (String)"", null);
    public static final Action save = BPersistentVirtualGateway.newAction((int)0, null);
    public static final Type TYPE;
    static final Log log;
    File virtualDir;
    boolean loaded;
    boolean inSave;
    private Object saveLock;
    static /* synthetic */ Class class$com$tridium$example$virtual$BPersistentVirtualGateway;
    static /* synthetic */ Class class$javax$baja$sys$BObject;

    public String getBogFileName() {
        return this.getString(bogFileName);
    }

    public void setBogFileName(String string) {
        this.setString(bogFileName, string, null);
    }

    public void save() {
        this.invoke(save, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public File getBogFile() {
        Object object;
        if (this.virtualDir == null) {
            object = Sys.getStationHome();
            this.virtualDir = new File((File)object, "virtual");
            if (!this.virtualDir.exists()) {
                this.virtualDir.mkdirs();
            }
        }
        if ((object = this.getBogFileName()) == null || ((String)object).length() < 1) {
            object = this.getDefaultBogFileName();
            this.setBogFileName((String)object);
        }
        return new File(this.virtualDir, (String)object);
    }

    protected String getDefaultBogFileName() {
        return "h" + this.getHandle() + "_virtual.bog";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(Context context) throws Exception {
        if (this.inSave || !this.loaded) {
            return;
        }
        Object object = this.saveLock;
        synchronized (object) {
            this.inSave = true;
            try {
                try {
                    File file = this.getBogFile();
                    File file2 = new File(file + ".working");
                    long l = Clock.ticks();
                    BogEncoder bogEncoder = new BogEncoder(file2);
                    bogEncoder.setZipped(true);
                    bogEncoder.encodeDocument((BValue)this.getVirtualSpace().getRootComponent());
                    bogEncoder.close();
                    if (file.exists()) {
                        file.delete();
                    }
                    file2.renameTo(file);
                    long l2 = Clock.ticks();
                    long l3 = l2 - l;
                    log.message("Saved " + file + " (" + l3 + "ms)");
                }
                catch (Exception exception) {
                    log.error("Save failed", (Throwable)exception);
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                this.inSave = false;
                throw throwable;
            }
            {
                Object var5_12 = null;
                this.inSave = false;
            }
            return;
        }
    }

    public void loadFromBog() {
        if (this.loaded) {
            return;
        }
        try {
            long l = Clock.ticks();
            File file = this.getBogFile();
            if (!file.exists()) {
                this.loaded = true;
                return;
            }
            log.message("Loading \"" + file + "\"...");
            BogDecoder bogDecoder = new BogDecoder(file);
            BValue bValue = bogDecoder.decodeDocument();
            if (!(bValue instanceof BVirtualComponent)) {
                throw new Exception("\"" + file + "\" contains " + bValue.getType() + ", not baja:VirtualComponent");
            }
            BVirtualComponent bVirtualComponent = (BVirtualComponent)bValue;
            if (bogDecoder.getWarningCount() > 0) {
                System.out.println("###########################################################################");
                System.out.println("#");
                System.out.println("# WARNING: \"" + file + "\" contains " + bogDecoder.getWarningCount() + " warnings");
                System.out.println("#");
                System.out.println("###########################################################################");
            }
            BVirtualComponentSpace bVirtualComponentSpace = (BVirtualComponentSpace)this.getVirtualSpace();
            Class clazz = class$javax$baja$sys$BObject;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BObject = BPersistentVirtualGateway.class("[Ljavax.baja.sys.BObject;", false);
            }
            new Mark((BObject[])bVirtualComponent.getChildren(clazz)).moveTo((BObject)bVirtualComponentSpace.getRootComponent(), null);
            this.loaded = true;
            long l2 = Clock.ticks();
            log.message("Loaded (" + (l2 - l) + "ms)");
            SlotCursor slotCursor = bVirtualComponent.getProperties();
            while (slotCursor.nextComponent()) {
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BINavNode)bVirtualComponent, (String)slotCursor.get().asComponent().getName(), null));
            }
        }
        catch (Exception exception) {
            log.error("Cannot load persistent virtual root", (Throwable)exception);
        }
    }

    protected BVirtualComponentSpace makeVirtualSpace() {
        BVirtualComponentSpace bVirtualComponentSpace = new BVirtualComponentSpace("virtual", LexiconText.make((String)"baja", (String)"nav.virtual"), BOrd.make((String)"virtual:"), this){

            public final boolean isSpaceReadonly() {
                return false;
            }
        };
        bVirtualComponentSpace.setVirtualCacheCallbacks((VirtualCacheCallbacks)new PersistentVirtualCacheCallbacks(bVirtualComponentSpace));
        BVirtualComponent bVirtualComponent = this.makeVirtualRoot();
        if (bVirtualComponent == null) {
            throw new IllegalStateException("makeVirtualRoot() returned null.  Must return a valid root component for the virtual space.");
        }
        bVirtualComponentSpace.setRootComponent((BComponent)bVirtualComponent);
        return bVirtualComponentSpace;
    }

    public void loadVirtualSlots(BVirtualComponent bVirtualComponent) {
        if (bVirtualComponent == this.getVirtualSpace().getRootComponent()) {
            this.loadFromBog();
        }
    }

    protected Property addVirtualSlot(BVirtualComponent bVirtualComponent, String string) {
        if (bVirtualComponent == this.getVirtualSpace().getRootComponent() && !this.loaded) {
            this.loadFromBog();
            return this.getVirtualSpace().getRootComponent().getProperty(SlotPath.escape((String)string));
        }
        return null;
    }

    public void started() throws Exception {
        super.started();
        String string = this.getBogFileName();
        if (string == null || string.length() < 1) {
            this.setBogFileName(this.getDefaultBogFileName());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.virtualDir = null;
        this.loaded = false;
        this.inSave = false;
        this.saveLock = new Object();
    }

    public BPersistentVirtualGateway() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$example$virtual$BPersistentVirtualGateway;
        if (clazz == null) {
            clazz = class$com$tridium$example$virtual$BPersistentVirtualGateway = BPersistentVirtualGateway.class("[Lcom.tridium.example.virtual.BPersistentVirtualGateway;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"example.virtual.persistent");
    }
}

