/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.points;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.example.modbus.BModbusExampleDevice;
import com.tridium.example.modbus.BModbusExampleNetwork;
import com.tridium.example.modbus.messages.ModbusMessageConst;
import com.tridium.example.modbus.messages.ReadCoilMessage;
import com.tridium.example.modbus.messages.ReadCoilResponse;
import com.tridium.example.modbus.messages.ReadHoldingRegisterMessage;
import com.tridium.example.modbus.messages.ReadHoldingRegisterResponse;
import com.tridium.example.modbus.messages.WriteCoilMessage;
import com.tridium.example.modbus.messages.WriteCoilResponse;
import com.tridium.example.modbus.messages.WriteHoldingRegisterMessage;
import com.tridium.example.modbus.messages.WriteHoldingRegisterResponse;
import com.tridium.example.modbus.points.BModbusExamplePointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusExampleProxyExt
extends BBasicProxyExt
implements BIBasicPollable,
ModbusMessageConst {
    static Lexicon lexicon = Lexicon.make((String)"docCodeExamples");
    public static final Property pollFrequency = BModbusExampleProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property dataAddress = BModbusExampleProxyExt.newProperty((int)0, (int)0, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$example$modbus$points$BModbusExampleProxyExt;

    static final String modbusErrorToString(int n) {
        switch (n) {
            case 0: {
                return lexicon.getText("modbusError.ok");
            }
            case 1: {
                return lexicon.getText("modbusError.illegalFunction");
            }
            case 2: {
                return lexicon.getText("modbusError.illegalAddress");
            }
            case 3: {
                return lexicon.getText("modbusError.illegalValue");
            }
            case 4: {
                return lexicon.getText("modbusError.slaveFailure");
            }
            case 5: {
                return lexicon.getText("modbusError.acknowledge");
            }
            case 6: {
                return lexicon.getText("modbusError.slaveBusy");
            }
            case 7: {
                return lexicon.getText("modbusError.negativeAck");
            }
            case 8: {
                return lexicon.getText("modbusError.memoryParityError");
            }
            case 9: {
                return lexicon.getText("modbusError.timeout");
            }
            case -2: {
                return lexicon.getText("modbusError.okNotActive");
            }
            case -4: {
                return lexicon.getText("modbusError.invalidResponse");
            }
            case -5: {
                return lexicon.getText("modbusError.lrcError");
            }
        }
        return lexicon.getText("modbusError.unknown");
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getDataAddress() {
        return this.getInt(dataAddress);
    }

    public void setDataAddress(int n) {
        this.setInt(dataAddress, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BModbusExamplePointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == dataAddress) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    public void poll() {
        BModbusExampleNetwork bModbusExampleNetwork = this.network();
        if (bModbusExampleNetwork.getLog().isTraceOn()) {
            bModbusExampleNetwork.getLog().trace(this + ".poll()");
        }
        this.read();
    }

    private final void read() {
        BModbusExampleNetwork bModbusExampleNetwork = this.network();
        BModbusExampleDevice bModbusExampleDevice = this.device();
        int n = bModbusExampleDevice.getAddress();
        int n2 = this.getDataAddress();
        boolean bl = true;
        if (!this.isBoolean()) {
            ReadHoldingRegisterMessage readHoldingRegisterMessage = new ReadHoldingRegisterMessage(n, n2, 1);
            ReadHoldingRegisterResponse readHoldingRegisterResponse = (ReadHoldingRegisterResponse)bModbusExampleNetwork.sendSync(readHoldingRegisterMessage);
            if (readHoldingRegisterResponse == null) {
                readHoldingRegisterResponse = new ReadHoldingRegisterResponse(readHoldingRegisterMessage);
                readHoldingRegisterResponse.setExceptionCode(9);
            }
            if (!readHoldingRegisterResponse.isError()) {
                this.readOk((BStatusValue)new BStatusNumeric((double)readHoldingRegisterResponse.getFloatValue()));
            } else {
                this.readFail(BModbusExampleProxyExt.modbusErrorToString(readHoldingRegisterResponse.getExceptionCode()));
            }
        } else {
            ReadCoilMessage readCoilMessage = new ReadCoilMessage(n, n2, 1);
            ReadCoilResponse readCoilResponse = (ReadCoilResponse)bModbusExampleNetwork.sendSync(readCoilMessage);
            if (readCoilResponse == null) {
                readCoilResponse = new ReadCoilResponse(readCoilMessage);
                readCoilResponse.setExceptionCode(9);
            }
            if (!readCoilResponse.isError()) {
                this.readOk((BStatusValue)new BStatusBoolean(readCoilResponse.getBooleanValue()));
            } else {
                this.readFail(BModbusExampleProxyExt.modbusErrorToString(readCoilResponse.getExceptionCode()));
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        BModbusExampleNetwork bModbusExampleNetwork = this.network();
        BModbusExampleDevice bModbusExampleDevice = this.device();
        int n = bModbusExampleDevice.getAddress();
        int n2 = this.getDataAddress();
        if (!this.isBoolean()) {
            int n3 = (int)((BStatusNumeric)bStatusValue).getValue();
            WriteHoldingRegisterMessage writeHoldingRegisterMessage = new WriteHoldingRegisterMessage(n, n2, n3);
            WriteHoldingRegisterResponse writeHoldingRegisterResponse = (WriteHoldingRegisterResponse)bModbusExampleNetwork.sendSync(writeHoldingRegisterMessage);
            if (writeHoldingRegisterResponse == null) {
                writeHoldingRegisterResponse = new WriteHoldingRegisterResponse(writeHoldingRegisterMessage);
                writeHoldingRegisterResponse.setExceptionCode(9);
            }
            if (writeHoldingRegisterResponse.isError() && writeHoldingRegisterResponse.getExceptionCode() != 5) {
                this.writeFail(BModbusExampleProxyExt.modbusErrorToString(writeHoldingRegisterResponse.getExceptionCode()));
            } else {
                this.writeOk(bStatusValue);
                this.read();
            }
        } else {
            boolean bl = ((BStatusBoolean)bStatusValue).getValue();
            WriteCoilMessage writeCoilMessage = new WriteCoilMessage(n, n2, bl);
            WriteCoilResponse writeCoilResponse = (WriteCoilResponse)bModbusExampleNetwork.sendSync(writeCoilMessage);
            if (writeCoilResponse == null) {
                writeCoilResponse = new WriteCoilResponse(writeCoilMessage);
                writeCoilResponse.setExceptionCode(9);
            }
            if (writeCoilResponse.isError() && writeCoilResponse.getExceptionCode() != 5) {
                this.writeFail(BModbusExampleProxyExt.modbusErrorToString(writeCoilResponse.getExceptionCode()));
            } else {
                this.writeOk(bStatusValue);
                this.read();
            }
        }
    }

    public String toString(Context context) {
        BModbusExampleDevice bModbusExampleDevice = this.device();
        if (bModbusExampleDevice != null) {
            if (!this.isBoolean()) {
                return "Device: " + bModbusExampleDevice.getAddress() + ", Holding Register: " + this.getDataAddress();
            }
            return "Device: " + bModbusExampleDevice.getAddress() + ", Coil: " + this.getDataAddress();
        }
        return "Modbus Ascii Ext";
    }

    private final BModbusExampleDevice device() {
        return (BModbusExampleDevice)this.getDevice();
    }

    private final BModbusExampleNetwork network() {
        return (BModbusExampleNetwork)this.getDevice().getNetwork();
    }

    private final boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$example$modbus$points$BModbusExampleProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$example$modbus$points$BModbusExampleProxyExt = BModbusExampleProxyExt.class("[Lcom.tridium.example.modbus.points.BModbusExampleProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

