/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.example.modbus.messages.ModbusInputStream;
import com.tridium.example.modbus.messages.ModbusMessage;
import com.tridium.example.modbus.messages.ModbusResponse;
import com.tridium.example.modbus.messages.ReadHoldingRegisterMessage;

public class ReadHoldingRegisterResponse
extends ModbusResponse {
    private byte[] data;
    private ReadHoldingRegisterMessage request;

    public void readResponse(byte[] byArray, int n) {
        ModbusInputStream modbusInputStream = new ModbusInputStream(byArray);
        if (modbusInputStream.read() != 58) {
            this.exceptionCode = -4;
            return;
        }
        int n2 = n;
        if (n2 <= 4) {
            this.exceptionCode = -4;
            return;
        }
        byte[] byArray2 = new byte[n2 - 4];
        System.arraycopy(byArray, 0, byArray2, 0, n2 - 4);
        int n3 = ModbusMessage.calcLRC(ModbusInputStream.convertAscii2Rtu(byArray2));
        byte[] byArray3 = new byte[]{byArray[n2 - 4], byArray[n2 - 3]};
        ModbusInputStream modbusInputStream2 = new ModbusInputStream(byArray3);
        int n4 = modbusInputStream2.readHexByte();
        if (n3 != n4) {
            this.exceptionCode = -5;
            return;
        }
        this.deviceAddress = (byte)(modbusInputStream.readHexByte() & 0xFF);
        this.functionCode = (byte)(modbusInputStream.readHexByte() & 0xFF);
        if ((this.functionCode & 0x80) != 0) {
            this.exceptionCode = modbusInputStream.readHexByte();
            return;
        }
        if (this.request.functionCode != this.functionCode) {
            this.exceptionCode = -4;
            return;
        }
        this.exceptionCode = 0;
        int n5 = modbusInputStream.readHexByte() & 0xFF;
        this.data = new byte[n5];
        int n6 = 0;
        while (n6 < n5) {
            this.data[n6] = (byte)(modbusInputStream.readHexByte() & 0xFF);
            ++n6;
        }
    }

    public float getFloatValue() {
        int n = this.data[1] & 0xFF | (this.data[0] & 0xFF) << 8;
        if (n >= 32768) {
            n |= 0xFFFF0000;
        }
        return n;
    }

    public ReadHoldingRegisterResponse(ReadHoldingRegisterMessage readHoldingRegisterMessage) {
        this.request = readHoldingRegisterMessage;
    }
}

