/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.example.modbus.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.example.modbus.messages.ModbusMessageConst;
import javax.baja.util.TextUtil;

public abstract class ModbusMessage
extends Message
implements ModbusMessageConst {
    protected int deviceAddress;
    protected int functionCode;

    public static int calcLRC(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        n &= 0xFF;
        n = 255 - n & 0xFF;
        ++n;
        return n &= 0xFF;
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ModbusMessage = " + TextUtil.getClassName(this.getClass()));
        stringBuffer.append("\n  Tag = " + this.getTag());
        stringBuffer.append("\n  Modbus Device Address = " + this.deviceAddress);
        stringBuffer.append("\n  Modbus Function Code = " + this.functionCode);
        return stringBuffer.toString();
    }

    public ModbusMessage() {
    }

    public ModbusMessage(int n, int n2) {
        this.deviceAddress = n;
        this.functionCode = n2;
        this.setTag(new TagObject(n, n2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TagObject {
        private int address;
        private int functionCode;

        public boolean equals(Object object) {
            boolean bl = false;
            if (this.address == ((TagObject)object).address && this.functionCode == ((TagObject)object).functionCode) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.address * 256 + this.functionCode;
        }

        public String toString() {
            return "address = " + this.address + "; functionCode = " + this.functionCode;
        }

        private final /* synthetic */ void this() {
            this.address = 0;
            this.functionCode = 0;
        }

        public TagObject(int n, int n2) {
            this.this();
            this.address = n;
            this.functionCode = n2;
        }
    }
}

