/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.videoDriver.videoStream.fox.StationSideVideoSession;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VideoSessionsWatchdog
implements Runnable {
    public static final int THIRTY_SECONDS_WORTH_OF_TICKS = 30000;
    protected static Log watchDogLog = Log.getLog((String)"fox.stationVideoSessions.watchdog");
    protected boolean running;
    protected Hashtable videoSessionsToWatch;
    protected Thread watchdogThread;

    public void stopWatchdog() {
        this.running = false;
        if (this.watchdogThread != null) {
            this.watchdogThread.interrupt();
        }
    }

    public void startWatchdog(String string) {
        if (this.watchdogThread == null || !this.watchdogThread.isAlive()) {
            this.watchdogThread = new Thread((Runnable)this, "Fox:VideoSession:Watchdog:" + string);
            this.watchdogThread.start();
        }
    }

    public void startWatchingSession(StationSideVideoSession stationSideVideoSession) {
        if (watchDogLog.isTraceOn()) {
            stationSideVideoSession.trace(watchDogLog, "start watching");
        }
        this.videoSessionsToWatch.put(stationSideVideoSession, stationSideVideoSession);
    }

    public void stopWatchingSession(StationSideVideoSession stationSideVideoSession) {
        if (watchDogLog.isTraceOn()) {
            stationSideVideoSession.trace(watchDogLog, "stop watching");
        }
        this.videoSessionsToWatch.remove(stationSideVideoSession);
    }

    public void run() {
        if (watchDogLog.isTraceOn()) {
            watchDogLog.trace("run()");
        }
        while (this.running && Sys.getStation().isRunning()) {
            try {
                Thread.sleep(30000L);
                Enumeration enumeration = this.videoSessionsToWatch.elements();
                while (enumeration.hasMoreElements()) {
                    StationSideVideoSession stationSideVideoSession = (StationSideVideoSession)enumeration.nextElement();
                    if (!this.videoSessionsToWatch.containsKey(stationSideVideoSession)) continue;
                    stationSideVideoSession.watchdog(watchDogLog);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!watchDogLog.isTraceOn()) continue;
                watchDogLog.trace("Interrupted!", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                watchDogLog.error("Exception in VideoSessionsWatchdog.run", (Throwable)exception);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.running = true;
        this.videoSessionsToWatch = new Hashtable();
    }

    public VideoSessionsWatchdog() {
        this.this();
    }
}

