/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.fox.BFoxVideoSource;
import com.tridium.videoDriver.videoStream.fox.ClientSideVideoReceiver;
import com.tridium.videoDriver.videoStream.fox.ClientVideoInputStream;
import com.tridium.videoDriver.videoStream.fox.FoxVideoStream;
import com.tridium.videoDriver.videoStream.fox.StationSideVideoCoordinator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.sys.BComplex;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxVideoChannel
extends BFoxChannel {
    public static final Type TYPE;
    protected static Log clientLog;
    protected static Log serverLog;
    public static final String CHANNEL_NAME = "FoxVideoChannel";
    protected StationSideVideoCoordinator videoCoordinator;
    protected BInteger bWbProxyId;
    protected ClientSideVideoReceiver videoReceiver;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$fox$BFoxVideoChannel;

    public Type getType() {
        return TYPE;
    }

    public void sessionOpened() throws Exception {
        if (this.videoCoordinator == null) {
            this.videoCoordinator = new StationSideVideoCoordinator();
        }
    }

    public void sessionClosed(Throwable throwable) {
        if (this.videoCoordinator != null) {
            this.videoCoordinator.stopCoordinating();
        }
    }

    public BPlaybackParams getPlaybackParamsForStream(String string, int n) throws Exception {
        if (clientLog.isTraceOn()) {
            this.trace(clientLog, string, n, "getPlaybackParamsForStream.");
        }
        FoxResponse foxResponse = this.sendRequestFromClientToStation("getPlaybackParamsForStream", string, n, false);
        String string2 = foxResponse.getString("playbackParams", null);
        if (clientLog.isTraceOn()) {
            this.trace(clientLog, string, n, "playbackParamsXml=" + string2);
        }
        if (string2 == null) {
            return null;
        }
        return (BPlaybackParams)ValueDocDecoder.unmarshal((String)string2);
    }

    public void pauseVideoStream(String string, int n) throws Exception {
        this.sendRequestFromClientToStation("pauseVideoStream", string, n, true);
    }

    public void resumeVideoStream(String string, int n) throws Exception {
        this.sendRequestFromClientToStation("resumeVideoStream", string, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FoxResponse resumeVideoStream(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse;
        int n;
        String string;
        block5: {
            string = foxRequest.getString("videoClient", "Wb");
            try {
                n = foxRequest.getInt("videoClientId");
                string = string + ':' + n;
            }
            catch (IOException iOException) {
                if (!serverLog.isTraceOn()) break block5;
                serverLog.trace("NOTE: Resuming video stream...this video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + string);
            }
        }
        n = foxRequest.getInt("videoStreamId");
        try {
            this.videoCoordinator.resumeVideoStream(string, n);
            foxResponse = new FoxResponse(foxRequest);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var5_7 = null;
                if (!serverLog.isTraceOn()) break block6;
                this.trace(serverLog, string, n, "DONE: resumeVideoStream.");
            }
            throw throwable;
        }
        if (serverLog.isTraceOn()) {
            this.trace(serverLog, string, n, "DONE: resumeVideoStream.");
        }
        return foxResponse;
    }

    public InputStream openVideoStream(BObject bObject, String string, BPlaybackParams bPlaybackParams, int n, IVideoDestination iVideoDestination, FoxVideoStream foxVideoStream) throws Exception {
        FoxRequest foxRequest;
        block8: {
            if (clientLog.isTraceOn()) {
                this.trace(clientLog, string, n, "Open Video Stream{Video Source Ord = " + bPlaybackParams.getVideoSourceOrd() + '}');
            }
            foxRequest = this.makeRequest("openVideoStream");
            try {
                this.bWbProxyId = BInteger.make((int)BFoxVideoSource.getFoxWorkbenchRemoteSessionId(bObject));
                foxRequest.add("videoClientId", this.bWbProxyId.getInt());
            }
            catch (Exception exception) {
                if (!clientLog.isTraceOn()) break block8;
                this.trace(clientLog, string, n, "Unable to look-up videoClientId. This is ok if the video server's videoDriver.jar is created after April 1, 2009.");
            }
        }
        foxRequest.add("videoClient", string);
        foxRequest.add("videoStreamId", n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
        valueDocEncoder.encodeDocument((BValue)bPlaybackParams);
        valueDocEncoder.flush();
        valueDocEncoder.close();
        foxRequest.add("playbackParams", new String(byteArrayOutputStream.toByteArray()));
        if (this.videoReceiver == null || this.videoReceiver.isDone()) {
            if (clientLog.isTraceOn()) {
                this.trace(clientLog, string, n, "openVideoStream() start videoReceiver");
            }
            this.videoReceiver = new ClientSideVideoReceiver(this, string, this.bWbProxyId);
            this.videoReceiver.startVideoReceiver();
        }
        ClientVideoInputStream clientVideoInputStream = this.videoReceiver.getInputStream(n, iVideoDestination, foxVideoStream);
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            if (clientLog.isTraceOn()) {
                this.trace(clientLog, string, n, "openVideoStream() sent openVideoStream request ");
            }
            bPlaybackParams.copyFrom((BComplex)this.extractPlaybackParms((FoxMessage)foxResponse));
            return clientVideoInputStream;
        }
        catch (Exception exception) {
            clientVideoInputStream.close();
            throw exception;
        }
    }

    protected void closeVideoStream(String string, int n) throws Exception {
        BFoxClientConnection bFoxClientConnection;
        if (clientLog.isTraceOn()) {
            this.trace(clientLog, string, n, "Close Video Stream");
        }
        if ((bFoxClientConnection = this.getClientConnection()) == null) {
            return;
        }
        BFoxSession bFoxSession = bFoxClientConnection.getFoxSession();
        if (bFoxSession == null) {
            return;
        }
        if (bFoxSession.isConnected()) {
            FoxRequest foxRequest = this.makeRequest("closeVideoStream");
            if (this.bWbProxyId != null) {
                foxRequest.add("videoClientId", this.bWbProxyId.getInt());
                String string2 = ":" + this.bWbProxyId;
                if (string.endsWith(string2)) {
                    foxRequest.add("videoClient", string.substring(0, string.length() - string2.length()));
                } else {
                    foxRequest.add("videoClient", string);
                }
            } else {
                foxRequest.add("videoClient", string);
            }
            foxRequest.add("videoStreamId", n);
            if (clientLog.isTraceOn()) {
                this.trace(clientLog, foxRequest, "Send:closeVideoStream");
            }
            this.sendAsync(foxRequest);
        } else if (clientLog.isTraceOn()) {
            clientLog.trace("Unable to ask station to close video stream - connection lost. Video stream id = " + n + " Video client id = " + string);
        }
    }

    private final BPlaybackParams extractPlaybackParms(FoxMessage foxMessage) {
        try {
            String string = foxMessage.getString("playbackParams", "");
            if (string.length() == 0) {
                return null;
            }
            ValueDocDecoder valueDocDecoder = new ValueDocDecoder((InputStream)new ByteArrayInputStream(string.getBytes()));
            return (BPlaybackParams)valueDocDecoder.decodeDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final FoxResponse sendRequestFromClientToStation(String string, String string2, int n, boolean bl) throws Exception {
        BFoxClientConnection bFoxClientConnection = this.getClientConnection();
        if (bFoxClientConnection == null) {
            return null;
        }
        BFoxSession bFoxSession = bFoxClientConnection.getFoxSession();
        if (bFoxSession == null || bFoxSession.isConnected()) {
            FoxRequest foxRequest = this.makeRequest(string);
            if (this.bWbProxyId != null) {
                foxRequest.add("videoClientId", this.bWbProxyId.getInt());
                String string3 = ":" + this.bWbProxyId;
                if (string2.endsWith(string3)) {
                    foxRequest.add("videoClient", string2.substring(0, string2.length() - string3.length()));
                } else {
                    foxRequest.add("videoClient", string2);
                }
            } else {
                foxRequest.add("videoClient", string2);
            }
            foxRequest.add("videoStreamId", n);
            if (clientLog.isTraceOn()) {
                this.trace(clientLog, string2, n, "Send:" + string);
            }
            if (bl) {
                this.sendAsync(foxRequest);
                return null;
            }
            return this.sendSync(foxRequest);
        }
        if (clientLog.isTraceOn()) {
            this.trace(clientLog, string2, n, "Request id " + string + " - connection lost.");
        }
        return null;
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Throwable {
        if (foxCircuit.command == "FoxVideoCircuit") {
            if (serverLog.isTraceOn()) {
                serverLog.trace("circuitOpened: FoxVideoCircuit");
            }
            if (this.videoCoordinator == null) {
                this.videoCoordinator = new StationSideVideoCoordinator();
            }
            this.videoCoordinator.coordinateVideoForClient(foxCircuit);
        } else {
            super.circuitOpened(foxCircuit);
        }
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if (serverLog.isTraceOn()) {
            this.trace(serverLog, foxRequest, "receive:" + string);
        }
        if (string == "openVideoStream") {
            return this.openVideoStream(foxRequest);
        }
        if (string == "closeVideoStream") {
            this.closeVideoStream(foxRequest);
            return null;
        }
        if (string == "pauseVideoStream") {
            return this.pauseVideoStream(foxRequest);
        }
        if (string == "resumeVideoStream") {
            return this.resumeVideoStream(foxRequest);
        }
        if (string == "getPlaybackParamsForStream") {
            return this.getPlaybackParamsForStream(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FoxResponse openVideoStream(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse;
        int n;
        String string;
        block6: {
            string = foxRequest.getString("videoClient", "Wb");
            try {
                n = foxRequest.getInt("videoClientId");
                string = string + ':' + n;
            }
            catch (IOException iOException) {
                if (!serverLog.isTraceOn()) break block6;
                serverLog.trace("NOTE: This video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + string);
            }
        }
        n = foxRequest.getInt("videoStreamId");
        try {
            BPlaybackParams bPlaybackParams = this.extractPlaybackParms((FoxMessage)foxRequest);
            if (serverLog.isTraceOn()) {
                this.trace(serverLog, string, n, "Open Video Stream{Video Source Ord = " + bPlaybackParams.getVideoSourceOrd() + '}');
            }
            this.videoCoordinator.openStreamAsync(bPlaybackParams, string, n);
            FoxResponse foxResponse2 = new FoxResponse(foxRequest);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ValueDocEncoder valueDocEncoder = new ValueDocEncoder((OutputStream)byteArrayOutputStream);
            valueDocEncoder.encodeDocument((BValue)bPlaybackParams);
            valueDocEncoder.flush();
            valueDocEncoder.close();
            foxResponse2.add("playbackParams", new String(byteArrayOutputStream.toByteArray()));
            foxResponse = foxResponse2;
            Object var5_10 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_11 = null;
                if (!serverLog.isTraceOn()) break block7;
                this.trace(serverLog, string, n, "Done: openVideoStream.");
            }
            throw throwable;
        }
        if (serverLog.isTraceOn()) {
            this.trace(serverLog, string, n, "Done: openVideoStream.");
        }
        return foxResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FoxResponse pauseVideoStream(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse;
        String string = foxRequest.getString("videoClient", "Wb");
        int n = foxRequest.getInt("videoClientId", -1);
        if (n >= 0) {
            string = string + ':' + n;
        }
        int n2 = foxRequest.getInt("videoStreamId");
        try {
            this.videoCoordinator.pauseVideoStream(string, n2);
            foxResponse = new FoxResponse(foxRequest);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_7 = null;
                if (!serverLog.isTraceOn()) break block4;
                this.trace(serverLog, string, n2, "DONE: pauseVideoStream.");
            }
            throw throwable;
        }
        if (serverLog.isTraceOn()) {
            this.trace(serverLog, string, n2, "DONE: pauseVideoStream.");
        }
        return foxResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FoxResponse getPlaybackParamsForStream(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse;
        int n;
        String string;
        block6: {
            string = foxRequest.getString("videoClient", "Wb");
            try {
                n = foxRequest.getInt("videoClientId");
                string = string + ':' + n;
            }
            catch (IOException iOException) {
                if (!serverLog.isTraceOn()) break block6;
                serverLog.trace("Getting playback params for video stream...this video client does not have a unique integer in this server. This must be enterprise video support. Using unique name instead: " + string);
            }
        }
        n = foxRequest.getInt("videoStreamId");
        try {
            BPlaybackParams bPlaybackParams = this.videoCoordinator.getPlaybackParamsForStream(string, n);
            FoxResponse foxResponse2 = new FoxResponse(foxRequest);
            if (bPlaybackParams != null) {
                foxResponse2.add("playbackParams", ValueDocEncoder.marshal((BValue)bPlaybackParams));
            }
            foxResponse = foxResponse2;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_9 = null;
                if (!serverLog.isTraceOn()) break block7;
                this.trace(serverLog, string, n, "DONE: getPlaybackParamsForStream.");
            }
            throw throwable;
        }
        if (serverLog.isTraceOn()) {
            this.trace(serverLog, string, n, "DONE: getPlaybackParamsForStream.");
        }
        return foxResponse;
    }

    /*
     * Exception decompiling
     */
    private final void closeVideoStream(FoxRequest var1_1) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 127->131)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void trace(Log log, FoxRequest foxRequest, String string) {
        String string2 = "Wb";
        try {
            string2 = foxRequest.getString("videoClient");
        }
        catch (IOException iOException) {}
        int n = -1;
        try {
            n = foxRequest.getInt("videoClientId");
            string2 = string2 + ':' + n;
        }
        catch (IOException iOException) {}
        int n2 = -1;
        try {
            n2 = foxRequest.getInt("videoStreamId");
        }
        catch (IOException iOException) {}
        this.trace(log, string2, n2, string);
    }

    protected void trace(Log log, String string, int n, String string2) {
        log.trace(this.dtag(string, n) + string2);
    }

    protected void trace(Log log, String string, int n, String string2, Exception exception) {
        log.trace(this.dtag(string, n) + string2, (Throwable)exception);
    }

    private final String dtag(String string, int n) {
        return string + "{vsId:" + n + '}';
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.bWbProxyId = null;
    }

    public BFoxVideoChannel() {
        super(CHANNEL_NAME);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$videoDriver$videoStream$fox$BFoxVideoChannel;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$videoStream$fox$BFoxVideoChannel = BFoxVideoChannel.class("[Lcom.tridium.videoDriver.videoStream.fox.BFoxVideoChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        clientLog = Log.getLog((String)"fox.videoChannel.client");
        serverLog = Log.getLog((String)"fox.videoChannel.server");
    }
}

