/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.videoStream.decoder;

import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoDecoder;
import java.util.Hashtable;
import java.util.ListIterator;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class VideoMultistreamDecoder
extends VideoDecoder
implements IVideoMultistreamDecoder {
    protected Hashtable ordsToCameraGroup;
    protected BIVideoDvr videoDvr;
    protected IVideoMultistreamDecoder.MultistreamFrame mostRecentMultistreamFrame;
    protected CameraGroup[] cameraGroups;
    protected ByteBuffer rawFrameUndecoded;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$BIVideoSource;
    static /* synthetic */ Class class$com$tridium$videoDriver$videoStream$decoder$VideoMultistreamDecoder$CameraGroup;

    protected abstract CameraGroup getCameraGroupForFrameData(ByteBuffer var1, IVideoDecoder var2);

    protected abstract boolean videoSourceBelongsInGroup(CameraGroup var1, BIVideoSource var2);

    public IVideoMultistreamDecoder.MultistreamFrame nextMultistreamFrame() {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder.nextMultistreamFrame");
        }
        return this.mostRecentMultistreamFrame;
    }

    public IVideoMultistreamDecoder getMultistreamDecoder() {
        return this;
    }

    public IVideoDecoder getVideoDecoder(BOrd bOrd) {
        CameraGroup cameraGroup = (CameraGroup)this.ordsToCameraGroup.get(bOrd);
        if (cameraGroup == null) {
            int n = 0;
            while (n < this.cameraGroups.length && cameraGroup == null) {
                BOrdList bOrdList = this.cameraGroups[n].getOrdList();
                int n2 = 0;
                while (n2 < bOrdList.size() && cameraGroup == null) {
                    if (bOrdList.get(n2).equals((Object)bOrd)) {
                        cameraGroup = this.cameraGroups[n];
                        this.ordsToCameraGroup.put(bOrd, this.cameraGroups[n]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        if (cameraGroup == null) {
            return null;
        }
        return cameraGroup.videoDecoder;
    }

    public void setMultistreamDecoder(IVideoMultistreamDecoder iVideoMultistreamDecoder) {
        throw new RuntimeException("Unable to assign a multistream decoder to a multistream decoder. This was not expected to occur in the first place!");
    }

    public void init(BIVideoSource bIVideoSource, BIVideoPlayer bIVideoPlayer, BRelTime bRelTime, IVideoSession iVideoSession) {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - init");
        }
        super.init(bIVideoSource, bIVideoPlayer, bRelTime, iVideoSession);
    }

    public boolean isFinished() {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - isFinished");
        }
        try {
            if (super.isFinished()) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (n < this.cameraGroups.length) {
            if (this.cameraGroups[n].videoDecoder.isFinished()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void keepAlive() {
        try {
            super.keepAlive();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (n < this.cameraGroups.length) {
            try {
                this.cameraGroups[n].videoDecoder.keepAlive();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    protected VidFrame initVidFrame() {
        return new IVideoMultistreamDecoder.MultistreamFrame();
    }

    public void readFrameData(VidFrame vidFrame) throws Exception {
        IVideoMultistreamDecoder.MultistreamFrame multistreamFrame = (IVideoMultistreamDecoder.MultistreamFrame)vidFrame;
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder - readFrameData");
        }
        VideoDecoder videoDecoder = this.getRawFrameParser();
        videoDecoder.readFrameData(multistreamFrame);
    }

    public void decodeFrame(VidFrame vidFrame) throws Exception {
        BOrdList bOrdList;
        IVideoMultistreamDecoder.MultistreamFrame multistreamFrame = (IVideoMultistreamDecoder.MultistreamFrame)vidFrame;
        VideoDecoder videoDecoder = this.getRawFrameParser();
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder - decodeFrame");
        }
        CameraGroup cameraGroup = this.getCameraGroupForFrameData(multistreamFrame.rawData, videoDecoder);
        VideoDecoder videoDecoder2 = (VideoDecoder)cameraGroup.getVideoDecoder();
        videoDecoder2.decodeFrame(multistreamFrame);
        if (log.isTraceOn() && (bOrdList = cameraGroup.getOrdList()) != null) {
            this.trace("Decoded frame for cameras: " + bOrdList.toString());
        }
        multistreamFrame.videoCameras = cameraGroup.getOrdList();
    }

    private final VideoDecoder getRawFrameParser() {
        return (VideoDecoder)this.cameraGroups[0].videoDecoder;
    }

    public void stopDecoding(WaitForStopDecoding waitForStopDecoding) {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - stopDecoding");
        }
        int n = 0;
        while (n < this.cameraGroups.length) {
            try {
                this.cameraGroups[n].videoDecoder.stopDecoding(waitForStopDecoding);
            }
            catch (Exception exception) {}
            ++n;
        }
        try {
            super.stopDecoding(waitForStopDecoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void receiveVideoStream(IVideoStream iVideoStream) {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - receiveVideoStream");
        }
        this.videoStream = iVideoStream;
        int n = 0;
        while (n < this.cameraGroups.length) {
            try {
                IVideoDecoder iVideoDecoder = this.cameraGroups[n].getVideoDecoder();
                iVideoDecoder.init(this.videoSource, null, this.stopDecodingTimeout, this.videoSession);
                iVideoDecoder.receiveVideoStream(iVideoStream);
                iVideoDecoder.setMultistreamDecoder(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        try {
            super.receiveVideoStream(iVideoStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void videoStreamTimeout() {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - videoStreamTimeout");
        }
        int n = 0;
        while (n < this.cameraGroups.length) {
            try {
                this.cameraGroups[n].videoDecoder.videoStreamTimeout();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
        try {
            super.videoStreamTimeout();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected CameraGroup[] getCameraGroups() {
        return this.cameraGroups;
    }

    public ByteBuffer getRawMultistreamFrame() {
        return this.rawFrameUndecoded;
    }

    public static BIVideoSource[] resolveAllVideoSourceOrds(BOrdList bOrdList, BObject bObject) {
        Class clazz = class$com$tridium$videoDriver$videoStream$BIVideoSource;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$videoStream$BIVideoSource = VideoMultistreamDecoder.class("[Lcom.tridium.videoDriver.videoStream.BIVideoSource;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bOrdList.size()) {
            BOrd bOrd = bOrdList.get(n);
            try {
                array.add((Object)((BIVideoSource)bOrd.get(bObject)));
            }
            catch (Exception exception) {}
            ++n;
        }
        BIVideoSource[] bIVideoSourceArray = (BIVideoSource[])array.trim();
        return bIVideoSourceArray;
    }

    public CameraGroup[] groupCameraComponentsForSameFieldDevice(BOrdList bOrdList, BIVideoDvr bIVideoDvr) {
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - groupCameraComponentsForSameFieldDevice");
        }
        if (bIVideoDvr instanceof BObject) {
            BIVideoSource[] bIVideoSourceArray = VideoMultistreamDecoder.resolveAllVideoSourceOrds(bOrdList, (BObject)bIVideoDvr);
            Class clazz = class$com$tridium$videoDriver$videoStream$decoder$VideoMultistreamDecoder$CameraGroup;
            if (clazz == null) {
                clazz = class$com$tridium$videoDriver$videoStream$decoder$VideoMultistreamDecoder$CameraGroup = VideoMultistreamDecoder.class("[Lcom.tridium.videoDriver.videoStream.decoder.VideoMultistreamDecoder$CameraGroup;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < bIVideoSourceArray.length) {
                CameraGroup cameraGroup = null;
                ListIterator listIterator = array.iterator();
                while (listIterator.hasNext() && cameraGroup == null) {
                    CameraGroup cameraGroup2 = (CameraGroup)listIterator.next();
                    if (!this.videoSourceBelongsInGroup(cameraGroup2, bIVideoSourceArray[n])) continue;
                    cameraGroup = cameraGroup2;
                }
                if (cameraGroup == null) {
                    cameraGroup = new CameraGroup(this.videoDvr, this);
                    array.add((Object)cameraGroup);
                }
                cameraGroup.addCamera(bIVideoSourceArray[n]);
                ++n;
            }
            return (CameraGroup[])array.trim();
        }
        throw new IllegalArgumentException("The given 'dvr' must be an instance of BObject.");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ordsToCameraGroup = new Hashtable();
    }

    public VideoMultistreamDecoder(BOrdList bOrdList, BIVideoDvr bIVideoDvr) {
        this.this();
        if (log.isTraceOn()) {
            this.trace("VideoMultistreamDecoder() - constructor");
        }
        this.videoDvr = bIVideoDvr;
        this.cameraGroups = this.groupCameraComponentsForSameFieldDevice(bOrdList, bIVideoDvr);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class CameraGroup {
        public VideoMultistreamDecoder videoMultistreamDecoder;
        public IVideoDecoder videoDecoder;
        public BIVideoDvr videoDvr;
        public Array cameraOrds;
        public BOrdList cameraOrdList;

        public void addCamera(BIVideoSource bIVideoSource) {
            this.cameraOrds.add((Object)bIVideoSource.getSlotPathOrd());
        }

        public BOrdList getOrdList() {
            if (this.cameraOrdList == null) {
                this.cameraOrdList = BOrdList.make((BOrd[])((BOrd[])this.cameraOrds.trim()));
            }
            return this.cameraOrdList;
        }

        public BObject getVideoSourceObject(int n) {
            BOrd bOrd = this.getOrdList().get(n);
            if (bOrd == null || bOrd.isNull()) {
                throw new IllegalStateException("Unsupported: Sample video camera is null or NULL!");
            }
            BObject bObject = (BObject)this.videoDvr;
            BObject bObject2 = bOrd.get(bObject);
            if (log.isTraceOn()) {
                VideoMultistreamDecoder.this.trace("CameraGroup -- getVideoSourceObject - returning = " + ((BComponent)bObject2).getDisplayName(null));
            }
            return bObject2;
        }

        private final IVideoDecoder makeDecoder() {
            if (log.isTraceOn()) {
                VideoMultistreamDecoder.this.trace("CameraGroup - makeDecoder");
            }
            BIVideoSource bIVideoSource = (BIVideoSource)this.getVideoSourceObject(0);
            return bIVideoSource.makeVideoDecoder(this.videoMultistreamDecoder.videoStream.getPlaybackParams());
        }

        private final IVideoDecoder getVideoDecoder() {
            if (this.videoDecoder == null) {
                this.videoDecoder = this.makeDecoder();
            }
            return this.videoDecoder;
        }

        private final /* synthetic */ void this() {
            Class clazz = class$javax$baja$naming$BOrd;
            if (clazz == null) {
                clazz = class$javax$baja$naming$BOrd = VideoMultistreamDecoder.class("[Ljavax.baja.naming.BOrd;", false);
            }
            this.cameraOrds = new Array(clazz);
        }

        public CameraGroup(BIVideoDvr bIVideoDvr, VideoMultistreamDecoder videoMultistreamDecoder2) {
            this.this();
            this.videoDvr = bIVideoDvr;
            this.videoMultistreamDecoder = videoMultistreamDecoder2;
        }
    }
}

