/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.multistream;

import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoMultistreamPane
extends BBorderPane
implements BIVideoPlayer {
    public static final Property label = BVideoMultistreamPane.newProperty((int)4, (BValue)new BNullWidget(), null);
    public static final Property content = BVideoMultistreamPane.newProperty((int)0, (BValue)new BCanvasPane(), null);
    public static final Property videoStreamFox = BVideoMultistreamPane.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    public static final Property resolution = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    public static final Property frameRate = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    public static final Property compression = BVideoMultistreamPane.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    public static final Property streamFacets = BVideoMultistreamPane.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Topic reloadVideo = BVideoMultistreamPane.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected String message;
    protected IVideoMultistreamDecoder videoMultistreamDecoder;
    protected BPlaybackParams playBackParams;
    protected BIVideoPlayer[] videoPlayers;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$multistream$BVideoMultistreamPane;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$BIVideoPlayer;

    public BWidget getLabel() {
        return (BWidget)this.get(label);
    }

    public void setLabel(BWidget bWidget) {
        this.set(label, (BValue)bWidget, null);
    }

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget bWidget) {
        this.set(content, (BValue)bWidget, null);
    }

    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    public void setVideoStreamFox(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(videoStreamFox, (BValue)bFoxVideoStreamEnum, null);
    }

    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    public void setResolution(BVideoResolutionEnum bVideoResolutionEnum) {
        this.set(resolution, (BValue)bVideoResolutionEnum, null);
    }

    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    public void setFrameRate(BVideoFrameRateEnum bVideoFrameRateEnum) {
        this.set(frameRate, (BValue)bVideoFrameRateEnum, null);
    }

    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    public void setCompression(BVideoCompressionEnum bVideoCompressionEnum) {
        this.set(compression, (BValue)bVideoCompressionEnum, null);
    }

    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    public void setStreamFacets(BFacets bFacets) {
        this.set(streamFacets, (BValue)bFacets, null);
    }

    public void fireReloadVideo(BPlaybackParams bPlaybackParams) {
        this.fire(reloadVideo, (BValue)bPlaybackParams, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.loadVideoPlayers();
    }

    protected void loadVideoPlayers() {
        this.videoPlayers = BVideoMultistreamPane.getVideoPlayers((BWidget)this);
    }

    protected void dispatchMessage(String string) {
        BIVideoPlayer[] bIVideoPlayerArray = this.getVideoPlayers();
        int n = 0;
        while (n < bIVideoPlayerArray.length) {
            bIVideoPlayerArray[n].setMessage(string);
            ++n;
        }
    }

    private static final BOrd makeStationOrd(BOrd bOrd) {
        if (bOrd == null) {
            return null;
        }
        if (!bOrd.toString().startsWith("station:|")) {
            bOrd = BOrd.make((String)("station:|" + bOrd.toString()));
        }
        return bOrd;
    }

    private final void updateNextFrame(VidFrame vidFrame) {
        BIVideoPlayer[] bIVideoPlayerArray = this.getVideoPlayers();
        IVideoMultistreamDecoder.MultistreamFrame multistreamFrame = (IVideoMultistreamDecoder.MultistreamFrame)vidFrame;
        BOrdList bOrdList = multistreamFrame.videoCameras;
        int n = 0;
        while (n < bOrdList.size()) {
            BOrd bOrd = BVideoMultistreamPane.makeStationOrd(bOrdList.get(n));
            int n2 = 0;
            while (n2 < bIVideoPlayerArray.length) {
                BOrd bOrd2 = BVideoMultistreamPane.makeStationOrd(BVideoMultistreamBinding.getCameraOrdForVideoPlayer(bIVideoPlayerArray[n2]));
                if (bOrd2 != null && bOrd2.equals((Object)bOrd)) {
                    BDevice bDevice;
                    BObject bObject = this.videoMultistreamDecoder.getVideoSource().asObject();
                    BObject bObject2 = bOrd2.get(bObject);
                    if (bObject2 instanceof BDevice && (bDevice = (BDevice)bObject2).isFault()) {
                        if (bObject2 instanceof BIVideoCamera) {
                            bIVideoPlayerArray[n2].setMessage(VideoDriverLexicon.getLexString("VideoStreamBinding.cameraDeviceFault", ((BIVideoCamera)bObject2).getCameraDescription(), bDevice.getFaultCause()));
                        } else {
                            bIVideoPlayerArray[n2].setMessage(VideoDriverLexicon.getLexString("VideoStreamBinding.cameraDeviceFault", bDevice.getName(), bDevice.getFaultCause()));
                        }
                    } else {
                        bIVideoPlayerArray[n2].setVideoDecoder(this.videoMultistreamDecoder);
                        bIVideoPlayerArray[n2].updateVideoFrame(vidFrame);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public BIVideoPlayer[] getVideoPlayers() {
        return this.videoPlayers;
    }

    public static BVideoMultistreamPane getVideoMultistreamPane(BWidget bWidget) {
        if (bWidget == null) {
            return null;
        }
        if (bWidget instanceof BVideoMultistreamPane) {
            return (BVideoMultistreamPane)bWidget;
        }
        if (bWidget instanceof BVideoPlayer) {
            BVideoMultistreamPaneForView bVideoMultistreamPaneForView = ((BVideoPlayer)bWidget).getMultistreamPaneForView();
            if (bVideoMultistreamPaneForView != null) {
                return bVideoMultistreamPaneForView;
            }
            return BVideoMultistreamPane.getVideoMultistreamPane(bWidget.getParentWidget());
        }
        return BVideoMultistreamPane.getVideoMultistreamPane(bWidget.getParentWidget());
    }

    protected static BIVideoPlayer[] getVideoPlayers(BWidget bWidget) {
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        if (bWidgetArray == null) {
            return new BIVideoPlayer[0];
        }
        Class clazz = class$com$tridium$videoDriver$ui$BIVideoPlayer;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$BIVideoPlayer = BVideoMultistreamPane.class("[Lcom.tridium.videoDriver.ui.BIVideoPlayer;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bWidgetArray.length) {
            if (bWidgetArray[n] instanceof BIVideoPlayer) {
                array.add((Object)bWidgetArray[n]);
            } else {
                array.addAll((Object[])BVideoMultistreamPane.getVideoPlayers(bWidgetArray[n]));
            }
            ++n;
        }
        return (BIVideoPlayer[])array.trim();
    }

    public void resetImage() {
        int n = 0;
        while (n < this.videoPlayers.length) {
            this.videoPlayers[n].resetImage();
            ++n;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.dispatchMessage(string);
    }

    public void setVideoDecoder(IVideoDecoder iVideoDecoder) {
        this.videoMultistreamDecoder = iVideoDecoder.getMultistreamDecoder();
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoMultistreamDecoder;
    }

    public void updateVideoFrame(VidFrame vidFrame) {
        this.updateNextFrame(vidFrame);
    }

    public BPlaybackParams getPlaybackParams() {
        this.playBackParams.setResolution(this.getResolution());
        this.playBackParams.setFrameRate(this.getFrameRate());
        this.playBackParams.setCompression(this.getCompression());
        this.playBackParams.setVideoFacets(BFacets.make((BFacets)this.playBackParams.getVideoFacets(), (BFacets)this.getStreamFacets()));
        return this.playBackParams;
    }

    public Topic getReloadVideoTopic() {
        return reloadVideo;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.playBackParams = new BPlaybackParams();
        this.videoPlayers = new BIVideoPlayer[0];
    }

    public BVideoMultistreamPane() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$multistream$BVideoMultistreamPane;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$multistream$BVideoMultistreamPane = BVideoMultistreamPane.class("[Lcom.tridium.videoDriver.ui.multistream.BVideoMultistreamPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/icons/multistreamPane.png");
    }
}

