/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoZoomSlider
extends BWidget {
    public static final Property background = BVideoZoomSlider.newProperty((int)0, (BValue)Theme.scrollBar().getControlBackground(), null);
    public static final Property border = BVideoZoomSlider.newProperty((int)0, (BValue)BBorder.inset, null);
    public static final Property keepDownInterval = BVideoZoomSlider.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Action checkMouseStillPressed = BVideoZoomSlider.newAction((int)0, null);
    public static final Topic zoom = BVideoZoomSlider.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING_BUTTON = 1;
    public static final int SPEED_NONE = 0;
    public static final int SPEED_SLOW = 1;
    public static final int SPEED_MEDIUM = 2;
    public static final int SPEED_FAST = 3;
    public static final int DIRECTION_ZOOM_IN = 1;
    public static final int DIRECTION_ZOOM_OUT = 2;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final double BUTTON_DIAMETER_PERCENT = 0.95;
    private static final double slowPercent = 0.65;
    private static final int cap = 102;
    private static final int join = 203;
    private static final BPen solidPen;
    public static Queue movementProcessingQueue;
    public static Worker movementProcessingWorker;
    public static final BImage MAGNIFYING_GLASS_IMAGE;
    public static final BImage MAGNIFYING_GLASS_DISABLED_IMAGE;
    protected int joystickState;
    protected double mouseX;
    protected double mouseY;
    protected double boxX;
    protected double boxY;
    protected double boxW;
    protected double boxH;
    protected double buttonX;
    protected double buttonY;
    protected double buttonW;
    protected double buttonH;
    protected int speed;
    protected int direction;
    protected int orientation;
    protected BVideoZoomEnum zoomAction;
    protected PolygonGeom zoomInRegion;
    protected PolygonGeom zoomOutRegion;
    protected RectGeom deadRegion;
    protected RectGeom slowRegion;
    protected RectGeom mediumRegion;
    public Clock.Ticket checkMouseStillPressedTicket;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoZoomSlider;

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush bBrush) {
        this.set(background, (BValue)bBrush, null);
    }

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder bBorder) {
        this.set(border, (BValue)bBorder, null);
    }

    public BRelTime getKeepDownInterval() {
        return (BRelTime)this.get(keepDownInterval);
    }

    public void setKeepDownInterval(BRelTime bRelTime) {
        this.set(keepDownInterval, (BValue)bRelTime, null);
    }

    public void checkMouseStillPressed() {
        this.invoke(checkMouseStillPressed, null, null);
    }

    public void fireZoom(BVideoZoomEnum bVideoZoomEnum) {
        this.fire(zoom, (BValue)bVideoZoomEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCheckMouseStillPressed() {
        movementProcessingQueue.enqueue((Object)new Runnable(){

            public final void run() {
                BVideoZoomSlider.this.asyncCheckMouseStillPressed();
            }
        });
    }

    public synchronized void asyncCheckMouseStillPressed() {
        this.fireZoom(this.zoomAction);
        if (this.joystickState >= 1) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(20.0, 100.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.boxX = 1.0;
        this.boxY = 1.0;
        this.boxW = this.getWidth() - (double)2;
        this.boxH = this.getHeight() - (double)2;
        this.computeRegionCoordinates();
    }

    public void setSize(double d, double d2) {
        if (d < d2) {
            d = MAGNIFYING_GLASS_IMAGE.getWidth() + (double)4;
        } else {
            d2 = MAGNIFYING_GLASS_IMAGE.getHeight() + (double)4;
        }
        super.setSize(d, d2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        graphics.useAntiAliasing(true);
        try {
            graphics.push();
            if (this.isEnabled()) {
                graphics.setBrush(this.getBackground());
            } else {
                graphics.setBrush(BBrush.makeSolid((BColor)BColor.lightGray));
            }
            graphics.fillRect(this.boxX, this.boxY, this.boxW, this.boxH);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        graphics.pop();
        this.getBorder().paint(graphics, this.boxX, this.boxY, this.boxW, this.boxH);
        this.computeButtonCoordinates();
        if (this.joystickState >= 1) {
            this.paintCurrentRegion(graphics);
            if (this.speed >= 1) {
                graphics.setPen(solidPen);
                graphics.setBrush(this.computeSpeedBrush());
                graphics.strokeRect(this.boxX, this.boxY, this.boxW, this.boxH);
            }
        }
        this.paintButton(graphics);
        graphics.useAntiAliasing(false);
    }

    protected void computeButtonCoordinates() {
        double d = 0.95;
        if (this.joystickState >= 1) {
            double d2;
            this.buttonW = this.boxW * (d / 1.2);
            this.buttonH = this.boxH * (d / 1.2);
            this.buttonW = d2 = this.buttonW > this.buttonH ? this.buttonH : this.buttonW;
            this.buttonH = d2;
            this.buttonX = this.mouseX - this.buttonW / (double)2;
            this.buttonY = this.mouseY - this.buttonH / (double)2;
            this.joystickState = 1;
            if (this.buttonX < this.boxX) {
                this.buttonX = this.boxX;
            }
            if (this.buttonX > this.boxW - this.buttonW) {
                this.buttonX = this.boxW - this.buttonW;
            }
            if (this.buttonY < this.boxY) {
                this.buttonY = this.boxY;
            }
            if (this.buttonY > this.boxH - this.buttonH) {
                this.buttonY = this.boxH - this.buttonH;
            }
        } else {
            double d3;
            this.buttonW = this.boxW * d;
            this.buttonH = this.boxH * d;
            this.buttonW = d3 = this.buttonW > this.buttonH ? this.buttonH : this.buttonW;
            this.buttonH = d3;
            this.buttonX = this.boxX + this.boxW / (double)2 - this.buttonW / (double)2;
            this.buttonY = this.boxY + this.boxH / (double)2 - this.buttonH / (double)2;
        }
    }

    protected void paintCurrentRegion(Graphics graphics) {
        if (this.speed >= 1 && this.speed <= 3) {
            graphics.setBrush(this.computeSpeedBrush());
            if (this.direction > 0) {
                this.fillCurrentRegion(graphics);
            }
        }
    }

    protected BBrush computeSpeedBrush() {
        BBrush bBrush = null;
        bBrush = this.speed == 1 ? BBrush.makeSolid((BColor)BColor.make((int)0x333399FF, (boolean)true)) : (this.speed == 2 ? BBrush.makeSolid((BColor)BColor.make((int)-2009884161, (boolean)true)) : BBrush.makeSolid((BColor)BColor.make((int)-298608129, (boolean)true)));
        return bBrush;
    }

    protected void fillCurrentRegion(Graphics graphics) {
        switch (this.direction) {
            case 2: {
                graphics.fill((IGeom)this.zoomOutRegion);
                break;
            }
            case 1: {
                graphics.fill((IGeom)this.zoomInRegion);
                break;
            }
        }
    }

    protected void computeRegionCoordinates() {
        this.computeOrientation();
        this.computeZoomOutRegion();
        this.computeZoomInRegion();
        this.computeDeadRegion();
        this.computeSlowRegion();
        this.computeMediumRegion();
    }

    protected void computeZoomInRegion() {
        if (this.orientation == 1) {
            double[] dArray = new double[]{this.boxX, this.boxW, this.boxW, this.boxX};
            double[] dArray2 = new double[]{this.boxY, this.boxY, this.boxH / (double)2, this.boxH / (double)2};
            this.zoomInRegion = new PolygonGeom(dArray, dArray2, dArray.length);
        } else {
            double[] dArray = new double[]{this.boxW / (double)2, this.boxW, this.boxW, this.boxW / (double)2};
            double[] dArray3 = new double[]{this.boxY, this.boxY, this.boxH, this.boxH};
            this.zoomInRegion = new PolygonGeom(dArray, dArray3, dArray.length);
        }
    }

    protected void computeZoomOutRegion() {
        if (this.orientation == 1) {
            double[] dArray = new double[]{this.boxX, this.boxW, this.boxW, this.boxX};
            double[] dArray2 = new double[]{this.boxH, this.boxH, this.boxH / (double)2, this.boxH / (double)2};
            this.zoomOutRegion = new PolygonGeom(dArray, dArray2, dArray.length);
        } else {
            double[] dArray = new double[]{this.boxX, this.boxW / (double)2, this.boxW / (double)2, this.boxX};
            double[] dArray3 = new double[]{this.boxY, this.boxY, this.boxH, this.boxH};
            this.zoomOutRegion = new PolygonGeom(dArray, dArray3, dArray.length);
        }
    }

    protected void computeOrientation() {
        this.orientation = this.boxW > this.boxH ? 0 : 1;
    }

    protected void computeDeadRegion() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.orientation == 1) {
            d = this.boxW;
            d2 = this.boxW;
        } else {
            d = this.boxH;
            d2 = this.boxH;
        }
        double d3 = this.boxW / (double)2 - d / (double)2;
        double d4 = this.boxH / (double)2 - d2 / (double)2;
        this.deadRegion = new RectGeom(d3, d4, d, d2);
    }

    protected void computeSlowRegion() {
        double d = this.orientation == 1 ? this.boxW : this.boxW * 0.65;
        double d2 = this.orientation == 1 ? this.boxH * 0.65 : this.boxH;
        double d3 = this.boxW / (double)2 - d / (double)2;
        double d4 = this.boxH / (double)2 - d2 / (double)2;
        this.slowRegion = new RectGeom(d3, d4, d, d2);
    }

    protected void computeMediumRegion() {
        this.mediumRegion = new RectGeom(this.boxX, this.boxY, this.boxW, this.boxH);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintButton(Graphics graphics) {
        try {
            graphics.push();
            if (this.isEnabled()) {
                graphics.drawImage(MAGNIFYING_GLASS_IMAGE, this.buttonX + this.buttonW / (double)2 - MAGNIFYING_GLASS_IMAGE.getWidth() / (double)2, this.buttonY + this.buttonH / (double)2 - MAGNIFYING_GLASS_IMAGE.getHeight() / (double)2);
            } else {
                graphics.drawImage(MAGNIFYING_GLASS_DISABLED_IMAGE, this.buttonX, this.buttonY);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        graphics.pop();
    }

    public synchronized void mouseReleased(BMouseEvent bMouseEvent) {
        this.mouseX = bMouseEvent.getX();
        this.mouseY = bMouseEvent.getY();
        this.handleMouseReleased();
        this.repaint();
    }

    protected void handleMouseReleased() {
        this.joystickState = 0;
        this.speed = 0;
        this.direction = -1;
        this.zoomAction = BVideoZoomEnum.none;
        this.setMouseCursor(MouseCursor.normal);
        if (this.checkMouseStillPressedTicket != null) {
            this.checkMouseStillPressedTicket.cancel();
            this.fireZoom(this.zoomAction);
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.mouseX = bMouseEvent.getX();
        this.mouseY = bMouseEvent.getY();
        int n = this.joystickState;
        BVideoZoomEnum bVideoZoomEnum = this.zoomAction;
        this.joystickState = 1;
        this.speed = this.computeSpeed();
        this.direction = this.computeDirection();
        this.zoomAction = this.computeZoomAction();
        this.setMouseCursor(MouseCursor.grabHand);
        if (n < 1 || bVideoZoomEnum != this.zoomAction) {
            if (this.checkMouseStillPressedTicket != null) {
                this.checkMouseStillPressedTicket.cancel();
            }
            this.fireZoom(this.zoomAction);
        }
        if (this.checkMouseStillPressedTicket == null || this.checkMouseStillPressedTicket.isExpired()) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
        this.repaint();
    }

    protected BVideoZoomEnum computeZoomAction() {
        if (this.joystickState >= 1) {
            switch (this.speed) {
                case 0: {
                    return BVideoZoomEnum.none;
                }
                case 1: {
                    return this.computeZoomActionSlow();
                }
                case 2: {
                    return this.computeZoomActionMedium();
                }
                case 3: {
                    return this.computeZoomActionFast();
                }
            }
            throw new IllegalStateException("Unrecognized speed index (" + this.speed + ").");
        }
        return BVideoZoomEnum.none;
    }

    protected BVideoZoomEnum computeZoomActionSlow() {
        this.computeDirection();
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInSlow;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutSlow;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoZoomEnum computeZoomActionMedium() {
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInMedium;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutMedium;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoZoomEnum computeZoomActionFast() {
        switch (this.direction) {
            case 1: {
                return BVideoZoomEnum.zoomInFast;
            }
            case 2: {
                return BVideoZoomEnum.zoomOutFast;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected int computeSpeed() {
        double d;
        double d2 = this.buttonX + this.buttonW / (double)2;
        double d3 = this.buttonY + this.buttonH / (double)2;
        double d4 = this.orientation == 1 ? this.mouseY : d3;
        double d5 = d = this.orientation == 1 ? d2 : this.mouseX;
        if (this.deadRegion.contains(d, d4)) {
            return 0;
        }
        if (this.slowRegion.contains(d, d4)) {
            return 1;
        }
        if (this.mediumRegion.contains(d, d4)) {
            return 2;
        }
        return 3;
    }

    protected int computeDirection() {
        double d = this.buttonX + this.buttonW / (double)2;
        double d2 = this.buttonY + this.buttonH / (double)2;
        if (this.zoomInRegion.contains(d, d2)) {
            return 1;
        }
        if (this.zoomOutRegion.contains(d, d2)) {
            return 2;
        }
        return -1;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mouseX = 0.0;
        this.mouseY = 0.0;
        this.speed = -1;
        this.direction = -1;
        this.orientation = -1;
        this.zoomAction = null;
        this.checkMouseStillPressedTicket = null;
    }

    public BVideoZoomSlider() {
        this.this();
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)20.0, (double)100.0));
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoZoomSlider;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoZoomSlider = BVideoZoomSlider.class("[Lcom.tridium.videoDriver.ui.camera.BVideoZoomSlider;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"zoomIn.png");
        solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
        movementProcessingQueue = new Queue();
        movementProcessingWorker = new Worker((Worker.ITodo)movementProcessingQueue);
        MAGNIFYING_GLASS_IMAGE = BImage.make((BIcon)BIcon.std((String)"magnifyingGlass.png"));
        MAGNIFYING_GLASS_DISABLED_IMAGE = MAGNIFYING_GLASS_IMAGE.getDisabledImage();
        movementProcessingWorker.start("BVideoZoomSlider:worker");
    }
}

