/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.palladium.PalladiumWidgetTheme;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.EllipseGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoPanTiltJoystick
extends BWidget {
    public static final PalladiumWidgetTheme PWT = new PalladiumWidgetTheme();
    public static final BBrush DEFAULT_BALL_BRUSH_IDLE = BBrush.NULL;
    public static final BBrush DEFAULT_BALL_BRUSH_DRAGGING = BBrush.NULL;
    public static final Property background = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property border = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BBorder.inset, null);
    public static final Property ballPercent = BVideoPanTiltJoystick.newProperty((int)0, (double)0.33, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BDouble.make((double)0.5))));
    public static final Property fillBallNormal = BVideoPanTiltJoystick.newProperty((int)0, (BValue)DEFAULT_BALL_BRUSH_IDLE, null);
    public static final Property fillBallDragging = BVideoPanTiltJoystick.newProperty((int)0, (BValue)DEFAULT_BALL_BRUSH_DRAGGING, null);
    public static final Property keepDownInterval = BVideoPanTiltJoystick.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Action checkMouseStillPressed = BVideoPanTiltJoystick.newAction((int)0, null);
    public static final Topic move = BVideoPanTiltJoystick.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING_BALL = 1;
    public static final int SPEED_NONE = 0;
    public static final int SPEED_SLOW = 1;
    public static final int SPEED_MEDIUM = 2;
    public static final int SPEED_FAST = 3;
    private static final double slowPercent = 0.65;
    private static final int cap = 102;
    private static final int join = 203;
    private static final BPen solidPen;
    public static Queue movementProcessingQueue;
    public static Worker movementProcessingWorker;
    protected int joystickState;
    protected double mouseX;
    protected double mouseY;
    protected double boxX;
    protected double boxY;
    protected double boxW;
    protected double boxH;
    protected double ballX;
    protected double ballY;
    protected double ballW;
    protected double ballH;
    protected BBrush ballBrush;
    protected int speed;
    protected int direction;
    protected BVideoPanTiltEnum panTiltAction;
    protected PolygonGeom upperLeft;
    protected PolygonGeom upper;
    protected PolygonGeom upperRight;
    protected PolygonGeom left;
    protected PolygonGeom right;
    protected PolygonGeom lowerLeft;
    protected PolygonGeom lower;
    protected PolygonGeom lowerRight;
    protected RectGeom deadRegion;
    protected RectGeom slowRegion;
    protected RectGeom mediumRegion;
    protected boolean mouseOverWidget;
    public Clock.Ticket checkMouseStillPressedTicket;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoPanTiltJoystick;

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush bBrush) {
        this.set(background, (BValue)bBrush, null);
    }

    public BBorder getBorder() {
        return (BBorder)this.get(border);
    }

    public void setBorder(BBorder bBorder) {
        this.set(border, (BValue)bBorder, null);
    }

    public double getBallPercent() {
        return this.getDouble(ballPercent);
    }

    public void setBallPercent(double d) {
        this.setDouble(ballPercent, d, null);
    }

    public BBrush getFillBallNormal() {
        return (BBrush)this.get(fillBallNormal);
    }

    public void setFillBallNormal(BBrush bBrush) {
        this.set(fillBallNormal, (BValue)bBrush, null);
    }

    public BBrush getFillBallDragging() {
        return (BBrush)this.get(fillBallDragging);
    }

    public void setFillBallDragging(BBrush bBrush) {
        this.set(fillBallDragging, (BValue)bBrush, null);
    }

    public BRelTime getKeepDownInterval() {
        return (BRelTime)this.get(keepDownInterval);
    }

    public void setKeepDownInterval(BRelTime bRelTime) {
        this.set(keepDownInterval, (BValue)bRelTime, null);
    }

    public void checkMouseStillPressed() {
        this.invoke(checkMouseStillPressed, null, null);
    }

    public void fireMove(BVideoPanTiltEnum bVideoPanTiltEnum) {
        this.fire(move, (BValue)bVideoPanTiltEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doCheckMouseStillPressed() {
        movementProcessingQueue.enqueue((Object)new Runnable(){

            public final void run() {
                BVideoPanTiltJoystick.this.asyncCheckMouseStillPressed();
            }
        });
    }

    public synchronized void asyncCheckMouseStillPressed() {
        this.fireMove(this.panTiltAction);
        if (this.joystickState >= 1) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 100.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.boxX = 1.0;
        this.boxY = 1.0;
        this.boxW = this.getWidth() - (double)2;
        this.boxH = this.getHeight() - (double)2;
        this.computeRegionCoordinates();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        graphics.useAntiAliasing(true);
        try {
            graphics.push();
            graphics.setBrush(this.getBackground());
            graphics.fillRect(this.boxX, this.boxY, this.boxW, this.boxH);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        graphics.pop();
        this.getBorder().paint(graphics, this.boxX, this.boxY, this.boxW, this.boxH);
        this.computeBallCoordinates();
        if (this.joystickState >= 1) {
            this.paintCurrentRegion(graphics);
            if (this.speed >= 1) {
                graphics.setPen(solidPen);
                graphics.setBrush(this.computeSpeedBrush());
                graphics.strokeRect(this.boxX, this.boxY, this.boxW, this.boxH);
            }
        }
        this.paintBall(graphics);
        graphics.useAntiAliasing(false);
    }

    protected void paintBall(Graphics graphics) {
        EllipseGeom ellipseGeom = new EllipseGeom(this.ballX, this.ballY, this.ballW, this.ballH);
        graphics.setPen(BPen.make((double)1.0));
        graphics.setBrush(this.ballBrush);
        graphics.fill((IGeom)ellipseGeom);
    }

    protected void computeBallCoordinates() {
        double d = this.getBallPercent();
        if (this.joystickState >= 1) {
            double d2;
            this.ballW = this.boxW * (d / 1.2);
            this.ballH = this.boxH * (d / 1.2);
            this.ballW = d2 = this.ballW > this.ballH ? this.ballH : this.ballW;
            this.ballH = d2;
            this.ballX = this.mouseX - this.ballW / (double)2;
            this.ballY = this.mouseY - this.ballH / (double)2;
            this.joystickState = 1;
            if (this.ballX < this.boxX) {
                this.ballX = this.boxX;
            }
            if (this.ballX > this.boxW - this.ballW) {
                this.ballX = this.boxW - this.ballW;
            }
            if (this.ballY < this.boxY) {
                this.ballY = this.boxY;
            }
            if (this.ballY > this.boxH - this.ballH) {
                this.ballY = this.boxH - this.ballH;
            }
            this.ballBrush = this.getFillBallDragging();
        } else {
            double d3;
            this.ballW = this.boxW * d;
            this.ballH = this.boxH * d;
            this.ballW = d3 = this.ballW > this.ballH ? this.ballH : this.ballW;
            this.ballH = d3;
            this.ballX = this.boxX + this.boxW / (double)2 - this.ballW / (double)2;
            this.ballY = this.boxY + this.boxH / (double)2 - this.ballH / (double)2;
            this.ballBrush = this.getFillBallNormal();
        }
    }

    protected BBrush computeSpeedBrush() {
        BBrush bBrush = null;
        bBrush = this.speed == 1 ? BBrush.makeSolid((BColor)BColor.make((int)0x333399FF, (boolean)true)) : (this.speed == 2 ? BBrush.makeSolid((BColor)BColor.make((int)-2009884161, (boolean)true)) : BBrush.makeSolid((BColor)BColor.make((int)-298608129, (boolean)true)));
        return bBrush;
    }

    protected void fillCurrentRegion(Graphics graphics) {
        switch (this.direction) {
            case 1: {
                graphics.fill((IGeom)this.lowerLeft);
                break;
            }
            case 2: {
                graphics.fill((IGeom)this.lower);
                break;
            }
            case 3: {
                graphics.fill((IGeom)this.lowerRight);
                break;
            }
            case 4: {
                graphics.fill((IGeom)this.left);
                break;
            }
            case 6: {
                graphics.fill((IGeom)this.right);
                break;
            }
            case 7: {
                graphics.fill((IGeom)this.upperLeft);
                break;
            }
            case 8: {
                graphics.fill((IGeom)this.upper);
                break;
            }
            case 9: {
                graphics.fill((IGeom)this.upperRight);
                break;
            }
        }
    }

    protected void paintCurrentRegion(Graphics graphics) {
        if (this.speed >= 1 && this.speed <= 3) {
            graphics.setBrush(this.computeSpeedBrush());
            if (this.direction > 0) {
                this.fillCurrentRegion(graphics);
            }
        }
    }

    protected void computeRegionCoordinates() {
        this.computeUpperLeftRegion();
        this.computeUpperRegion();
        this.computeUpperRightRegion();
        this.computeLeftRegion();
        this.computeRightRegion();
        this.computeLowerLeftRegion();
        this.computeLowerRegion();
        this.computeLowerRightRegion();
        this.computeDeadRegion();
        this.computeSlowRegion();
        this.computeMediumRegion();
    }

    protected void computeUpperLeftRegion() {
        double[] dArray = new double[]{this.boxX, this.boxW * 0.25, this.boxW * 0.4, this.boxX};
        double[] dArray2 = new double[]{this.boxY, this.boxY, this.boxH * 0.4, this.boxH * 0.25};
        this.upperLeft = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeUpperRegion() {
        double[] dArray = new double[]{this.boxW * 0.25, this.boxW * 0.75, this.boxW * 0.6, this.boxW / (double)2, this.boxW * 0.4};
        double[] dArray2 = new double[]{this.boxY, this.boxY, this.boxH * 0.4, this.boxH / (double)2, this.boxH * 0.4};
        this.upper = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeUpperRightRegion() {
        double[] dArray = new double[]{this.boxW, this.boxW, this.boxW * 0.6, this.boxW * 0.75};
        double[] dArray2 = new double[]{this.boxY, this.boxH * 0.25, this.boxH * 0.4, this.boxY};
        this.upperRight = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeLeftRegion() {
        double[] dArray = new double[]{this.boxX, this.boxW * 0.4, this.boxW / (double)2, this.boxW * 0.4, this.boxX};
        double[] dArray2 = new double[]{this.boxH * 0.25, this.boxH * 0.4, this.boxH / (double)2, this.boxH * 0.6, this.boxH * 0.75};
        this.left = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeRightRegion() {
        double[] dArray = new double[]{this.boxW, this.boxW * 0.6, this.boxW / (double)2, this.boxW * 0.6, this.boxW};
        double[] dArray2 = new double[]{this.boxH * 0.25, this.boxH * 0.4, this.boxH / (double)2, this.boxH * 0.6, this.boxH * 0.75};
        this.right = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeLowerLeftRegion() {
        double[] dArray = new double[]{this.boxX, this.boxW * 0.25, this.boxW * 0.4, this.boxX};
        double[] dArray2 = new double[]{this.boxH, this.boxH, this.boxH * 0.6, this.boxH * 0.75};
        this.lowerLeft = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeLowerRegion() {
        double[] dArray = new double[]{this.boxW * 0.25, this.boxW * 0.75, this.boxW * 0.6, this.boxW / (double)2, this.boxW * 0.4};
        double[] dArray2 = new double[]{this.boxH, this.boxH, this.boxH * 0.6, this.boxH / (double)2, this.boxH * 0.6};
        this.lower = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeLowerRightRegion() {
        double[] dArray = new double[]{this.boxW, this.boxW, this.boxW * 0.6, this.boxW * 0.75};
        double[] dArray2 = new double[]{this.boxH, this.boxH * 0.75, this.boxH * 0.6, this.boxH};
        this.lowerRight = new PolygonGeom(dArray, dArray2, dArray.length);
    }

    protected void computeDeadRegion() {
        double d = this.getBallPercent();
        double d2 = this.boxW * d;
        double d3 = this.boxH * d;
        double d4 = this.boxW / (double)2 - d2 / (double)2;
        double d5 = this.boxH / (double)2 - d3 / (double)2;
        this.deadRegion = new RectGeom(d4, d5, d2, d3);
    }

    protected void computeSlowRegion() {
        double d = this.boxW * 0.65;
        double d2 = this.boxH * 0.65;
        double d3 = this.boxW / (double)2 - d / (double)2;
        double d4 = this.boxH / (double)2 - d2 / (double)2;
        this.slowRegion = new RectGeom(d3, d4, d, d2);
    }

    protected void computeMediumRegion() {
        this.mediumRegion = new RectGeom(this.boxX, this.boxY, this.boxW, this.boxH);
    }

    public synchronized void mouseReleased(BMouseEvent bMouseEvent) {
        this.mouseX = bMouseEvent.getX();
        this.mouseY = bMouseEvent.getY();
        this.handleMouseReleased();
        this.repaint();
    }

    protected void handleMouseReleased() {
        this.joystickState = 0;
        this.speed = 0;
        this.direction = -1;
        this.panTiltAction = BVideoPanTiltEnum.none;
        if (this.checkMouseStillPressedTicket != null) {
            this.checkMouseStillPressedTicket.cancel();
            this.fireMove(this.panTiltAction);
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            this.setMouseCursor(MouseCursor.grabHand);
        }
        this.mouseOverWidget = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOverWidget = false;
        this.repaint();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.mouseX = bMouseEvent.getX();
        this.mouseY = bMouseEvent.getY();
        int n = this.joystickState;
        BVideoPanTiltEnum bVideoPanTiltEnum = this.panTiltAction;
        this.joystickState = 1;
        this.speed = this.computeSpeed();
        this.direction = this.computeDirection();
        this.panTiltAction = this.computePanTiltAction();
        if (n < 1 || bVideoPanTiltEnum != this.panTiltAction) {
            if (this.checkMouseStillPressedTicket != null) {
                this.checkMouseStillPressedTicket.cancel();
            }
            this.fireMove(this.panTiltAction);
        }
        if (this.checkMouseStillPressedTicket == null || this.checkMouseStillPressedTicket.isExpired()) {
            this.checkMouseStillPressedTicket = Clock.schedule((BComponent)this, (BRelTime)this.getKeepDownInterval(), (Action)checkMouseStillPressed, null);
        }
        this.repaint();
    }

    protected int computeSpeed() {
        this.computeBallCoordinates();
        if (this.deadRegion.contains(this.mouseX, this.mouseY)) {
            return 0;
        }
        if (this.slowRegion.contains(this.mouseX, this.mouseY)) {
            return 1;
        }
        if (this.mediumRegion.contains(this.mouseX, this.mouseY)) {
            return 2;
        }
        return 3;
    }

    protected int computeDirection() {
        double d = this.ballX + this.ballW / (double)2;
        double d2 = this.ballY + this.ballH / (double)2;
        if (this.upperLeft.contains(d, d2)) {
            return 7;
        }
        if (this.upper.contains(d, d2)) {
            return 8;
        }
        if (this.upperRight.contains(d, d2)) {
            return 9;
        }
        if (this.left.contains(d, d2)) {
            return 4;
        }
        if (this.right.contains(d, d2)) {
            return 6;
        }
        if (this.lowerLeft.contains(d, d2)) {
            return 1;
        }
        if (this.lower.contains(d, d2)) {
            return 2;
        }
        if (this.lowerRight.contains(d, d2)) {
            return 3;
        }
        return -1;
    }

    protected BVideoPanTiltEnum computePanTiltActionSlow() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftSlow;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpSlow;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpSlow;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpSlow;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightSlow;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownSlow;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownSlow;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownSlow;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_SLOW (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltActionMedium() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftMedium;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpMedium;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpMedium;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpMedium;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightMedium;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownMedium;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownMedium;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownMedium;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_MEDIUM (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltActionFast() {
        switch (this.direction) {
            case 4: {
                return BVideoPanTiltEnum.panLeftFast;
            }
            case 7: {
                return BVideoPanTiltEnum.panLeftTiltUpFast;
            }
            case 8: {
                return BVideoPanTiltEnum.tiltUpFast;
            }
            case 9: {
                return BVideoPanTiltEnum.panRightTiltUpFast;
            }
            case 6: {
                return BVideoPanTiltEnum.panRightFast;
            }
            case 1: {
                return BVideoPanTiltEnum.panLeftTiltDownFast;
            }
            case 2: {
                return BVideoPanTiltEnum.tiltDownFast;
            }
            case 3: {
                return BVideoPanTiltEnum.panRightTiltDownFast;
            }
        }
        throw new IllegalStateException("Unrecognized direction index (" + this.direction + ") for speed index SPEED_FAST (" + this.speed + ").");
    }

    protected BVideoPanTiltEnum computePanTiltAction() {
        if (this.joystickState >= 1) {
            switch (this.speed) {
                case 0: {
                    return BVideoPanTiltEnum.none;
                }
                case 1: {
                    return this.computePanTiltActionSlow();
                }
                case 2: {
                    return this.computePanTiltActionMedium();
                }
                case 3: {
                    return this.computePanTiltActionFast();
                }
            }
            throw new IllegalStateException("Unrecognized speed index (" + this.speed + ").");
        }
        return BVideoPanTiltEnum.none;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mouseX = 0.0;
        this.mouseY = 0.0;
        this.speed = -1;
        this.direction = -1;
        this.panTiltAction = null;
        this.checkMouseStillPressedTicket = null;
    }

    public BVideoPanTiltJoystick() {
        this.this();
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)100.0, (double)100.0));
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoPanTiltJoystick;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoPanTiltJoystick = BVideoPanTiltJoystick.class("[Lcom.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"pan.png");
        solidPen = BPen.make((double)1.0, (int)102, (int)203, null);
        movementProcessingQueue = new Queue();
        movementProcessingWorker = new Worker((Worker.ITodo)movementProcessingQueue);
        movementProcessingWorker.start("BVideoPanTiltJoystick:worker");
    }
}

