/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoEventChooser
extends BDialog {
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Lexicon LEX;
    public Command pageUpCmd;
    public Command pageDownCmd;
    protected Command pageHomeCmd;
    public Command seekMoreCmd;
    public Command selectCmd;
    public Command cancelCmd;
    protected BVideoEvent[] eventTableArray;
    protected BEdgePane mainEdgePane;
    protected BTable eventTable;
    protected BVideoEventRecall driverEventRecallComponent;
    protected EventPlayback eventPlaybackView;
    protected BAbsTime videoEventListEpicenter;
    protected BPane infoPane;
    protected BLabel infoLabel;
    protected BAbsTime mostRecentEpicenter;
    protected String timeIndexHeader;
    protected String msgTextHeader;
    protected String LOADING_EVENTS;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoEventChooser;

    public Type getType() {
        return TYPE;
    }

    protected void drawToolbarPane() {
        BGridPane bGridPane = new BGridPane(10);
        BButton bButton = new BButton(this.pageUpCmd, false, true);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        BButton bButton2 = new BButton(this.pageDownCmd, false, true);
        bButton2.setButtonStyle(BButtonStyle.toolBar);
        BButton bButton3 = new BButton(this.seekMoreCmd, false, true);
        bButton3.setButtonStyle(BButtonStyle.toolBar);
        BButton bButton4 = new BButton(this.pageHomeCmd, false, true);
        bButton4.setButtonStyle(BButtonStyle.toolBar);
        bGridPane.add("pageLabel", (BValue)new BLabel(LEX.getText("VideoEventChooser.Page")));
        bGridPane.add("pageUp", (BValue)bButton);
        bGridPane.add("pageDown", (BValue)bButton2);
        bGridPane.add("pageHome", (BValue)bButton4);
        bGridPane.add("seekMore", (BValue)bButton3);
        this.mainEdgePane.setTop((BWidget)new BBorderPane((BWidget)bGridPane, BBorder.groove, BInsets.make((double)1.0)));
    }

    protected void drawEventChooser() {
        this.mainEdgePane = new BEdgePane();
        this.eventTable = new BTable((TableModel)new EventChooserTableModel(), (TableController)new EventChooserTableController());
        this.eventTable.setSelection((TableSelection)new EventChooserTableSelection());
        this.infoLabel = new BLabel(this.LOADING_EVENTS);
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.infoLabel));
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bScrollPane.setViewportBackground(Theme.button().getControlBackground());
        this.infoPane = new BBorderPane((BWidget)bScrollPane);
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
        this.drawToolbarPane();
        this.enableTools(false);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BButton(this.selectCmd));
        bGridPane.add(null, (BValue)new BButton(this.cancelCmd));
        this.selectCmd.setEnabled(false);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.mainEdgePane));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bGridPane, BBorder.groove), BInsets.make((double)0.0, (double)10.0, (double)10.0, (double)10.0)));
        this.setContent((BWidget)bEdgePane);
    }

    public void updateEventListFailed(String string) {
        this.enableTools(false);
        this.pageHomeCmd.setEnabled(true);
        this.seekMoreCmd.setEnabled(true);
        this.infoLabel.setText(LEX.getText("VideoEventChooser.LoadingEventsError", new Object[]{string}));
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public void updateEventList(BVideoEvent[] bVideoEventArray) {
        boolean bl;
        boolean bl2 = false;
        if (this.eventTableArray == null) {
            bl2 = bl = true;
        }
        if (this.mainEdgePane.getCenter() != this.eventTable) {
            this.mainEdgePane.setCenter((BWidget)this.eventTable);
        }
        this.eventTableArray = bVideoEventArray;
        if (bVideoEventArray != null && bVideoEventArray.length > 0) {
            this.eventTable.getModel().sortByColumn(0, false);
            this.eventTable.getModel().updateTable();
        }
        if (bl) {
            this.setScreenSizeToPreferredSize();
            this.setBoundsCenteredOnScreen();
        }
        this.enableTools(true);
    }

    protected void enableTools(boolean bl) {
        this.pageDownCmd.setEnabled(bl);
        this.pageUpCmd.setEnabled(bl);
        this.seekMoreCmd.setEnabled(bl);
        this.pageHomeCmd.setEnabled(bl);
        if (bl) {
            if (this.eventTable != null && this.eventTable.getSelection() != null) {
                boolean bl2 = false;
                if (this.eventTable.getSelection().getRow() != -1) {
                    bl2 = true;
                }
                this.selectCmd.setEnabled(bl2);
            }
        } else {
            this.selectCmd.setEnabled(false);
        }
    }

    protected void doPageHome() {
        this.enableTools(false);
        this.infoLabel.setText(this.pageHomeCmd.getLabel() + " - " + this.LOADING_EVENTS);
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
        this.retrieveDriverEvents(BAbsTime.now(), -20);
    }

    protected void doPageUp() {
        BAbsTime bAbsTime = this.mostRecentEpicenter;
        if (this.eventTableArray != null && this.eventTableArray.length > 0) {
            BVideoEvent[] bVideoEventArray = this.eventTableArray;
            BVideoEvent bVideoEvent = bVideoEventArray[0];
            if (bVideoEventArray.length > 1) {
                int n = 1;
                while (n < bVideoEventArray.length) {
                    if (bVideoEventArray[n].getTimestamp().isAfter(bVideoEvent.getTimestamp())) {
                        bVideoEvent = bVideoEventArray[n];
                    }
                    ++n;
                }
            }
            if (bVideoEvent != null) {
                bAbsTime = bVideoEvent.getTimestamp();
            }
        }
        if (bAbsTime != null) {
            this.enableTools(false);
            this.infoLabel.setText(this.pageUpCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(bAbsTime, 20);
        }
    }

    protected void doPageDown() {
        BAbsTime bAbsTime = this.mostRecentEpicenter;
        if (this.eventTableArray != null && this.eventTableArray.length > 0) {
            BVideoEvent[] bVideoEventArray = this.eventTableArray;
            BVideoEvent bVideoEvent = bVideoEventArray[0];
            if (bVideoEventArray.length > 1) {
                int n = 1;
                while (n < bVideoEventArray.length) {
                    if (bVideoEventArray[n].getTimestamp().isBefore(bVideoEvent.getTimestamp())) {
                        bVideoEvent = bVideoEventArray[n];
                    }
                    ++n;
                }
            }
            if (bVideoEvent != null) {
                bAbsTime = bVideoEvent.getTimestamp();
            }
        }
        if (bAbsTime != null) {
            this.enableTools(false);
            this.infoLabel.setText(this.pageDownCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(bAbsTime, -20);
        }
    }

    protected void retrieveDriverEvents(BAbsTime bAbsTime, int n) {
        if (bAbsTime != null) {
            this.mostRecentEpicenter = bAbsTime;
            this.eventPlaybackView.retrieveDriverEvents(bAbsTime, n);
        }
    }

    protected void doSelect() {
        int n = this.eventTable.getSelection().getRow();
        if (n != -1 && n < this.eventTableArray.length) {
            this.eventPlaybackView.playEvent(this.eventTableArray[n]);
        }
    }

    protected void doCancel() {
        this.close();
    }

    protected void doSeekMore() {
        BAbsTime bAbsTime;
        BAbsTime bAbsTime2;
        try {
            bAbsTime2 = this.videoEventListEpicenter;
        }
        catch (Exception exception) {
            bAbsTime2 = BAbsTime.now();
        }
        try {
            bAbsTime = (BAbsTime)BWbFieldEditor.dialog((BWidget)this, (String)LEX.getText("VideoPlaybackView.PlayFromTimeIndex.title"), (BObject)bAbsTime2, (Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
            bAbsTime = bAbsTime.subtract(BRelTime.makeSeconds((int)1));
        }
        catch (Exception exception) {
            bAbsTime = BAbsTime.NULL;
        }
        if (bAbsTime != null && !bAbsTime.isNull()) {
            this.enableTools(false);
            this.infoLabel.setText(this.seekMoreCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(bAbsTime, 20);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public static void main(String[] stringArray) {
        BVideoEventChooser bVideoEventChooser = new BVideoEventChooser(null, null, null);
        bVideoEventChooser.open();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pageUpCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageUp"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doPageUp();
                return null;
            }
        };
        this.pageDownCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageDown"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doPageDown();
                return null;
            }
        };
        this.pageHomeCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageHome"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doPageHome();
                return null;
            }
        };
        this.seekMoreCmd = new Command((BWidget)this, LEX, "VideoEventChooser.SeekMore"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doSeekMore();
                return null;
            }
        };
        this.selectCmd = new Command((BWidget)this, LEX, "VideoEventChooser.Select"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doSelect();
                BVideoEventChooser.this.close();
                return null;
            }
        };
        this.cancelCmd = new Command((BWidget)this, (Lexicon)UiLexicon.bajaui, "commands.close"){

            public final CommandArtifact doInvoke() throws Exception {
                BVideoEventChooser.this.doCancel();
                return null;
            }
        };
        this.videoEventListEpicenter = BAbsTime.make();
        this.mostRecentEpicenter = BAbsTime.NULL;
        this.timeIndexHeader = LEX.getText("EventChooserTable.Header.TimeIndex");
        this.msgTextHeader = LEX.getText("EventChooserTable.Header.MsgText");
        this.LOADING_EVENTS = LEX.getText("VideoEventChooser.LoadingEvents");
    }

    public BVideoEventChooser() {
        this.this();
    }

    public BVideoEventChooser(BWidget bWidget, BVideoEventRecall bVideoEventRecall, EventPlayback eventPlayback) {
        super(bWidget, LEX.getText("VideoEventChooser.title"), true);
        this.this();
        this.driverEventRecallComponent = bVideoEventRecall;
        this.eventPlaybackView = eventPlayback;
        this.videoEventListEpicenter = BAbsTime.now();
        this.drawEventChooser();
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoEventChooser;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoEventChooser = BVideoEventChooser.class("[Lcom.tridium.videoDriver.ui.camera.BVideoEventChooser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://videoDriver/eventsExt.png");
        Class clazz2 = class$com$tridium$videoDriver$ui$camera$BVideoEventChooser;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$videoDriver$ui$camera$BVideoEventChooser = BVideoEventChooser.class("[Lcom.tridium.videoDriver.ui.camera.BVideoEventChooser;", false);
        }
        LEX = Lexicon.make((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EventChooserTableModel
    extends TableModel {
        public BImage getRowIcon(int n) {
            if (BVideoEventChooser.this.eventTableArray != null && n < BVideoEventChooser.this.eventTableArray.length) {
                return BImage.make((BIcon)BVideoEventChooser.this.eventTableArray[n].getIcon());
            }
            return BImage.NULL;
        }

        public int getRowCount() {
            if (BVideoEventChooser.this.eventTableArray != null) {
                return BVideoEventChooser.this.eventTableArray.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return BVideoEventChooser.this.timeIndexHeader;
            }
            if (n == 1) {
                return BVideoEventChooser.this.msgTextHeader;
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            if (BVideoEventChooser.this.eventTableArray != null && n < BVideoEventChooser.this.eventTableArray.length) {
                BVideoEvent bVideoEvent = BVideoEventChooser.this.eventTableArray[n];
                if (n2 == 0) {
                    return bVideoEvent.getTimestamp().toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
                }
                if (n2 == 1) {
                    return bVideoEvent.getDescription();
                }
                return "";
            }
            return "";
        }

        public boolean isColumnSortable(int n) {
            return n == 0 || n == 1;
        }

        public void sortByColumn(int n, boolean bl) {
            if (BVideoEventChooser.this.eventTableArray != null) {
                Object[] objectArray;
                if (n == 0) {
                    objectArray = new BAbsTime[BVideoEventChooser.this.eventTableArray.length];
                    int n2 = 0;
                    while (n2 < BVideoEventChooser.this.eventTableArray.length) {
                        objectArray[n2] = BVideoEventChooser.this.eventTableArray[n2].getTimestamp();
                        ++n2;
                    }
                } else if (n == 1) {
                    objectArray = new String[BVideoEventChooser.this.eventTableArray.length];
                    int n3 = 0;
                    while (n3 < BVideoEventChooser.this.eventTableArray.length) {
                        objectArray[n3] = BVideoEventChooser.this.eventTableArray[n3].getDescription();
                        ++n3;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                SortUtil.sort((Object[])objectArray, (Object[])BVideoEventChooser.this.eventTableArray, (boolean)bl);
            }
        }

        protected EventChooserTableModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EventChooserTableController
    extends TableController {
        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BVideoEventChooser.this.doSelect();
            BVideoEventChooser.this.close();
        }

        protected EventChooserTableController() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class EventChooserTableSelection
    extends TableSelection {
        public void updateTable() {
            super.updateTable();
            Command command = BVideoEventChooser.this.selectCmd;
            boolean bl = false;
            if (this.getRow() != -1) {
                bl = true;
            }
            command.setEnabled(bl);
        }

        protected EventChooserTableSelection() {
        }
    }

    public static interface EventPlayback {
        public void playEvent(BVideoEvent var1);

        public void retrieveDriverEvents(BAbsTime var1, int var2);
    }
}

