/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.Binder;
import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidgetDialog;
import com.tridium.videoDriver.ui.camera.BVideoLayerPane;
import com.tridium.videoDriver.ui.camera.BVideoPtzBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzCameraWidgetBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzDialogPane;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.PolygonGeom;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.units.BUnit;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoCameraWidget
extends BWidget {
    public static final BBrush DEFAULT_CAMERA_RECTANGLE_BRUSH = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)90.0, (BColor)BColor.black), BBrush.stop((double)100.0, (BColor)BColor.gray)});
    public static final BBrush DEFAULT_CAMERA_TRIANGLE_BRUSH = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)80.0, (BColor)BColor.black), BBrush.stop((double)100.0, (BColor)BColor.gray)});
    public static final BBrush DEFAULT_CAMERA_RECTANGLE_BRUSH_MOUSE_OVER = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)90.0, (BColor)BColor.blue), BBrush.stop((double)100.0, (BColor)BColor.slateBlue)});
    public static final BBrush DEFAULT_CAMERA_TRIANGLE_BRUSH_MOUSE_OVER = BBrush.makeLinearGradient((BBrush.Stop[])new BBrush.Stop[]{BBrush.stop((double)80.0, (BColor)BColor.blue), BBrush.stop((double)100.0, (BColor)BColor.slateBlue)});
    public static final BBrush DEFAULT_JOYSTICK_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.transparent);
    public static final Property cameraRectangleFill = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_RECTANGLE_BRUSH, null);
    public static final Property cameraRectangleFillMouseOver = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_RECTANGLE_BRUSH_MOUSE_OVER, null);
    public static final Property cameraTriangleFill = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_TRIANGLE_BRUSH, null);
    public static final Property cameraTriangleFillMouseOver = BVideoCameraWidget.newProperty((int)0, (BValue)DEFAULT_CAMERA_TRIANGLE_BRUSH_MOUSE_OVER, null);
    public static final Property cameraOutline = BVideoCameraWidget.newProperty((int)0, (BValue)BPen.DEFAULT, null);
    public static final Property zoomBackground = BVideoCameraWidget.newProperty((int)0, (BValue)Theme.scrollBar().getControlBackground(), null);
    public static final Property ptzDialogSize = BVideoCameraWidget.newProperty((int)0, (BValue)BSize.make((double)0.0, (double)0.0), null);
    public static final Property ptzBorder = BVideoCameraWidget.newProperty((int)0, (BValue)BBorder.inset, null);
    public static final Property panTiltKeepDownInterval = BVideoCameraWidget.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Property zoomKeepDownInterval = BVideoCameraWidget.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)100L))));
    public static final Property showActionsMenu = BVideoCameraWidget.newProperty((int)0, (boolean)false, null);
    public static final Property refreshRate = BVideoCameraWidget.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)25), (String)"max", (BIDataValue)BInteger.make((int)1000), (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property resolution = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    public static final Property frameRate = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    public static final Property compression = BVideoCameraWidget.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    public static final Property streamFacets = BVideoCameraWidget.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property videoStreamFox = BVideoCameraWidget.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    public static final Type TYPE;
    public static final String PAN_TILT_ZOOM = "PanTiltZoom";
    protected double x;
    protected double y;
    protected double w;
    protected double h;
    protected PolygonGeom cameraTriangle;
    protected PolygonGeom cameraRectangle;
    protected BVideoPtzCameraWidgetBinding binding;
    protected BVideoPlayer videoPlayer;
    protected boolean mouseOverWidget;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoCameraWidget;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$camera$BVideoPtzBinding;

    public BBrush getCameraRectangleFill() {
        return (BBrush)this.get(cameraRectangleFill);
    }

    public void setCameraRectangleFill(BBrush bBrush) {
        this.set(cameraRectangleFill, (BValue)bBrush, null);
    }

    public BBrush getCameraRectangleFillMouseOver() {
        return (BBrush)this.get(cameraRectangleFillMouseOver);
    }

    public void setCameraRectangleFillMouseOver(BBrush bBrush) {
        this.set(cameraRectangleFillMouseOver, (BValue)bBrush, null);
    }

    public BBrush getCameraTriangleFill() {
        return (BBrush)this.get(cameraTriangleFill);
    }

    public void setCameraTriangleFill(BBrush bBrush) {
        this.set(cameraTriangleFill, (BValue)bBrush, null);
    }

    public BBrush getCameraTriangleFillMouseOver() {
        return (BBrush)this.get(cameraTriangleFillMouseOver);
    }

    public void setCameraTriangleFillMouseOver(BBrush bBrush) {
        this.set(cameraTriangleFillMouseOver, (BValue)bBrush, null);
    }

    public BPen getCameraOutline() {
        return (BPen)this.get(cameraOutline);
    }

    public void setCameraOutline(BPen bPen) {
        this.set(cameraOutline, (BValue)bPen, null);
    }

    public BBrush getZoomBackground() {
        return (BBrush)this.get(zoomBackground);
    }

    public void setZoomBackground(BBrush bBrush) {
        this.set(zoomBackground, (BValue)bBrush, null);
    }

    public BSize getPtzDialogSize() {
        return (BSize)this.get(ptzDialogSize);
    }

    public void setPtzDialogSize(BSize bSize) {
        this.set(ptzDialogSize, (BValue)bSize, null);
    }

    public BBorder getPtzBorder() {
        return (BBorder)this.get(ptzBorder);
    }

    public void setPtzBorder(BBorder bBorder) {
        this.set(ptzBorder, (BValue)bBorder, null);
    }

    public BRelTime getPanTiltKeepDownInterval() {
        return (BRelTime)this.get(panTiltKeepDownInterval);
    }

    public void setPanTiltKeepDownInterval(BRelTime bRelTime) {
        this.set(panTiltKeepDownInterval, (BValue)bRelTime, null);
    }

    public BRelTime getZoomKeepDownInterval() {
        return (BRelTime)this.get(zoomKeepDownInterval);
    }

    public void setZoomKeepDownInterval(BRelTime bRelTime) {
        this.set(zoomKeepDownInterval, (BValue)bRelTime, null);
    }

    public boolean getShowActionsMenu() {
        return this.getBoolean(showActionsMenu);
    }

    public void setShowActionsMenu(boolean bl) {
        this.setBoolean(showActionsMenu, bl, null);
    }

    public int getRefreshRate() {
        return this.getInt(refreshRate);
    }

    public void setRefreshRate(int n) {
        this.setInt(refreshRate, n, null);
    }

    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    public void setResolution(BVideoResolutionEnum bVideoResolutionEnum) {
        this.set(resolution, (BValue)bVideoResolutionEnum, null);
    }

    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    public void setFrameRate(BVideoFrameRateEnum bVideoFrameRateEnum) {
        this.set(frameRate, (BValue)bVideoFrameRateEnum, null);
    }

    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    public void setCompression(BVideoCompressionEnum bVideoCompressionEnum) {
        this.set(compression, (BValue)bVideoCompressionEnum, null);
    }

    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    public void setStreamFacets(BFacets bFacets) {
        this.set(streamFacets, (BValue)bFacets, null);
    }

    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    public void setVideoStreamFox(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(videoStreamFox, (BValue)bFoxVideoStreamEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void paint(Graphics graphics) {
        this.x = this.getX();
        this.y = this.getY();
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.computeCameraTriangle();
        this.drawCamera(graphics);
        super.paint(graphics);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void drawCameraUserImage(Graphics graphics, BImage bImage) {
        try {
            BBrush bBrush;
            BBrush.Paint paint;
            graphics.push();
            if (this.mouseOverWidget && (paint = (bBrush = this.getCameraRectangleFillMouseOver()).getPaint()) instanceof BBrush.Image) {
                bImage = ((BBrush.Image)paint).getImage();
            }
            graphics.transform(BTransform.makeScale((double)(this.getWidth() / bImage.getWidth()), (double)(this.getHeight() / bImage.getHeight())));
            graphics.drawImage(bImage, 0.0, 0.0);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        graphics.pop();
    }

    protected void drawCamera(Graphics graphics) {
        BBrush bBrush = this.getCameraRectangleFill();
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.Image) {
            this.drawCameraUserImage(graphics, ((BBrush.Image)paint).getImage());
        } else {
            this.strokeCamera(graphics);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void strokeCamera(Graphics graphics) {
        try {
            graphics.push();
            graphics.useAntiAliasing(true);
            graphics.setPen(this.getCameraOutline());
            if (this.mouseOverWidget) {
                graphics.setBrush(this.getCameraRectangleFillMouseOver());
            } else {
                graphics.setBrush(this.getCameraRectangleFill());
            }
            graphics.fillRect(0.0, 0.0, this.w * 0.8, this.h);
            graphics.strokeRect(0.0, 0.0, this.w * 0.8, this.h);
            if (this.mouseOverWidget) {
                graphics.setBrush(this.getCameraTriangleFillMouseOver());
            } else {
                graphics.setBrush(this.getCameraTriangleFill());
            }
            graphics.fill((IGeom)this.cameraTriangle);
            graphics.stroke((IGeom)this.cameraTriangle);
            graphics.useAntiAliasing(false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_4 = null;
        }
        graphics.pop();
    }

    protected void computeCameraTriangle() {
        double[] dArray = new double[3];
        dArray[0] = this.h * 0.5;
        dArray[2] = this.h;
        this.cameraTriangle = new PolygonGeom(new double[]{this.w * 0.8, this.w, this.w}, dArray, 3);
    }

    public void computePreferredSize() {
        this.setPreferredSize(60.0, 20.0);
    }

    protected String getPtzDialogTitle() {
        String string = VideoDriverLexicon.LEX.getText(PAN_TILT_ZOOM);
        BVideoPtzBinding bVideoPtzBinding = this.getCameraBinding();
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        BObject bObject = ordTarget.get();
        BIVideoCamera bIVideoCamera = (BIVideoCamera)bVideoPtzBinding.getOrd().get(bObject);
        String string2 = bIVideoCamera.getCameraDescription();
        if (string2.trim().length() > 0) {
            string = string + " - " + string2;
        }
        return string;
    }

    protected void showPtzDialog() {
        BWbShell bWbShell;
        OrdTarget ordTarget;
        BVideoPtzBinding bVideoPtzBinding = this.getCameraBinding();
        BOrd bOrd = bVideoPtzBinding.getOrd();
        BIVideoCamera bIVideoCamera = (BIVideoCamera)bOrd.get((ordTarget = (bWbShell = BWbShell.getWbShell((BWidget)this)).getActiveOrdTarget()).get());
        if (bIVideoCamera instanceof BComponent) {
            BLiveVideo bLiveVideo = new BLiveVideo();
            BVideoLayerPane bVideoLayerPane = new BVideoLayerPane();
            bVideoLayerPane.add("liveView", (BValue)bLiveVideo);
            BVideoCameraWidgetDialog bVideoCameraWidgetDialog = new BVideoCameraWidgetDialog(this, this.getPtzDialogTitle(), false, bVideoLayerPane);
            bVideoCameraWidgetDialog.setBoundsCenteredOnOwner();
            bVideoCameraWidgetDialog.open();
            BVideoCameraWidget.hookViewToCamera(bIVideoCamera.asObject(), bLiveVideo);
        }
    }

    public static Binder hookViewToCamera(BObject bObject, BWbView bWbView) {
        BISession bISession;
        ((BComponent)bObject).lease();
        bWbView.fw(403);
        Context context = null;
        try {
            bISession = BOrd.toSession((BObject)bObject);
            if (bISession != null) {
                context = bISession.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bWbView.prime();
        bWbView.relayout();
        bWbView.start();
        bWbView.loadValue(bObject, context);
        if (bWbView.getLoadError() != null) {
            throw new BajaRuntimeException(bWbView.getLoadError());
        }
        bISession = (Binder)bWbView.fw(302);
        bISession.start(((BComponent)bObject).getNavOrd().resolve(), context);
        return bISession;
    }

    public void showActionsMenu(BMouseEvent bMouseEvent) {
        try {
            BVideoPtzBinding bVideoPtzBinding = this.getCameraBinding();
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
            OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
            BObject bObject = ordTarget.get();
            BIVideoCamera bIVideoCamera = (BIVideoCamera)bVideoPtzBinding.getOrd().get(bObject);
            if (bIVideoCamera instanceof BComponent) {
                BMenu bMenu = NavMenuUtil.makeActionsMenu((BWidget)this, (BComponent)((BComponent)bIVideoCamera));
                bMenu.open(bMouseEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            this.setMouseCursor(MouseCursor.hand);
        }
        this.mouseOverWidget = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            this.setMouseCursor(MouseCursor.normal);
        }
        this.mouseOverWidget = false;
        this.repaint();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.getEnabled() && bMouseEvent.getClickCount() >= 1) {
            if ((bMouseEvent.getModifiers() & 0x10) != 0) {
                this.showPtzDialog();
            } else if (bMouseEvent.getClickCount() == 1 && (bMouseEvent.getModifiers() & 4) != 0 && this.getShowActionsMenu()) {
                this.showActionsMenu(bMouseEvent);
            }
        }
    }

    public BVideoPtzDialogPane getPtzVideoPane() {
        Object object;
        BVideoPtzBinding bVideoPtzBinding = this.getCameraBinding();
        BIVideoCamera bIVideoCamera = null;
        BWbShell bWbShell = BWbShell.getWbShell((BWidget)this);
        OrdTarget ordTarget = bWbShell.getActiveOrdTarget();
        BObject bObject = ordTarget.get();
        if (bVideoPtzBinding != null) {
            try {
                object = bVideoPtzBinding.getOrd().get(bObject);
                if (object instanceof BIVideoCamera) {
                    bIVideoCamera = (BIVideoCamera)object;
                } else {
                    System.out.println("Camera widget is not bound to a BIVideoCamera. It is bound to a " + object.getType().getTypeSpec() + ". Are the binding properties configured incorrectly? Please have my program examined.");
                    bIVideoCamera = null;
                }
            }
            catch (Exception exception) {
                bIVideoCamera = null;
            }
        }
        object = new BVideoPtzDialogPane(this, bIVideoCamera);
        return object;
    }

    protected BVideoPtzBinding getCameraBinding() {
        Object[] objectArray;
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoPtzBinding;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoPtzBinding = BVideoCameraWidget.class("[Lcom.tridium.videoDriver.ui.camera.BVideoPtzBinding;", false);
        }
        if ((objectArray = this.getChildren(clazz)) != null && objectArray.length > 0) {
            BVideoPtzBinding bVideoPtzBinding = (BVideoPtzBinding)((Object)objectArray[0]);
            return bVideoPtzBinding;
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cameraTriangle = null;
        this.cameraRectangle = null;
        this.binding = new BVideoPtzCameraWidgetBinding();
    }

    public BVideoCameraWidget() {
        this.this();
        this.setLayout(BLayout.makeAbs((double)1.0, (double)1.0, (double)60.0, (double)20.0));
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$camera$BVideoCameraWidget;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$camera$BVideoCameraWidget = BVideoCameraWidget.class("[Lcom.tridium.videoDriver.ui.camera.BVideoCameraWidget;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

