/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm.monitoring;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ui.UiEnv;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.alarm.monitoring.BAlarmTypeEnum;
import com.tridium.videoDriver.ui.alarm.monitoring.BConsoleRecipientMonitor;
import com.tridium.videoDriver.ui.alarm.monitoring.BMonitorNotificationHandler;
import com.tridium.videoDriver.ui.alarm.monitoring.BVideoAlarmConsoleDialog;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.user.BUser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmNotificationHandler
extends BMonitorNotificationHandler {
    public static final Type TYPE;
    private static double DIALOG_SCALE_FACTOR;
    private static final double DIALOG_ASPECT_RATIO = 1.618;
    protected BConsoleRecipientMonitor crm;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$alarm$monitoring$BAlarmNotificationHandler;

    public Type getType() {
        return TYPE;
    }

    protected static boolean isVideoAlarm(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord == null) {
            return false;
        }
        String string = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
        String string2 = bAlarmRecord.getAlarmData().gets("cameraHandleOrd", null);
        boolean bl = false;
        if (string != null || string2 != null) {
            bl = true;
        }
        return bl;
    }

    protected static boolean isVideoDriverAvailable() {
        return BConsoleRecipientMonitor.videoDriverAvailable();
    }

    protected boolean monitoringAnyAlarm() {
        return this.crm.getAlarmTypeToMonitor().equals((Object)BAlarmTypeEnum.allAlarms);
    }

    protected boolean monitoringOnlyVideoAlarms() {
        boolean bl = false;
        if (this.crm.getAlarmTypeToMonitor().equals((Object)BAlarmTypeEnum.videoAlarms) && BAlarmNotificationHandler.isVideoDriverAvailable() && BAlarmNotificationHandler.isVideoAlarm(this.crm.getLastAlarmRecord())) {
            bl = true;
        }
        return bl;
    }

    protected boolean alarmTransitionStateValid() {
        BAlarmRecord bAlarmRecord = this.crm.getLastAlarmRecord();
        if (bAlarmRecord == null) {
            return false;
        }
        BAlarmTransitionBits bAlarmTransitionBits = this.crm.getAlarmState();
        return bAlarmTransitionBits.includes(bAlarmRecord.getSourceState());
    }

    protected boolean alarmAckStateValid() {
        BAlarmRecord bAlarmRecord = this.crm.getLastAlarmRecord();
        boolean bl = false;
        if (bAlarmRecord != null && bAlarmRecord.getAckState().equals((Object)this.crm.getAckState())) {
            bl = true;
        }
        return bl;
    }

    protected boolean isValidAlarmForNotification(BAlarmRecord bAlarmRecord) {
        boolean bl = false;
        if (this.alarmTransitionStateValid() && this.alarmAckStateValid() && (this.monitoringAnyAlarm() || this.monitoringOnlyVideoAlarms())) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    protected void processNotification() {
        String string;
        BUser bUser = this.getUser();
        if (bUser == null) {
            return;
        }
        String string2 = this.getUser().getUsername();
        if (!string2.equals(string = ((BUser)this.monitor.getParent()).getUsername())) {
            return;
        }
        this.crm = (BConsoleRecipientMonitor)this.monitor;
        this.crm.lease();
        BAlarmRecord bAlarmRecord = this.crm.getLastAlarmRecord();
        if (bAlarmRecord == null) {
            return;
        }
        if (this.isValidAlarmForNotification(bAlarmRecord)) {
            this.launchNotification();
        }
    }

    protected BAlarmConsole getAlarmConsole() {
        switch (this.crm.getAlarmConsoleType().getOrdinal()) {
            case 1: {
                return new BVideoAlarmConsole();
            }
        }
        return new BAlarmConsole();
    }

    protected void launchNotification() {
        BObject bObject = this.crm.getMonitorSource();
        if (bObject == null) {
            return;
        }
        BComponent bComponent = bObject.asComponent();
        bComponent.lease();
        if (!bComponent.getType().is(BConsoleRecipient.TYPE)) {
            return;
        }
        BAlarmConsole bAlarmConsole = this.getAlarmConsole();
        if (this.crm.dialog == null || !this.crm.dialog.isShowing()) {
            if (this.crm.dialog == null) {
                this.crm.dialog = new BVideoAlarmConsoleDialog(this.shell, "", false, (BWidget)new BNullWidget());
            }
            this.openDialog();
        } else {
            if (this.crm.console.getClass().equals(bAlarmConsole.getClass())) {
                return;
            }
            this.crm.dialog.setContent((BWidget)new BNullWidget());
        }
        this.crm.console = bAlarmConsole;
        this.crm.dialog.setContent((BWidget)this.crm.console);
        BFoxSession bFoxSession = this.getFoxSession();
        String string = bFoxSession.getHost().toString();
        String string2 = bFoxSession.getStationName();
        String string3 = String.valueOf(bFoxSession.getPort());
        String string4 = this.getLexicon().getText("alarmPopup.title", new Object[]{string, string2, string3, bComponent.toDisplayPathString(this.cx)});
        this.crm.dialog.setTitle(string4);
        this.crm.console.loadValue((BObject)bComponent);
    }

    protected void openDialog() {
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds(null);
        double d = iRectGeom.width();
        double d2 = iRectGeom.height();
        DIALOG_SCALE_FACTOR = (double)this.crm.getDialogScaleFactor().getOrdinal() / 100.0;
        double d3 = DIALOG_SCALE_FACTOR * d;
        double d4 = DIALOG_SCALE_FACTOR * d2;
        d3 = 1.618 * d4;
        if (d3 > iRectGeom.width()) {
            d3 = iRectGeom.width();
        }
        if (d4 > iRectGeom.height()) {
            d4 = iRectGeom.height();
        }
        double d5 = iRectGeom.x() + (iRectGeom.width() - d3) / (double)2;
        double d6 = iRectGeom.y() + (iRectGeom.height() - d4) / (double)2;
        this.crm.dialog.open(d5, d6, d3, d4);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$alarm$monitoring$BAlarmNotificationHandler;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$alarm$monitoring$BAlarmNotificationHandler = BAlarmNotificationHandler.class("[Lcom.tridium.videoDriver.ui.alarm.monitoring.BAlarmNotificationHandler;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DIALOG_SCALE_FACTOR = 1.0;
    }
}

