/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.ui.Binder;
import com.tridium.videoDriver.VideoDriverLexicon;
import com.tridium.videoDriver.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleController;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleLayoutEnum;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.workbench.view.BWbView;

public class LayoutController {
    private static Log log = Log.getLog((String)"videoDriver.LayoutController");
    private static final double DIVIDER_POSITION = 35.0;
    protected AlarmConsoleController alarmConsoleController;
    protected BVideoAlarmConsole console;
    protected BWidget alarmTablePane;
    protected BWidget instructionsPane;
    protected BWidget liveVideoPane;
    protected BWidget videoPlaybackPane;
    protected BWbView liveVideo;
    protected BWbView videoPlayback;
    protected Worker backgroundWorker;
    protected Queue backgroundQueue;

    public static LayoutController make(AlarmConsoleController alarmConsoleController) {
        return new LayoutController(alarmConsoleController);
    }

    static BWidget makeSplitPane(BWidget bWidget, BWidget bWidget2, BOrientation bOrientation) {
        BSplitPane bSplitPane = new BSplitPane(bWidget, bWidget2);
        bSplitPane.setOrientation(bOrientation);
        return bSplitPane;
    }

    static BWidget makeTwoWidgetPaneVertical(BWidget bWidget, BWidget bWidget2, double d) {
        BSplitPane bSplitPane = (BSplitPane)LayoutController.makeTwoWidgetPaneVertical(bWidget, bWidget2);
        bSplitPane.setDividerPosition(d);
        return bSplitPane;
    }

    static BWidget makeTwoWidgetPaneVertical(BWidget bWidget, BWidget bWidget2) {
        return LayoutController.makeSplitPane(bWidget, bWidget2, BOrientation.vertical);
    }

    static BWidget makeTwoWidgetPaneHorizontal(BWidget bWidget, BWidget bWidget2) {
        return LayoutController.makeSplitPane(bWidget, bWidget2, BOrientation.horizontal);
    }

    static BWidget makeThreeWidgetPane(BWidget bWidget, BWidget bWidget2, BWidget bWidget3, double d) {
        BSplitPane bSplitPane = (BSplitPane)LayoutController.makeThreeWidgetPane(bWidget, bWidget2, bWidget3);
        bSplitPane.setDividerPosition(d);
        return bSplitPane;
    }

    static BWidget makeThreeWidgetPane(BWidget bWidget, BWidget bWidget2, BWidget bWidget3) {
        BWidget bWidget4 = LayoutController.makeTwoWidgetPaneHorizontal(bWidget2, bWidget3);
        BWidget bWidget5 = LayoutController.makeTwoWidgetPaneVertical(bWidget, bWidget4);
        return bWidget5;
    }

    static BWidget makeFourWidgetPane(BWidget bWidget, BWidget bWidget2, BWidget bWidget3, BWidget bWidget4) {
        BWidget bWidget5 = LayoutController.makeTwoWidgetPaneHorizontal(bWidget, bWidget2);
        BWidget bWidget6 = LayoutController.makeTwoWidgetPaneHorizontal(bWidget3, bWidget4);
        BWidget bWidget7 = LayoutController.makeTwoWidgetPaneVertical(bWidget5, bWidget6);
        return bWidget7;
    }

    private final void setVideoPanesVisibility(boolean bl, boolean bl2) {
        this.liveVideoPane.setVisible(bl);
        this.videoPlaybackPane.setVisible(bl2);
    }

    public void layout() {
        BAlarmRecord bAlarmRecord;
        BVideoAlarmConsoleOptions bVideoAlarmConsoleOptions = this.alarmConsoleController.getVideoAlarmConsoleOptions();
        if (bVideoAlarmConsoleOptions == null) {
            log.warning("No video alarm console options found. Defaulting to normal layout");
            return;
        }
        this.cacheAndUnparentWidgets();
        BVideoAlarmConsoleLayoutEnum bVideoAlarmConsoleLayoutEnum = bVideoAlarmConsoleOptions.getLayout();
        this.console.setContent((BWidget)new BNullWidget());
        if (!bVideoAlarmConsoleOptions.getEnabled()) {
            if (this.console.options.getViewInstructions()) {
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.instructionsPane));
            } else {
                this.console.setContent(this.alarmTablePane);
            }
            return;
        }
        switch (bVideoAlarmConsoleLayoutEnum.getOrdinal()) {
            case 0: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(this.alarmTablePane);
                break;
            }
            case 6: {
                this.setVideoPanesVisibility(true, false);
                this.console.setContent(this.liveVideoPane);
                break;
            }
            case 7: {
                this.setVideoPanesVisibility(false, true);
                this.console.setContent(this.videoPlaybackPane);
                break;
            }
            case 1: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.instructionsPane));
                break;
            }
            case 2: {
                this.setVideoPanesVisibility(true, false);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.liveVideoPane, 35.0));
                break;
            }
            case 3: {
                this.setVideoPanesVisibility(false, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.alarmTablePane, this.videoPlaybackPane, 35.0));
                break;
            }
            case 4: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeThreeWidgetPane(this.alarmTablePane, this.liveVideoPane, this.videoPlaybackPane, 35.0));
                break;
            }
            case 5: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeFourWidgetPane(this.alarmTablePane, this.instructionsPane, this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            case 8: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneHorizontal(this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            case 9: {
                this.setVideoPanesVisibility(true, true);
                this.console.setContent(LayoutController.makeTwoWidgetPaneVertical(this.liveVideoPane, this.videoPlaybackPane));
                break;
            }
            default: {
                this.setVideoPanesVisibility(false, false);
                this.console.setContent(this.alarmTablePane);
            }
        }
        BComponent bComponent = this.alarmConsoleController.getAlarmMonitor();
        if (bComponent == null) {
            return;
        }
        BValue bValue = bComponent.get("lastValueSignaled");
        if (bValue instanceof BAlarmRecord && (bAlarmRecord = (BAlarmRecord)bValue) != null) {
            this.alarmConsoleController.processAlarm(bAlarmRecord, true);
        }
    }

    private final void cacheAndUnparentWidgets() {
        if (this.alarmTablePane == null) {
            this.alarmTablePane = this.getAlarmTablePane();
        }
        this.unparent(this.alarmTablePane);
        if (this.instructionsPane == null) {
            this.instructionsPane = this.getInstructionsPane();
        }
        this.unparent(this.instructionsPane);
        if (this.liveVideoPane == null) {
            this.liveVideoPane = this.makeLiveVideoPane();
        } else {
            this.unparent(this.liveVideoPane);
        }
        if (this.videoPlaybackPane == null) {
            this.videoPlaybackPane = this.makeVideoPlaybackPane();
        } else {
            this.unparent(this.videoPlaybackPane);
        }
    }

    private final void unparent(BWidget bWidget) {
        BWidget bWidget2 = bWidget.getParentWidget();
        if (bWidget2 != null) {
            if (bWidget2 instanceof BWbView) {
                BWbView bWbView = (BWbView)bWidget2;
                bWbView.setContent((BWidget)new BNullWidget());
            } else if (bWidget2 instanceof BSplitPane) {
                BSplitPane bSplitPane = (BSplitPane)bWidget2;
                bSplitPane.setWidget1((BWidget)new BNullWidget());
                bSplitPane.setWidget2((BWidget)new BNullWidget());
            }
        }
    }

    protected BWidget getAlarmTablePane() {
        if (this.console.options.getViewInstructions()) {
            BSplitPane bSplitPane = (BSplitPane)this.console.getContent();
            BWidget bWidget = bSplitPane.getWidget1();
            return bWidget;
        }
        return this.console.getContent();
    }

    protected BWidget getInstructionsPane() {
        return this.console.getInstructionsPane();
    }

    protected BWidget makeLiveVideoPane() {
        this.liveVideo = new BLiveVideo();
        return new BTitlePane("Live Video", (BWidget)this.liveVideo);
    }

    protected BWidget makeVideoPlaybackPane() {
        this.videoPlayback = new BVideoPlayback();
        return new BTitlePane("Video Playback", (BWidget)this.videoPlayback);
    }

    protected void loadVideoAlarm(final BAlarmRecord bAlarmRecord) {
        BOrd bOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.console.getConsoleRecipient(), bAlarmRecord);
        if (bOrd == null || bOrd.isNull()) {
            return;
        }
        final BComponent bComponent = bOrd.get((BObject)this.console.getConsoleRecipient()).asComponent();
        if (bComponent == null) {
            return;
        }
        bComponent.lease();
        Runnable runnable = new Runnable(){

            public final void run() {
                LayoutController.this.loadVideoPane(LayoutController.this.liveVideoPane, bAlarmRecord, bComponent, true);
            }
        };
        Runnable runnable2 = new Runnable(){

            public final void run() {
                LayoutController.this.loadVideoPane(LayoutController.this.videoPlaybackPane, bAlarmRecord, bComponent, false);
            }
        };
        if (this.liveVideoPane.isVisible()) {
            this.backgroundQueue.enqueue((Object)runnable);
        }
        if (this.videoPlaybackPane.isVisible()) {
            this.backgroundQueue.enqueue((Object)runnable2);
        }
    }

    protected void deactivate() {
        if (this.liveVideo != null) {
            LayoutController.deactivateView(this.liveVideo);
        }
        if (this.videoPlayback != null) {
            LayoutController.deactivateView(this.videoPlayback);
        }
        if (this.backgroundWorker != null) {
            this.backgroundWorker.stop();
        }
        this.backgroundQueue.clear();
    }

    private final void loadVideoPane(BWidget bWidget, BAlarmRecord bAlarmRecord, BComponent bComponent, boolean bl) {
        BTitlePane bTitlePane = (BTitlePane)bWidget;
        BBorderPane bBorderPane = (BBorderPane)bTitlePane.getCenter();
        BEdgePane bEdgePane = (BEdgePane)bBorderPane.getContent();
        BLiveVideo bLiveVideo = null;
        if (bl) {
            if (this.liveVideo != null) {
                LayoutController.deactivateView(this.liveVideo);
            }
            this.liveVideo = new BLiveVideo();
            bLiveVideo = this.liveVideo;
            bEdgePane.setCenter((BWidget)this.liveVideo);
        } else {
            BAbsTime bAbsTime = (BAbsTime)bAlarmRecord.getAlarmData().get("videoEventTimestamp");
            String string = LayoutController.toSummaryString(bAlarmRecord, bAbsTime);
            if (bAbsTime == null || bAbsTime.isNull()) {
                bAbsTime = bAlarmRecord.getTimestamp();
                string = VideoDriverLexicon.LEX.getText("AlarmRecallTimeApproximate", new Object[]{string});
            }
            if (this.videoPlayback != null) {
                LayoutController.deactivateView(this.videoPlayback);
            }
            this.videoPlayback = new BVideoPlayback(string, bAbsTime, false);
            bLiveVideo = this.videoPlayback;
            bEdgePane.setCenter((BWidget)bLiveVideo);
        }
        LayoutController.hookViewToCamera(bLiveVideo, bComponent);
    }

    private static final void deactivateView(BWbView bWbView) {
        bWbView.fw(402);
        bWbView.deactivated();
    }

    private static final String toSummaryString(BAlarmRecord bAlarmRecord, BAbsTime bAbsTime) {
        StringBuffer stringBuffer = new StringBuffer(bAlarmRecord.getAlarmData().gets("msgText", ""));
        if (stringBuffer.toString().trim().length() > 0) {
            stringBuffer.append(" <-> ");
        }
        if (bAbsTime == null) {
            stringBuffer.append(bAlarmRecord.getTimestamp().toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        } else {
            stringBuffer.append(bAbsTime.toString((Context)BAlarmRecord.TIMESTAMP_FACETS));
        }
        stringBuffer.append(": (").append(bAlarmRecord.getAckState()).append(':').append(bAlarmRecord.getSourceState()).append(") ");
        return stringBuffer.toString();
    }

    private static final void hookViewToCamera(BWbView bWbView, BComponent bComponent) {
        BISession bISession;
        if (bWbView == null) {
            return;
        }
        bComponent.lease();
        bWbView.fw(403);
        Context context = null;
        try {
            bISession = BOrd.toSession((BObject)bComponent);
            if (bISession != null) {
                context = bISession.getSessionContext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bWbView.prime();
        bWbView.relayout();
        bWbView.start();
        bWbView.loadValue((BObject)bComponent, context);
        if (bWbView.getLoadError() != null) {
            throw new BajaRuntimeException(bWbView.getLoadError());
        }
        bISession = (Binder)bWbView.fw(302);
        bISession.start(bComponent.getNavOrd().resolve(), context);
    }

    private LayoutController(AlarmConsoleController alarmConsoleController) {
        this.alarmConsoleController = alarmConsoleController;
        this.console = alarmConsoleController.console;
        if (this.backgroundQueue == null) {
            this.backgroundQueue = new Queue();
            this.backgroundWorker = new Worker((Worker.ITodo)this.backgroundQueue);
            this.backgroundWorker.start("LayoutController.worker");
        }
    }
}

