/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.ui.BAlarmConsole;
import com.tridium.alarm.ui.ConsoleTableModel;
import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.videoDriver.ui.alarm.AlarmConsoleController;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmActionEnum;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleSettingPropertySheet;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.gx.BImage;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableSelection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoAlarmConsole
extends BAlarmConsole {
    public static final Type TYPE;
    private Command popupSettingsCommand;
    private AlarmConsoleController alarmConsoleController;
    private int lastRowSelected;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$alarm$BVideoAlarmConsole;

    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        super.deactivated();
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.deactivate();
        }
    }

    public BGridPane makeToolBar() {
        BGridPane bGridPane = super.makeToolBar();
        BWidget[] bWidgetArray = bGridPane.getChildWidgets();
        int n = 0;
        while (n < bWidgetArray.length) {
            bGridPane.remove((BComplex)bWidgetArray[n]);
            ++n;
        }
        BGridPane bGridPane2 = new BGridPane(bWidgetArray.length + 1, bWidgetArray);
        this.popupSettingsCommand = new PopupSettingsCommand((BWidget)this, "Popup Settings");
        bGridPane2.add("settings", (BValue)new BButton(this.popupSettingsCommand, true, true));
        return bGridPane2;
    }

    protected void loadComplete() {
        super.loadComplete();
        this.performLayout();
    }

    protected void performLayout() {
        if (this.alarmConsoleController == null) {
            this.alarmConsoleController = new AlarmConsoleController(this);
        }
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.layout();
        }
    }

    public void processAlarm(BAlarmRecord bAlarmRecord) {
        super.processAlarm(bAlarmRecord);
        if (this.alarmConsoleController != null) {
            this.alarmConsoleController.processAlarm(bAlarmRecord, false);
        }
    }

    protected void ackAlarms(BAlarmRecord[] bAlarmRecordArray) {
        super.ackAlarms(bAlarmRecordArray);
        BVideoAlarmConsoleOptions bVideoAlarmConsoleOptions = this.alarmConsoleController.getVideoAlarmConsoleOptions();
        if (bVideoAlarmConsoleOptions == null || bVideoAlarmConsoleOptions.getActionOnAlarmAck().equals((Object)BVideoAlarmActionEnum.noAction)) {
            return;
        }
        BAlarmRecord bAlarmRecord = this.alarmConsoleController.getNewestUnackedOffnormalAlarm();
        if (bAlarmRecord != null) {
            this.alarmConsoleController.processAlarm(bAlarmRecord, false);
        }
    }

    BWidget getInstructionsPane() {
        BWidget bWidget = this.instructions.getParentWidget();
        while (!bWidget.getType().is(BGridPane.TYPE)) {
            bWidget = bWidget.getParentWidget();
        }
        return bWidget;
    }

    BComponent getConsoleRecipient() {
        return this.recipient;
    }

    SourceTableModel getSourceTableModel() {
        return this.sourceModel;
    }

    protected BAlarmConsole.Controller getController() {
        return new AlarmTableController();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastRowSelected = -1;
    }

    public BVideoAlarmConsole() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$alarm$BVideoAlarmConsole;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$alarm$BVideoAlarmConsole = BVideoAlarmConsole.class("[Lcom.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class PopupSettingsCommand
    extends Command {
        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"gears.png"));
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BVideoAlarmConsole.this.alarmConsoleController != null) {
                BComponent bComponent = BVideoAlarmConsole.this.alarmConsoleController.getAlarmMonitor();
                if (bComponent != null) {
                    BVideoAlarmConsoleSettingPropertySheet bVideoAlarmConsoleSettingPropertySheet = new BVideoAlarmConsoleSettingPropertySheet();
                    BDialog bDialog = new BDialog(this.getOwner(), BVideoAlarmConsole.this.getTitle(), true, (BWidget)bVideoAlarmConsoleSettingPropertySheet);
                    bVideoAlarmConsoleSettingPropertySheet.loadValue((BObject)bComponent, BVideoAlarmConsole.this.getCurrentContext());
                    bDialog.setBoundsCenteredOnOwner();
                    bDialog.open();
                } else {
                    BDialog.message(null, (Object)"Popup settings could not be located for the user.\nPlease make sure the Video Alarm Configuration service is present in the station.");
                }
            }
            return super.doInvoke();
        }

        public PopupSettingsCommand(BWidget bWidget, String string) {
            super(bWidget, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AlarmTableController
    extends BAlarmConsole.Controller {
        public void keyReleased(BKeyEvent bKeyEvent) {
            super.keyReleased(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 38 || bKeyEvent.getKeyCode() == 40) {
                this.loadSelectedAlarm();
            }
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            BVideoAlarmConsoleOptions bVideoAlarmConsoleOptions = BVideoAlarmConsole.this.alarmConsoleController.getVideoAlarmConsoleOptions();
            BVideoAlarmActionEnum bVideoAlarmActionEnum = bVideoAlarmConsoleOptions.getActionOnAlarmSelection();
            if (bVideoAlarmActionEnum.equals((Object)BVideoAlarmActionEnum.loadVideo)) {
                this.loadSelectedAlarm();
            }
        }

        private final void loadSelectedAlarm() {
            TableSelection tableSelection = this.getTable().getSelection();
            if (tableSelection.getRows().length == 1) {
                int n = tableSelection.getRow();
                ConsoleTableModel consoleTableModel = (ConsoleTableModel)((DynamicTableModel)this.getTable().getModel()).getRootModel();
                BAlarmRecord bAlarmRecord = consoleTableModel.getRecord(n);
                if (BVideoAlarmConsole.this.alarmConsoleController != null && (BVideoAlarmConsole.this.lastRowSelected == -1 || n != BVideoAlarmConsole.this.lastRowSelected)) {
                    BVideoAlarmConsole.this.lastRowSelected = n;
                    BVideoAlarmConsole.this.alarmConsoleController.processAlarm(bAlarmRecord, true);
                }
            }
        }

        protected AlarmTableController() {
            super((BAlarmConsole)BVideoAlarmConsole.this);
        }
    }
}

