/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.alarm;

import com.tridium.alarm.ui.SourceTableModel;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.videoDriver.alarm.AlarmConsoleExt;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmActionEnum;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsole;
import com.tridium.videoDriver.ui.alarm.BVideoAlarmConsoleOptions;
import com.tridium.videoDriver.ui.alarm.LayoutController;
import com.tridium.videoDriver.ui.alarm.monitoring.BConsoleRecipientMonitor;
import com.tridium.videoDriver.ui.display.BIVideoDisplayLayout;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.log.Log;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BObject;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class AlarmConsoleController {
    private static Log log = Log.getLog((String)"videoDriver.AlarmControlController");
    protected BVideoAlarmConsole console;
    protected LayoutController layoutController;

    void processAlarm(BAlarmRecord bAlarmRecord, boolean bl) {
        if ((this.isValidVideoAlarm(bAlarmRecord) || bl) && this.layoutController != null) {
            this.layoutController.loadVideoAlarm(bAlarmRecord);
        }
    }

    protected void sendAlarmToVideoDisplay(final BAlarmRecord bAlarmRecord) {
        new Thread(){

            public final void run() {
                BIVideoCamera bIVideoCamera;
                BIVideoDisplay[] bIVideoDisplayArray;
                BComponent bComponent = AlarmConsoleController.this.getVideoCameraForAlarm(bAlarmRecord);
                if (bComponent != null && bComponent instanceof BIVideoCamera && (bIVideoDisplayArray = (bIVideoCamera = (BIVideoCamera)bComponent).getDvr().getDisplayExt().getAllDisplays()).length > 0) {
                    BIVideoDisplay bIVideoDisplay = bIVideoDisplayArray[0];
                    if (bIVideoDisplay == null) {
                        return;
                    }
                    BFrozenEnum bFrozenEnum = bIVideoDisplay.getVideoDisplayMultistream().getLayout();
                    if (bFrozenEnum instanceof BIVideoDisplayLayout) {
                        BIVideoDisplayLayout bIVideoDisplayLayout = ((BIVideoDisplayLayout)bFrozenEnum).getSingleSegmentLayout();
                        bIVideoDisplay.switchToLayout(bIVideoDisplayLayout);
                        BOrd bOrd = bComponent.getHandleOrd();
                        bIVideoDisplay.mapCamerasToLayout(new BOrd[]{bOrd}, bIVideoDisplayLayout);
                        BAbsTime bAbsTime = bAlarmRecord.getTimestamp();
                        bIVideoDisplay.gotoPlaybackTime(bAbsTime);
                    }
                }
            }
        }.start();
    }

    protected boolean isValidVideoAlarm(BAlarmRecord bAlarmRecord) {
        boolean bl = false;
        if (this.isVideoAlarm(bAlarmRecord) && this.isVideoAlarmStateValid(bAlarmRecord) && this.isVideoAlarmLoadable(bAlarmRecord)) {
            bl = true;
        }
        return bl;
    }

    protected boolean isVideoAlarm(BAlarmRecord bAlarmRecord) {
        String string = bAlarmRecord.getAlarmData().gets("cameraOrd", null);
        String string2 = bAlarmRecord.getAlarmData().gets("cameraHandleOrd", null);
        boolean bl = false;
        if (string == null && string2 == null) {
            bl = true;
        }
        return bl ^ true;
    }

    protected boolean isVideoAlarmStateValid(BAlarmRecord bAlarmRecord) {
        BComponent bComponent = this.getAlarmMonitor();
        if (bComponent == null) {
            return false;
        }
        BAlarmTransitionBits bAlarmTransitionBits = (BAlarmTransitionBits)bComponent.get("alarmState");
        BAckState bAckState = (BAckState)bComponent.get("ackState");
        boolean bl = false;
        if (bAlarmTransitionBits.includes(bAlarmRecord.getSourceState()) && bAlarmRecord.getAckState().equals((Object)bAckState)) {
            bl = true;
        }
        return bl;
    }

    protected boolean isVideoAlarmLoadable(BAlarmRecord bAlarmRecord) {
        BVideoAlarmConsoleOptions bVideoAlarmConsoleOptions = this.getVideoAlarmConsoleOptions();
        boolean bl = false;
        if (bVideoAlarmConsoleOptions != null && bVideoAlarmConsoleOptions.getActionOnNewAlarm().equals((Object)BVideoAlarmActionEnum.loadVideo)) {
            bl = true;
        }
        boolean bl2 = bl;
        return bl2;
    }

    protected void deactivate() {
        if (this.layoutController != null) {
            this.layoutController.deactivate();
        }
    }

    protected void layout() {
        if (this.layoutController == null) {
            this.layoutController = LayoutController.make(this);
        }
        this.layoutController.layout();
    }

    BAlarmRecord getNewestUnackedOffnormalAlarm() {
        SourceTableModel sourceTableModel = this.console.getSourceTableModel();
        BAbsTime bAbsTime = BAbsTime.DEFAULT;
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        int n = sourceTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            BAlarmRecord bAlarmRecord2 = sourceTableModel.getRecord(n2);
            if (bAlarmRecord2.getTimestamp().isAfter(bAbsTime)) {
                bAbsTime = bAlarmRecord2.getTimestamp();
                if (!(bAlarmRecord2.isNormal() || bAlarmRecord2.isAcknowledged() || bAlarmRecord2.isAckPending())) {
                    bAlarmRecord = bAlarmRecord2;
                }
            }
            ++n2;
        }
        return bAlarmRecord;
    }

    public BComponent getVideoCameraForAlarm(BAlarmRecord bAlarmRecord) {
        BComponent bComponent;
        BOrd bOrd = AlarmConsoleExt.resolveVideoCameraObject((BObject)this.console.getConsoleRecipient(), bAlarmRecord);
        if (bOrd != null && !bOrd.isNull() && (bComponent = bOrd.get((BObject)this.console.getConsoleRecipient()).asComponent()) != null) {
            bComponent.lease();
            return bComponent;
        }
        return null;
    }

    protected BComponent getAlarmMonitor() {
        BUser bUser = this.getUserForSession();
        bUser.lease(10);
        BComponent bComponent = (BComponent)bUser.getMixIn(BConsoleRecipientMonitor.TYPE);
        if (bComponent == null) {
            log.error("No alarm monitor detected for user");
            return null;
        }
        bComponent.lease();
        return bComponent;
    }

    protected BVideoAlarmConsoleOptions getVideoAlarmConsoleOptions() {
        BUser bUser = this.getUserForSession();
        bUser.lease(10);
        BVideoAlarmConsoleOptions bVideoAlarmConsoleOptions = (BVideoAlarmConsoleOptions)bUser.getMixIn(BVideoAlarmConsoleOptions.TYPE);
        if (bVideoAlarmConsoleOptions == null) {
            log.error("No video alarm console options detected for user");
            return null;
        }
        bVideoAlarmConsoleOptions.lease();
        return bVideoAlarmConsoleOptions;
    }

    protected BUser getUserForSession() {
        BFoxSession bFoxSession = this.getFoxSession();
        return this.getUser(bFoxSession.getUsername(), bFoxSession);
    }

    protected BFoxSession getFoxSession() {
        BISession bISession = this.console.getCurrentValueSession();
        if (!bISession.getType().is(BFoxSession.TYPE)) {
            return null;
        }
        BFoxSession bFoxSession = (BFoxSession)bISession;
        return bFoxSession;
    }

    protected BUser getUser(String string, BFoxSession bFoxSession) {
        BUserService bUserService = (BUserService)bFoxSession.getService(BUserService.TYPE);
        bUserService.lease(10);
        BUser bUser = bUserService.getUser(bFoxSession.getUsername());
        return bUser;
    }

    protected AlarmConsoleController(BVideoAlarmConsole bVideoAlarmConsole) {
        this.console = bVideoAlarmConsole;
    }
}

