/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.camera.control.BPlaybackControlInfo;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.IVideoImagePainter;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoMultistreamDecoder;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BVideoPlayer
extends BTransferWidget
implements BIVideoPlayer {
    public static final Property showTimeIndex = BVideoPlayer.newProperty((int)0, (boolean)true, null);
    public static final Property throttleRefreshRate = BVideoPlayer.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)25), (String)"max", (BIDataValue)BInteger.make((int)1000), (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property videoStreamFox = BVideoPlayer.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    public static final Property backgroundColor = BVideoPlayer.newProperty((int)0, (BValue)BColor.black, null);
    public static final Property aspectRatio = BVideoPlayer.newProperty((int)0, (BValue)BVideoAspectRatioEnum.inherit_from_stream, null);
    public static final Property resolution = BVideoPlayer.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    public static final Property frameRate = BVideoPlayer.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    public static final Property compression = BVideoPlayer.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    public static final Property streamFacets = BVideoPlayer.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Action changePlaybackControl = BVideoPlayer.newAction((int)0, (BValue)new BPlaybackControlInfo(), null);
    public static final Topic reloadVideo = BVideoPlayer.newTopic((int)0, null);
    public static final Type TYPE;
    static int vidId;
    protected static BLabel messageLabel;
    protected static BBorderPane messageLabelInsideBorder;
    public static final BBrush TIME_INDEX_TEXT_BRUSH;
    public static final BBrush TIME_INDEX_BACKGROUND_BRUSH;
    public static final BBrush MESSAGE_TEXT_BRUSH;
    public static final BBrush MESSAGE_BACKGROUND_BRUSH;
    protected static final BIcon icon;
    public static final BImage DISCONNECTED_IMAGE;
    public static final String WIDEST_CONNECTING_MESSAGE;
    public static final String TRIMMED_ESTABLISHING_CONNECTION_MESSAGE;
    public int myId;
    protected BLabel timeIndexLabel;
    protected BBorderPane timeIndexLabelInsideBorder;
    protected BVideoMultistreamPaneForView multistreamPaneForView;
    protected BTransferWidget hostTransferWidget;
    protected BPlaybackParams playBackParams;
    protected long lastUpdateTicks;
    protected IVideoDecoder videoDecoder;
    protected String message;
    protected String cameraDescription;
    protected BImage mostRecentImage;
    protected BAbsTime currentTimeIndex;
    static /* synthetic */ Class class$com$tridium$videoDriver$ui$BVideoPlayer;

    public boolean getShowTimeIndex() {
        return this.getBoolean(showTimeIndex);
    }

    public void setShowTimeIndex(boolean bl) {
        this.setBoolean(showTimeIndex, bl, null);
    }

    public int getThrottleRefreshRate() {
        return this.getInt(throttleRefreshRate);
    }

    public void setThrottleRefreshRate(int n) {
        this.setInt(throttleRefreshRate, n, null);
    }

    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    public void setVideoStreamFox(BFoxVideoStreamEnum bFoxVideoStreamEnum) {
        this.set(videoStreamFox, (BValue)bFoxVideoStreamEnum, null);
    }

    public BColor getBackgroundColor() {
        return (BColor)this.get(backgroundColor);
    }

    public void setBackgroundColor(BColor bColor) {
        this.set(backgroundColor, (BValue)bColor, null);
    }

    public BVideoAspectRatioEnum getAspectRatio() {
        return (BVideoAspectRatioEnum)this.get(aspectRatio);
    }

    public void setAspectRatio(BVideoAspectRatioEnum bVideoAspectRatioEnum) {
        this.set(aspectRatio, (BValue)bVideoAspectRatioEnum, null);
    }

    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    public void setResolution(BVideoResolutionEnum bVideoResolutionEnum) {
        this.set(resolution, (BValue)bVideoResolutionEnum, null);
    }

    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    public void setFrameRate(BVideoFrameRateEnum bVideoFrameRateEnum) {
        this.set(frameRate, (BValue)bVideoFrameRateEnum, null);
    }

    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    public void setCompression(BVideoCompressionEnum bVideoCompressionEnum) {
        this.set(compression, (BValue)bVideoCompressionEnum, null);
    }

    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    public void setStreamFacets(BFacets bFacets) {
        this.set(streamFacets, (BValue)bFacets, null);
    }

    public void changePlaybackControl(BPlaybackControlInfo bPlaybackControlInfo) {
        this.invoke(changePlaybackControl, (BValue)bPlaybackControlInfo, null);
    }

    public void fireReloadVideo(BPlaybackParams bPlaybackParams) {
        this.fire(reloadVideo, (BValue)bPlaybackParams, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setVideoDecoder(IVideoDecoder iVideoDecoder) {
        this.videoDecoder = iVideoDecoder;
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoDecoder;
    }

    public void updateVideoFrame(VidFrame vidFrame) {
        if (this.videoDecoder != null) {
            BImage bImage = vidFrame.image;
            if (this.videoDecoder instanceof IVideoImagePainter || bImage != null && bImage != this.mostRecentImage) {
                long l;
                if (bImage != null && bImage != this.mostRecentImage) {
                    this.mostRecentImage = bImage;
                }
                if ((l = Clock.ticks()) - this.lastUpdateTicks >= (long)this.getThrottleRefreshRate()) {
                    this.repaint();
                    this.lastUpdateTicks = l;
                }
                this.currentTimeIndex = vidFrame.timeIndex;
                this.getPlaybackParams().setTimeIndex(this.currentTimeIndex);
            }
        }
    }

    public BPlaybackParams getPlaybackParams() {
        this.playBackParams.setResolution(this.getResolution());
        this.playBackParams.setFrameRate(this.getFrameRate());
        this.playBackParams.setCompression(this.getCompression());
        this.playBackParams.setVideoFacets(BFacets.make((BFacets)this.playBackParams.getVideoFacets(), (BFacets)this.getStreamFacets()));
        return this.playBackParams;
    }

    public Topic getReloadVideoTopic() {
        return reloadVideo;
    }

    public void doChangePlaybackControl(BPlaybackControlInfo bPlaybackControlInfo) {
        this.playBackParams.setPlaybackType(bPlaybackControlInfo.getPlaybackType());
        this.playBackParams.setPlaybackSpeed(bPlaybackControlInfo.getPlaybackSpeed());
        this.playBackParams.setTimeIndex(bPlaybackControlInfo.getTimeIndex());
        this.fireReloadVideo((BPlaybackParams)this.playBackParams.newCopy());
    }

    public void animate() {
        if (this.videoDecoder != null) {
            this.videoDecoder.keepAlive();
        }
        super.animate();
    }

    public void paint(Graphics graphics) {
        this.paintDefault(graphics);
        if (this.videoDecoder != null) {
            BBinding[] bBindingArray;
            IVideoDecoder iVideoDecoder = this.videoDecoder;
            try {
                iVideoDecoder = iVideoDecoder.getVideoDecoder();
            }
            catch (RuntimeException runtimeException) {}
            if (iVideoDecoder instanceof IVideoImagePainter) {
                IVideoImagePainter iVideoImagePainter = (IVideoImagePainter)((Object)iVideoDecoder);
                iVideoImagePainter.paintImage(graphics, (BWidget)this);
                return;
            }
            if (iVideoDecoder instanceof VideoMultistreamDecoder && (bBindingArray = this.getBindings()) != null && bBindingArray.length > 0) {
                iVideoDecoder = ((VideoMultistreamDecoder)this.videoDecoder).getVideoDecoder(bBindingArray[0].getOrd());
                try {
                    iVideoDecoder = iVideoDecoder.getVideoDecoder();
                }
                catch (RuntimeException runtimeException) {}
                if (iVideoDecoder instanceof IVideoImagePainter) {
                    IVideoImagePainter iVideoImagePainter = (IVideoImagePainter)((Object)iVideoDecoder);
                    iVideoImagePainter.paintImage(graphics, (BWidget)this);
                    return;
                }
            }
        }
    }

    public void paintDefault(Graphics graphics) {
        this.paintMostRecentImage(graphics);
        this.paintMessage(graphics);
        if (this.mostRecentImage != DISCONNECTED_IMAGE && this.getShowTimeIndex()) {
            this.paintMostRecentImageTime(graphics);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintMostRecentImageTime(Graphics graphics) {
        if (this.videoDecoder == null) return;
        if (this.currentTimeIndex == null) return;
        if (this.currentTimeIndex.isNull()) return;
        String string = this.currentTimeIndex.toLocalTime().toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
        if (string == null) return;
        if (string.length() <= 0) return;
        try {
            graphics.push();
            string = " " + string + ' ';
            double d = this.getWidth();
            int n = 32;
            BFont bFont = BFont.make((String)Theme.label().getTextFont().getName(), (double)n, (int)1);
            double d2 = bFont.width(string);
            while (d2 > d - 20.0) {
                bFont = BFont.make((String)Theme.label().getTextFont().getName(), (double)(n -= 2), (int)1);
                d2 = bFont.width(string);
                if (n > 8) continue;
            }
            graphics.transform(BTransform.makeTranslate((double)10.0, (double)(10.0 + bFont.getSize() / (double)4)));
            this.timeIndexLabel.setHalign(BHalign.left);
            this.timeIndexLabel.setValign(BValign.bottom);
            this.timeIndexLabel.setText(string);
            this.timeIndexLabel.setBackground(BBrush.NULL);
            this.timeIndexLabel.setForeground(TIME_INDEX_TEXT_BRUSH);
            this.timeIndexLabel.setFont(bFont);
            this.timeIndexLabel.computePreferredSize();
            this.timeIndexLabel.setBounds((double)2, (double)2, this.timeIndexLabel.getPreferredWidth(), this.timeIndexLabel.getPreferredHeight());
            this.timeIndexLabel.doLayout(null);
            graphics.setBrush(TIME_INDEX_BACKGROUND_BRUSH);
            graphics.setPen(BPen.make((double)4, (int)101, (int)202, null));
            graphics.strokeRect(0.0, 0.0, this.timeIndexLabel.getPreferredWidth() + (double)4, this.timeIndexLabel.getPreferredHeight() + (double)4);
            graphics.fillRect((double)2, (double)2, this.timeIndexLabel.getPreferredWidth(), this.timeIndexLabel.getPreferredHeight());
            this.timeIndexLabel.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var4_9 = null;
        }
        graphics.pop();
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void paintMessage(Graphics graphics) {
        this.paintMessage(graphics, this.getMessage());
    }

    public void paintMessage(Graphics graphics, String string) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        BVideoPlayer.paintMessage(graphics, string, 10, 40, d, d2, MESSAGE_BACKGROUND_BRUSH, MESSAGE_TEXT_BRUSH);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void paintMessage(Graphics graphics, String string, int n, int n2, double d, double d2, BBrush bBrush, BBrush bBrush2) {
        if (string == null) return;
        if (string.length() <= 0) return;
        graphics.push();
        try {
            string = " " + string + ' ';
            int n3 = 20;
            BFont bFont = BFont.make((String)Theme.label().getTextFont().getName(), (double)n3);
            String string2 = string;
            if (string.trim().startsWith(TRIMMED_ESTABLISHING_CONNECTION_MESSAGE)) {
                string2 = WIDEST_CONNECTING_MESSAGE;
            }
            double d3 = bFont.width(string2);
            while (d3 > d) {
                bFont = BFont.make((String)Theme.label().getTextFont().getName(), (double)(n3 -= 2));
                d3 = bFont.width(string2);
                if (n3 > 8) continue;
            }
            messageLabel.setHalign(BHalign.left);
            messageLabel.setValign(BValign.bottom);
            messageLabel.setText(string);
            messageLabel.setBackground(bBrush);
            messageLabel.setForeground(bBrush2);
            messageLabel.setFont(bFont);
            messageLabel.computePreferredSize();
            messageLabel.setBounds((double)2, (double)2, messageLabel.getPreferredWidth(), messageLabel.getPreferredHeight());
            messageLabel.doLayout(null);
            if (n == Integer.MIN_VALUE) {
                n = (int)(d / (double)2) - (int)(messageLabel.getPreferredWidth() / (double)2);
            }
            graphics.transform(BTransform.makeTranslate((double)n, (double)(d2 - (double)n2)));
            messageLabelInsideBorder.paint(graphics);
            graphics.setBrush(bBrush);
            graphics.setPen(BPen.make((double)4, (int)101, (int)202, null));
            graphics.strokeRect(0.0, 0.0, messageLabel.getPreferredWidth() + (double)4, messageLabel.getPreferredHeight() + (double)4);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        graphics.pop();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintMostRecentImage(Graphics graphics) {
        try {
            graphics.push();
            graphics.setBrush(this.getBackgroundColor().toBrush());
            graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = d / d2;
            BImage bImage = this.mostRecentImage;
            double d4 = this.translateAspectRatioEnumToRatio(this.getAspectRatio(), bImage);
            if (d3 < d4) {
                d2 = d / d4;
            } else {
                d = d2 * d4;
            }
            double d5 = (this.getWidth() - d) / (double)2;
            double d6 = (this.getHeight() - d2) / (double)2;
            graphics.translate(d5, d6);
            double d7 = d / bImage.getWidth();
            double d8 = d2 / bImage.getHeight();
            graphics.transform(BTransform.makeScale((double)d7, (double)d8));
            graphics.drawImage(bImage, 0.0, 0.0);
        }
        catch (Throwable throwable) {
            Object var3_12 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var3_13 = null;
        }
        graphics.pop();
    }

    private final double translateAspectRatioEnumToRatio(BVideoAspectRatioEnum bVideoAspectRatioEnum, BImage bImage) {
        switch (bVideoAspectRatioEnum.getOrdinal()) {
            case 0: {
                return bImage.getWidth() / bImage.getHeight();
            }
            case 1: {
                return this.getWidth() / this.getHeight();
            }
            case 2: {
                return 1.15;
            }
            case 3: {
                return 1.3333333333333333;
            }
            case 4: {
                return 1.43;
            }
            case 5: {
                return 1.5;
            }
            case 6: {
                return 1.618;
            }
            case 7: {
                return 1.6666666666666667;
            }
            case 8: {
                return 1.7777777777777777;
            }
            case 9: {
                return 1.85;
            }
            case 10: {
                return 2.39;
            }
        }
        return this.getWidth() / this.getHeight();
    }

    public void resetImage() {
        this.mostRecentImage = DISCONNECTED_IMAGE;
        this.repaint();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        if (this.isRunning()) {
            this.repaint();
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null && this.cameraDescription != null) {
            bWidgetShell.showStatus(this.cameraDescription);
        }
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseEntered(bMouseEvent);
        }
        super.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null && this.cameraDescription != null) {
            bWidgetShell.showStatus("");
        }
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseExited(bMouseEvent);
        }
        super.mouseExited(bMouseEvent);
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseHover(bMouseEvent);
        }
        super.mouseHover(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseReleased(bMouseEvent);
        }
        super.mouseReleased(bMouseEvent);
    }

    public String getCameraDescription() {
        return this.cameraDescription;
    }

    public void setCameraDescription(String string) {
        this.cameraDescription = string;
    }

    public void startDrag(BMouseEvent bMouseEvent, TransferContext transferContext, DragRenderer dragRenderer) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.startDrag(bMouseEvent, transferContext, dragRenderer);
        }
    }

    public void startDrag(BMouseEvent bMouseEvent, TransferEnvelope transferEnvelope, DragRenderer dragRenderer) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.startDrag(bMouseEvent, transferEnvelope, dragRenderer);
        }
    }

    public int dragOver(TransferContext transferContext) {
        if (this.hostTransferWidget != null) {
            return this.hostTransferWidget.dragOver(transferContext);
        }
        return 0;
    }

    public void dragEnter(TransferContext transferContext) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.dragEnter(transferContext);
        }
    }

    public void dragExit(TransferContext transferContext) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.dragExit(transferContext);
        }
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (this.hostTransferWidget != null) {
            return this.hostTransferWidget.drop(transferContext);
        }
        return null;
    }

    public void setHostTransferWidget(BTransferWidget bTransferWidget) {
        this.hostTransferWidget = bTransferWidget;
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setMultistreamPaneForView(BVideoMultistreamPaneForView bVideoMultistreamPaneForView) {
        this.multistreamPaneForView = bVideoMultistreamPaneForView;
    }

    public BVideoMultistreamPaneForView getMultistreamPaneForView() {
        return this.multistreamPaneForView;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.myId = vidId++;
        this.timeIndexLabel = new BLabel();
        this.timeIndexLabelInsideBorder = new BBorderPane((BWidget)this.timeIndexLabel, BBorder.none);
        this.playBackParams = new BPlaybackParams();
        this.lastUpdateTicks = 0L;
        this.mostRecentImage = DISCONNECTED_IMAGE;
    }

    public BVideoPlayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$videoDriver$ui$BVideoPlayer;
        if (clazz == null) {
            clazz = class$com$tridium$videoDriver$ui$BVideoPlayer = BVideoPlayer.class("[Lcom.tridium.videoDriver.ui.BVideoPlayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        vidId = 0;
        messageLabel = new BLabel();
        messageLabelInsideBorder = new BBorderPane((BWidget)messageLabel, BBorder.none);
        TIME_INDEX_TEXT_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)127));
        TIME_INDEX_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)0, (int)0, (int)0, (int)127));
        MESSAGE_TEXT_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)127));
        MESSAGE_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)3, (int)8, (int)150, (int)127));
        icon = BIcon.std((String)"video.png");
        DISCONNECTED_IMAGE = BImage.make((BIcon)BIcon.make((String)"module://videoDriver/images/VideoStreamDisconnected.png"));
        WIDEST_CONNECTING_MESSAGE = " " + VideoPlaybackSession.ESTABLISH_STREAM_MESSAGE + VideoPlaybackSession.DOTS[VideoPlaybackSession.DOTS.length - 1] + ' ';
        TRIMMED_ESTABLISHING_CONNECTION_MESSAGE = VideoPlaybackSession.ESTABLISH_STREAM_MESSAGE.trim();
    }
}

