/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.ext;

import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.enums.BTotalizationInterval;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNumericTotalizerExt
extends BPointExtension {
    public static final Property totalFacets = BNumericTotalizerExt.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property propagateFlags = BNumericTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)23), null);
    public static final Property invalidValueFlags = BNumericTotalizerExt.newProperty((int)0, (BValue)BStatus.make((int)7), null);
    public static final Property total = BNumericTotalizerExt.newProperty((int)1, (BValue)new BStatusNumeric(0.0), null);
    public static final Property timeOfTotalReset = BNumericTotalizerExt.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property totalizationInterval = BNumericTotalizerExt.newProperty((int)0, (BValue)BTotalizationInterval.minutely, null);
    public static final Action timerExpired = BNumericTotalizerExt.newAction((int)0, null);
    public static final Action resetTotal = BNumericTotalizerExt.newAction((int)0, null);
    public static final Type TYPE;
    private Clock.Ticket ticket;
    private long lastExecuteTime;
    private BStatus lastStatus;
    static /* synthetic */ Class class$javax$baja$control$ext$BNumericTotalizerExt;

    public BFacets getTotalFacets() {
        return (BFacets)this.get(totalFacets);
    }

    public void setTotalFacets(BFacets bFacets) {
        this.set(totalFacets, (BValue)bFacets, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus bStatus) {
        this.set(propagateFlags, (BValue)bStatus, null);
    }

    public BStatus getInvalidValueFlags() {
        return (BStatus)this.get(invalidValueFlags);
    }

    public void setInvalidValueFlags(BStatus bStatus) {
        this.set(invalidValueFlags, (BValue)bStatus, null);
    }

    public BStatusNumeric getTotal() {
        return (BStatusNumeric)this.get(total);
    }

    public void setTotal(BStatusNumeric bStatusNumeric) {
        this.set(total, (BValue)bStatusNumeric, null);
    }

    public BAbsTime getTimeOfTotalReset() {
        return (BAbsTime)this.get(timeOfTotalReset);
    }

    public void setTimeOfTotalReset(BAbsTime bAbsTime) {
        this.set(timeOfTotalReset, (BValue)bAbsTime, null);
    }

    public BTotalizationInterval getTotalizationInterval() {
        return (BTotalizationInterval)this.get(totalizationInterval);
    }

    public void setTotalizationInterval(BTotalizationInterval bTotalizationInterval) {
        this.set(totalizationInterval, (BValue)bTotalizationInterval, null);
    }

    public void timerExpired() {
        this.invoke(timerExpired, null, null);
    }

    public void resetTotal() {
        this.invoke(resetTotal, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)total)) {
            return this.getTotalFacets();
        }
        return super.getSlotFacets(slot);
    }

    public boolean requiresPointSubscription() {
        return true;
    }

    public boolean isParentLegal(BComponent bComponent) {
        if (!super.isParentLegal(bComponent)) {
            return false;
        }
        return bComponent instanceof BNumericPoint;
    }

    public void started() throws Exception {
        super.started();
        this.lastExecuteTime = Clock.ticks();
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)timerExpired, null);
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    public void doTimerExpired() {
        this.onExecute(this.getParentPoint().getOutStatusValue(), null);
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
        BStatus bStatus = bStatusNumeric.getStatus();
        double d = bStatusNumeric.getValue();
        long l = Clock.ticks();
        double d2 = this.getTotalizationInterval().equals((Object)BTotalizationInterval.minutely) ? 60000.0 : 3600000.0;
        if ((bStatus.getBits() & this.getInvalidValueFlags().getBits()) == 0 && !Double.isNaN(d) && (this.lastStatus.getBits() & this.getInvalidValueFlags().getBits()) == 0) {
            double d3 = d * (double)(l - this.lastExecuteTime) / d2;
            this.getTotal().setValue(this.getTotal().getValue() + d3);
        }
        if (Double.isNaN(d)) {
            this.getTotal().setStatus(BStatus.make((int)(2 | bStatus.getBits() & this.getPropagateFlags().getBits())));
        } else {
            this.getTotal().setStatus(BStatus.make((int)(bStatus.getBits() & this.getPropagateFlags().getBits())));
        }
        this.lastStatus = bStatusNumeric.getStatus();
        this.lastExecuteTime = l;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals((Object)totalizationInterval)) {
            this.doResetTotal();
        }
        super.changed(property, context);
    }

    public void doResetTotal() {
        this.getTotal().setValue(0.0);
        this.setTimeOfTotalReset(BAbsTime.now());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastStatus = BStatus.ok;
    }

    public BNumericTotalizerExt() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$control$ext$BNumericTotalizerExt;
        if (clazz == null) {
            clazz = class$javax$baja$control$ext$BNumericTotalizerExt = BNumericTotalizerExt.class("[Ljavax.baja.control.ext.BNumericTotalizerExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

