/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control;

import javax.baja.control.BControlPoint;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.control.util.BOverride;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

abstract class WritableSupport {
    BControlPoint point;
    Clock.Ticket overrideTimer;

    abstract Property in1();

    abstract Property in2();

    abstract Property in3();

    abstract Property in4();

    abstract Property in5();

    abstract Property in6();

    abstract Property in7();

    abstract Property in8();

    abstract Property in9();

    abstract Property in10();

    abstract Property in11();

    abstract Property in12();

    abstract Property in13();

    abstract Property in14();

    abstract Property in15();

    abstract Property in16();

    abstract void setValue(BStatusValue var1, BStatusValue var2);

    abstract BStatusValue getFallback();

    abstract void setOverrideExpiration(BAbsTime var1);

    abstract BAbsTime getOverrideExpiration();

    void started() {
        BAbsTime bAbsTime = this.getOverrideExpiration();
        if (bAbsTime.getMillis() == 0L) {
            return;
        }
        BAbsTime bAbsTime2 = BAbsTime.now();
        if (bAbsTime.isAfter(bAbsTime2)) {
            BRelTime bRelTime = bAbsTime2.delta(bAbsTime);
            if (this.overrideTimer != null) {
                this.overrideTimer.cancel();
            }
            this.overrideTimer = Clock.schedule((BComponent)this.point, (BRelTime)bRelTime, (Action)this.point.getAction("auto"), null);
        } else {
            this.auto();
        }
    }

    BPriorityLevel getActiveLevel() {
        return BPriorityLevel.make(this.point.getStatus().geti("activeLevel", 17));
    }

    boolean isInput(Slot slot) {
        boolean bl = false;
        if (slot.isFrozen() && slot.getName().startsWith("in")) {
            bl = true;
        }
        return bl;
    }

    BStatusValue getLevel(int n) {
        switch (n) {
            case 1: {
                return (BStatusValue)this.point.get(this.in1());
            }
            case 2: {
                return (BStatusValue)this.point.get(this.in2());
            }
            case 3: {
                return (BStatusValue)this.point.get(this.in3());
            }
            case 4: {
                return (BStatusValue)this.point.get(this.in4());
            }
            case 5: {
                return (BStatusValue)this.point.get(this.in5());
            }
            case 6: {
                return (BStatusValue)this.point.get(this.in6());
            }
            case 7: {
                return (BStatusValue)this.point.get(this.in7());
            }
            case 8: {
                return (BStatusValue)this.point.get(this.in8());
            }
            case 9: {
                return (BStatusValue)this.point.get(this.in9());
            }
            case 10: {
                return (BStatusValue)this.point.get(this.in10());
            }
            case 11: {
                return (BStatusValue)this.point.get(this.in11());
            }
            case 12: {
                return (BStatusValue)this.point.get(this.in12());
            }
            case 13: {
                return (BStatusValue)this.point.get(this.in13());
            }
            case 14: {
                return (BStatusValue)this.point.get(this.in14());
            }
            case 15: {
                return (BStatusValue)this.point.get(this.in15());
            }
            case 16: {
                return (BStatusValue)this.point.get(this.in16());
            }
        }
        throw new IllegalArgumentException();
    }

    void changed(Property property) {
        BStatusValue bStatusValue;
        BStatus bStatus;
        if (this.isInput((Slot)property) && (bStatus = (bStatusValue = (BStatusValue)this.point.get(property)).getStatus()).get("activeLevel") != null) {
            bStatusValue.setStatus(BStatus.make((int)bStatus.getBits(), (BFacets)((BFacets)BFacets.makeRemove((BFacets)bStatus.getFacets(), (String)"activeLevel").intern())));
        }
    }

    void onExecute(BStatusValue bStatusValue, Context context) {
        BStatusValue bStatusValue2 = null;
        int n = 17;
        int n2 = 1;
        while (n2 <= 16) {
            BStatusValue bStatusValue3 = this.getLevel(n2);
            if (bStatusValue3.getStatus().isValid()) {
                bStatusValue2 = bStatusValue3;
                n = n2;
                break;
            }
            ++n2;
        }
        if (bStatusValue2 == null) {
            BStatusValue bStatusValue4 = this.getFallback();
            bStatusValue.copyFrom((BComplex)bStatusValue4);
            bStatusValue.setStatus("activeLevel", (BIDataValue)BDynamicEnum.make((BEnum)BPriorityLevel.fallback));
        } else {
            this.setValue(bStatusValue2, bStatusValue);
            n2 = 0;
            if (n == 1 || n == 8) {
                n2 |= 0x20;
            }
            bStatusValue.setStatus(n2);
            bStatusValue.setStatus("activeLevel", (BIDataValue)BDynamicEnum.make((BEnum)BPriorityLevel.make(n)));
        }
    }

    void emergencyOverride(BSimple bSimple) {
        this.notifyProxyExtForActionInvoked();
        BStatusValue bStatusValue = (BStatusValue)this.point.get(this.in1());
        bStatusValue.setValueValue((BValue)bSimple);
        bStatusValue.setStatus(BStatus.ok);
    }

    void emergencyAuto() {
        this.notifyProxyExtForActionInvoked();
        BStatusValue bStatusValue = (BStatusValue)this.point.get(this.in1());
        bStatusValue.setStatus(BStatus.nullStatus);
    }

    void override(BOverride bOverride) {
        long l;
        this.notifyProxyExtForActionInvoked();
        BStatusValue bStatusValue = (BStatusValue)this.point.get(this.in8());
        BValue bValue = bOverride.get("value");
        bStatusValue.setValueValue(bValue);
        bStatusValue.setStatus(BStatus.ok);
        if (this.overrideTimer != null) {
            this.overrideTimer.cancel();
        }
        BRelTime bRelTime = bOverride.getDuration();
        BRelTime bRelTime2 = this.getMaxOverrideDuration();
        long l2 = bRelTime2.getMillis();
        if (l2 > 0L && ((l = bRelTime.getMillis()) <= 0L || l > l2)) {
            bRelTime = bRelTime2;
        }
        if (bRelTime.getMillis() > 0L) {
            this.setOverrideExpiration(BAbsTime.make((long)(Clock.millis() + bRelTime.getMillis())));
            this.overrideTimer = Clock.schedule((BComponent)this.point, (BRelTime)bRelTime, (Action)this.point.getAction("auto"), null);
        } else {
            this.setOverrideExpiration(BAbsTime.NULL);
        }
    }

    void auto() {
        this.notifyProxyExtForActionInvoked();
        BStatusValue bStatusValue = (BStatusValue)this.point.get(this.in8());
        bStatusValue.setStatus(BStatus.nullStatus);
        if (this.overrideTimer != null) {
            this.overrideTimer.cancel();
        }
        this.overrideTimer = null;
        this.setOverrideExpiration(BAbsTime.NULL);
    }

    void set(BSimple bSimple) {
        this.notifyProxyExtForActionInvoked();
        BStatusValue bStatusValue = this.getFallback();
        bStatusValue.setValueValue((BValue)bSimple);
        bStatusValue.setStatus(BStatus.ok);
    }

    void notifyProxyExtForActionInvoked() {
        try {
            this.point.getProxyExt().writablePointActionInvoked();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    BRelTime getMaxOverrideDuration() {
        BRelTime bRelTime = BRelTime.DEFAULT;
        try {
            BFacets bFacets;
            BObject bObject;
            if (!this.point.isRunning()) {
                this.point.loadSlots();
                this.point.lease();
            }
            if ((bObject = (bFacets = this.point.getFacets()).get("maxOverrideDuration")) instanceof BRelTime) {
                bRelTime = (BRelTime)bObject;
            } else {
                BStation bStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)this.point);
                if (!bStation.isRunning()) {
                    bStation.loadSlots();
                    bStation.lease();
                }
                bFacets = (BFacets)bStation.get("sysInfo");
                bRelTime = (BRelTime)bFacets.get("maxOverrideDuration", (BObject)bRelTime);
            }
        }
        catch (Exception exception) {}
        return bRelTime;
    }

    WritableSupport(BControlPoint bControlPoint) {
        this.point = bControlPoint;
    }
}

