/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control;

import javax.baja.control.BPointExtension;
import javax.baja.control.WritableSupport;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.log.Log;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BControlPoint
extends BComponent
implements BIStatusValue {
    public static final Property facets = BControlPoint.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property proxyExt = BControlPoint.newProperty((int)0, (BValue)new BNullProxyExt(), null);
    public static final Action execute = BControlPoint.newAction((int)20, null);
    public static final Type TYPE;
    public static final Log log;
    private static final Context setOutContext;
    static final Context noExecuteContext;
    private BStatusValue working;
    private long totalExecuteTime;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    public void setProxyExt(BAbstractProxyExt bAbstractProxyExt) {
        this.set(proxyExt, (BValue)bAbstractProxyExt, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BStatusValue getStatusValue() {
        return this.getOutStatusValue();
    }

    public final BFacets getStatusValueFacets() {
        return this.getFacets();
    }

    public final BStatus getStatus() {
        return this.getOutStatusValue().getStatus();
    }

    public final String getValueWithFacets(Context context) {
        return this.getStatusValue().getValueValue().toString((Context)new BasicContext(context, this.getFacets()));
    }

    public abstract BStatusValue getOutStatusValue();

    public final Property getOutProperty() {
        return this.getOutStatusValue().getPropertyInParent();
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == this.getOutProperty()) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public boolean isWritablePoint() {
        return false;
    }

    public final void doExecute() {
        long l = Clock.nanoTicks();
        BStatusValue bStatusValue = (BStatusValue)this.getOutProperty().getDefaultValue();
        if (this.working == null) {
            this.working = (BStatusValue)bStatusValue.newCopy();
        }
        this.working.copyFrom((BComplex)bStatusValue);
        this.onExecute(this.working, null);
        this.executeExtensions(this.working, null);
        BStatusValue bStatusValue2 = this.getOutStatusValue();
        if (!bStatusValue2.equivalent((Object)this.working)) {
            bStatusValue2.copyFrom((BComplex)this.working, setOutContext);
        }
        long l2 = Clock.nanoTicks();
        this.totalExecuteTime += l2 - l;
    }

    public abstract void onExecute(BStatusValue var1, Context var2);

    public final BPointExtension[] getExtensions() {
        BObject bObject;
        BPointExtension[] bPointExtensionArray = new BPointExtension[this.getSlotCount()];
        int n = 0;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            bObject = slotCursor.get();
            if (!(bObject instanceof BPointExtension)) continue;
            bPointExtensionArray[n++] = (BPointExtension)bObject;
        }
        bObject = new BPointExtension[n];
        System.arraycopy(bPointExtensionArray, 0, bObject, 0, n);
        return bObject;
    }

    public boolean getExtensionsRequireSubscription() {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            BObject bObject = slotCursor.get();
            if (!(bObject instanceof BPointExtension) || !((BPointExtension)bObject).requiresPointSubscription()) continue;
            return true;
        }
        return false;
    }

    public void checkExtensionsRequireSubscription() {
        if (!this.isRunning()) {
            return;
        }
        this.setPermanentlySubscribed(this.getExtensionsRequireSubscription());
    }

    public void executeExtensions(BStatusValue bStatusValue, Context context) {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            BObject bObject = slotCursor.get();
            if (!(bObject instanceof BPointExtension)) continue;
            BPointExtension bPointExtension = (BPointExtension)bObject;
            try {
                bPointExtension.onExecute(bStatusValue, context);
            }
            catch (Throwable throwable) {
                log.error("Extension failed onExecute(): " + bPointExtension.toPathString(), throwable);
            }
        }
    }

    private final void pointFacetsChanged() {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            BObject bObject = slotCursor.get();
            if (!(bObject instanceof BPointExtension)) continue;
            BPointExtension bPointExtension = (BPointExtension)bObject;
            bPointExtension.pointFacetsChanged();
        }
    }

    protected LinkCheck doCheckLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            LinkCheck linkCheck;
            BObject bObject = slotCursor.get();
            if (!(bObject instanceof BPointExtension) || (linkCheck = ((BPointExtension)bObject).doCheckParentLink(bComponent, slot, slot2, context)).isValid()) continue;
            return linkCheck;
        }
        return LinkCheck.makeValid();
    }

    public final boolean isChildLegal(BComponent bComponent) {
        if (bComponent instanceof BPointExtension) {
            SlotCursor slotCursor = this.getProperties();
            while (slotCursor.nextComponent()) {
                BObject bObject = slotCursor.get();
                if (!(bObject instanceof BPointExtension) || ((BPointExtension)bObject).isSiblingLegal(bComponent)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public String toString(Context context) {
        return this.propertyValueToString(this.getOutProperty(), context);
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 2: {
                this.fwChanged((Property)object, (Context)object2);
                break;
            }
            case 3: {
                this.fwAdded((Property)object, (Context)object2);
                break;
            }
            case 4: {
                this.fwRemoved((Property)object, (BValue)object2, (Context)object3);
                break;
            }
            case 7: {
                this.fwParented((Property)object, (BValue)object2, (Context)object3);
                break;
            }
            case 8: {
                this.fwUnparented((Property)object, (BValue)object2, (Context)object3);
                break;
            }
            case 11: {
                this.fwStarted();
                break;
            }
            case 13: {
                this.doExecute();
                break;
            }
            case 17: {
                this.fwSubscribed();
                break;
            }
            case 18: {
                this.fwUnsubscribed();
                break;
            }
            case 22: {
                return new Long(this.totalExecuteTime);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwStarted() {
        this.getProxyExt().checkStatusValueTypes();
        this.checkExtensionsRequireSubscription();
    }

    private final void fwAdded(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.checkExtensionsRequireSubscription();
        this.execute();
    }

    private final void fwRemoved(Property property, BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.checkExtensionsRequireSubscription();
        this.execute();
    }

    private final void fwParented(Property property, BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().checkStatusValueTypes();
    }

    private final void fwUnparented(Property property, BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().checkStatusValueTypes();
    }

    private final void fwChanged(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == this.getOutProperty()) {
            if (context != setOutContext) {
                log.warning("ControlPoint.out set explicitly: " + this.getType() + ": " + this.toPathString(), (Throwable)new Exception());
            }
        } else {
            if (property.equals((Object)facets)) {
                this.pointFacetsChanged();
            }
            if (context != noExecuteContext) {
                this.execute();
            }
        }
        if (this.writableSupport() != null) {
            this.writableSupport().changed(property);
        }
    }

    private final void fwSubscribed() {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().pointSubscribed();
    }

    private final void fwUnsubscribed() {
        if (!this.isRunning()) {
            return;
        }
        this.getProxyExt().pointUnsubscribed();
    }

    WritableSupport writableSupport() {
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$control$BControlPoint;
        if (clazz == null) {
            clazz = class$javax$baja$control$BControlPoint = BControlPoint.class("[Ljavax.baja.control.BControlPoint;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"control");
        setOutContext = new BasicContext();
        noExecuteContext = new BasicContext();
    }
}

