/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platSysmonNxs;

import com.tridium.platform.BPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BHardwareMonitorNxsPlatformService
extends BPlatformService
implements BIAlarmablePlatformService {
    public static final Property sysmonPollRate = BHardwareMonitorNxsPlatformService.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.makeMinutes((int)0), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)15)));
    public static final Property cpuTemp = BHardwareMonitorNxsPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property cpuTempHi = BHardwareMonitorNxsPlatformService.newProperty((int)0, (float)75.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property boardTemp = BHardwareMonitorNxsPlatformService.newProperty((int)1, (float)0.0f, (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"celsius")));
    public static final Property boardTempHi = BHardwareMonitorNxsPlatformService.newProperty((int)0, (float)70.0f, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)1, (int)120));
    public static final Property cpuTemperatureAlarmSupport = BHardwareMonitorNxsPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxsPlatformService.initCpuTemperatureAlarmSupport(), null);
    public static final Property cpuTemperatureAlarmProxy = BHardwareMonitorNxsPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property boardTemperatureAlarmSupport = BHardwareMonitorNxsPlatformService.newProperty((int)0, (BValue)BHardwareMonitorNxsPlatformService.initBoardTemperatureAlarmSupport(), null);
    public static final Property boardTemperatureAlarmProxy = BHardwareMonitorNxsPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final String ALARM_TYPE_CPU_TEMPERATURE = "cpu temperature";
    private static final String ALARM_TYPE_BOARD_TEMPERATURE = "board temperature";
    int success;
    private Clock.Ticket sysmonTicket;
    private boolean lastCpuTempOk;
    private boolean nowCpuTempOk;
    private boolean lastBoardTempOk;
    private boolean nowBoardTempOk;
    private int cpuTemperature;
    private int boardTemperature;
    Vector alarmListeners;
    private boolean open;
    static /* synthetic */ Class class$com$tridium$platSysmonNxs$BHardwareMonitorNxsPlatformService;

    public BRelTime getSysmonPollRate() {
        return (BRelTime)this.get(sysmonPollRate);
    }

    public void setSysmonPollRate(BRelTime bRelTime) {
        this.set(sysmonPollRate, (BValue)bRelTime, null);
    }

    public float getCpuTemp() {
        return this.getFloat(cpuTemp);
    }

    public void setCpuTemp(float f) {
        this.setFloat(cpuTemp, f, null);
    }

    public float getCpuTempHi() {
        return this.getFloat(cpuTempHi);
    }

    public void setCpuTempHi(float f) {
        this.setFloat(cpuTempHi, f, null);
    }

    public float getBoardTemp() {
        return this.getFloat(boardTemp);
    }

    public void setBoardTemp(float f) {
        this.setFloat(boardTemp, f, null);
    }

    public float getBoardTempHi() {
        return this.getFloat(boardTempHi);
    }

    public void setBoardTempHi(float f) {
        this.setFloat(boardTempHi, f, null);
    }

    public BPlatformAlarmSupport getCpuTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(cpuTemperatureAlarmSupport);
    }

    public void setCpuTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(cpuTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getCpuTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(cpuTemperatureAlarmProxy);
    }

    public void setCpuTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(cpuTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BPlatformAlarmSupport getBoardTemperatureAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(boardTemperatureAlarmSupport);
    }

    public void setBoardTemperatureAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(boardTemperatureAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getBoardTemperatureAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(boardTemperatureAlarmProxy);
    }

    public void setBoardTemperatureAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(boardTemperatureAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        log.trace("......loading sysmon libraries");
        this.loadLibraries();
        log.trace("......symon libraries loaded");
        this.open = false;
        if (this.sysmonTicket != null) {
            this.sysmonTicket.cancel();
        }
        log.trace("......sysmon poll rate " + this.getSysmonPollRate());
        this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)poll, null);
        this.getCpuTemperatureAlarmProxy().setAlarmSupport(this.getCpuTemperatureAlarmSupport());
        this.getBoardTemperatureAlarmProxy().setAlarmSupport(this.getBoardTemperatureAlarmSupport());
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property == sysmonPollRate) {
            if (this.sysmonTicket != null) {
                this.sysmonTicket.cancel();
            }
            this.sysmonTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSysmonPollRate(), (Action)poll, null);
        }
    }

    public void doPoll(Context context) {
        log.trace("sysmon poll");
        if (!this.open) {
            this.success = this.open();
            if (this.success == 1) {
                this.open = true;
            }
        }
        if (!this.open) {
            log.error("SOM driver not available");
            return;
        }
        try {
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord;
            this.cpuTemperature = this.readCpuTemperature();
            if (this.cpuTemperature == -32000 || this.cpuTemperature == -32001) {
                log.error("unable to read cpu temp");
                this.open = false;
                return;
            }
            log.trace("cpuBoardTemp --> " + this.cpuTemperature);
            boolean bl = false;
            if ((float)this.cpuTemperature < this.getCpuTempHi()) {
                bl = true;
            }
            this.nowCpuTempOk = bl;
            boolean bl2 = false;
            if (this.getCpuTemp() < this.getCpuTempHi()) {
                bl2 = true;
            }
            this.lastCpuTempOk = bl2;
            this.setCpuTemp(this.cpuTemperature);
            this.boardTemperature = this.readBoardTemperature();
            if (this.boardTemperature == -32000 || this.boardTemperature == -32001) {
                log.error("unable to read board temp");
                this.open = false;
                return;
            }
            log.trace("mainBoardTemp --> " + this.boardTemperature);
            boolean bl3 = false;
            if ((float)this.boardTemperature < this.getBoardTempHi()) {
                bl3 = true;
            }
            this.nowBoardTempOk = bl3;
            boolean bl4 = false;
            if (this.getBoardTemp() < this.getBoardTempHi()) {
                bl4 = true;
            }
            this.lastBoardTempOk = bl4;
            this.setBoardTemp(this.boardTemperature);
            if (this.nowCpuTempOk != this.lastCpuTempOk) {
                if (this.nowCpuTempOk) {
                    log.trace("cpuTemp --> OK");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeToNormal();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("cpuTemp --> FAILED");
                    bPlatformServiceAlarmRecord = this.getCpuTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getCpuTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            if (this.nowBoardTempOk != this.lastBoardTempOk) {
                if (this.nowBoardTempOk) {
                    log.trace("boardTemp --> OK");
                    bPlatformServiceAlarmRecord = this.getBoardTemperatureAlarmSupport().makeToNormal();
                    this.getBoardTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else {
                    log.trace("boardTemp --> FAILED");
                    bPlatformServiceAlarmRecord = this.getBoardTemperatureAlarmSupport().makeNewFaultAlarm();
                    this.getBoardTemperatureAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
        }
        catch (Exception exception) {
            log.error("exception in sysmon doPoll");
        }
    }

    protected abstract void loadLibraries();

    protected abstract int open();

    protected abstract void close();

    protected abstract int readCpuTemperature();

    protected abstract int readBoardTemperature();

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBoardTemperatureAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getCpuTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBoardTemperatureAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initCpuTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNxs:cpuTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNxs:cpuTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_CPU_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initBoardTemperatureAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platSysmonNxs:boardTemperatureFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platSysmonNxs:boardTemperaturePassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_BOARD_TEMPERATURE));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.success = 0;
        this.alarmListeners = new Vector(1);
        this.open = false;
    }

    public BHardwareMonitorNxsPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("HardwareMonitorNxsPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platSysmonNxs$BHardwareMonitorNxsPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platSysmonNxs$BHardwareMonitorNxsPlatformService = BHardwareMonitorNxsPlatformService.class("[Lcom.tridium.platSysmonNxs.BHardwareMonitorNxsPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"connection.png");
        log = Log.getLog((String)"sysmon");
    }
}

