/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.Utils;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMonthWidget
extends BWidget {
    public static final Topic selected = BMonthWidget.newTopic((int)0, null);
    public static final Type TYPE;
    static double baseYoffset;
    static double cellH;
    static double cellW;
    static BFont font;
    static Cell[] headers;
    static double highH;
    static double highW;
    static double strH;
    static double strW;
    static double padding;
    static double widgetW;
    static double widgetH;
    Cell[][] cells;
    BMonth month;
    String monthStr;
    double monthX;
    boolean selectable;
    int selection;
    BAbsTime start;
    int year;
    static /* synthetic */ Class class$com$tridium$schedule$ui$BMonthWidget;

    public void fireSelected(BMonthWidget bMonthWidget) {
        this.fire(selected, (BValue)bMonthWidget, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void clearHighlights() {
        int n = 7;
        while (--n > 0) {
            int n2 = 7;
            while (--n2 >= 0) {
                Cell cell = this.cells[n][n2];
                if (cell == null) continue;
                cell.highlight = false;
            }
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(widgetW, widgetH);
    }

    public BMonth getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int getSelection() {
        return this.selection;
    }

    public BAbsTime getStart() {
        return this.start;
    }

    public void highlight(int n) {
        int n2 = 7;
        while (--n2 > 0) {
            int n3 = 7;
            while (--n3 >= 0) {
                Cell cell = this.cells[n2][n3];
                if (cell == null || cell.dom != n) continue;
                cell.highlight = true;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.selectable) {
            graphics.setBrush(Utils.clrBg);
        } else {
            graphics.setBrush(Utils.clrRoBg);
        }
        graphics.fillRect(0.0, 0.0, widgetW, widgetH);
        graphics.setBrush(Utils.clrFg);
        graphics.drawString(this.monthStr, this.monthX, baseYoffset);
        this.paintHeaders(graphics);
        this.paintDays(graphics);
        graphics.setBrush(Utils.clrFg);
        graphics.strokeRect(0.0, 0.0, widgetW - 1.0, widgetH - 1.0);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (!this.selectable) {
            return;
        }
        int n = (int)(bMouseEvent.getY() / cellH) - 1;
        if (n < 0) {
            return;
        }
        int n2 = (int)(bMouseEvent.getX() / cellW);
        Cell cell = this.cells[n][n2];
        if (cell != null && cell.dom > 0) {
            this.selection = cell.dom;
            this.repaint();
            this.fireSelected(this);
        }
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public void setSelection(int n) {
        this.selection = n;
    }

    private final void paintHeaders(Graphics graphics) {
        graphics.setBrush(Utils.clrFg);
        graphics.setPen(BPen.DEFAULT);
        int n = 0;
        while (n < 7) {
            Cell cell = this.cells[0][n];
            graphics.drawString(cell.str, cell.strX, cell.strBaseY);
            double d = cell.highY + highH;
            graphics.strokeLine(cell.highX, d, cell.highX + highW, d);
            ++n;
        }
    }

    private final void paintDays(Graphics graphics) {
        graphics.setFont(font);
        graphics.setBrush(Utils.clrFg);
        graphics.setPen(BPen.DEFAULT);
        int n = 1;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 7) {
                Cell cell = this.cells[n][n2];
                if (cell == null) {
                    if (n > 1) {
                        break;
                    }
                } else {
                    graphics.setBrush(Utils.clrFg);
                    if (this.selection == cell.dom) {
                        graphics.setBrush(Utils.clrSelCurBg);
                        graphics.fillRect(cell.x, cell.y, cellW, cellH);
                        graphics.setBrush(Utils.clrSelFg);
                    }
                    if (cell.highlight) {
                        graphics.setBrush(Utils.clrSelBg);
                        graphics.fillRect(cell.highX, cell.highY, highW, highH);
                        graphics.setBrush(Utils.clrSelFg);
                    }
                    graphics.drawString(cell.str, cell.strX, cell.strBaseY);
                }
                ++n2;
            }
            ++n;
        }
    }

    private final int translateDay(BWeekday bWeekday) {
        int n = bWeekday.getOrdinal() - BWeekday.getFirstDayOfWeek(null).getOrdinal();
        if (n < 0) {
            n += 7;
        }
        return n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cells = new Cell[7][7];
        this.selectable = false;
        this.selection = -1;
    }

    public BMonthWidget() {
        this.this();
    }

    public BMonthWidget(int n, BMonth bMonth) {
        this.this();
        this.start = BAbsTime.make((int)n, (BMonth)bMonth, (int)1, (int)0, (int)0, (int)0, (int)0);
        this.year = n;
        this.month = bMonth;
        this.monthStr = bMonth.getShortDisplayTag(null) + ' ' + n;
        this.monthX = (widgetW - font.width(this.monthStr)) / (double)2;
        int n2 = BAbsTime.getDaysInMonth((int)n, (BMonth)bMonth);
        int n3 = this.translateDay(this.start.getWeekday());
        int n4 = 0;
        while (n4 < 7) {
            this.cells[0][n4] = headers[n4];
            ++n4;
        }
        double d = cellH * (double)2;
        int n5 = 1;
        int n6 = 1;
        while (n6 < 7) {
            int n7 = 0;
            double d2 = 0.0;
            if (n6 == 1) {
                n7 = n3;
                d2 = cellW * (double)n7;
            }
            while (n7 < 7) {
                Cell cell;
                if (n5 > n2) break;
                this.cells[n6][n7] = cell = new Cell();
                cell.dom = n5;
                cell.str = String.valueOf(n5);
                cell.strW = font.width(cell.str);
                cell.strX = d2 + (cellW - cell.strW) / (double)2;
                cell.strBaseY = d + baseYoffset;
                cell.highX = d2 + (cellW - highW) / (double)2;
                cell.highY = d + (cellH - highH) / (double)2;
                cell.x = d2;
                cell.y = d;
                ++n5;
                ++n7;
                d2 += cellW;
            }
            d += cellH;
            ++n6;
        }
    }

    static {
        Class clazz = class$com$tridium$schedule$ui$BMonthWidget;
        if (clazz == null) {
            clazz = class$com$tridium$schedule$ui$BMonthWidget = BMonthWidget.class("[Lcom.tridium.schedule.ui.BMonthWidget;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        padding = 2;
        font = Theme.widget().getTextFont();
        strH = font.getAscent() + font.getDescent();
        strW = font.width("W0");
        cellW = strW + padding * (double)4;
        cellH = strH + padding * (double)4;
        highW = strW + padding * (double)2;
        highH = strH + padding * (double)2;
        baseYoffset = font.getAscent() + padding * (double)2;
        widgetW = cellW * 7.0;
        widgetH = cellH * 8.0;
        BWeekday[] bWeekdayArray = BWeekSchedule.daysInOrder(null);
        headers = new Cell[7];
        int n = 0;
        int n2 = 0;
        while (n2 < bWeekdayArray.length) {
            BMonthWidget.headers[n2] = new Cell();
            BMonthWidget.headers[n2].str = String.valueOf(bWeekdayArray[n2].getShortDisplayTag(null).toLowerCase().charAt(0));
            BMonthWidget.headers[n2].strW = font.width(BMonthWidget.headers[n2].str);
            BMonthWidget.headers[n2].strX = (double)n + (cellW - BMonthWidget.headers[n2].strW) / (double)2;
            BMonthWidget.headers[n2].strBaseY = cellH + baseYoffset;
            BMonthWidget.headers[n2].x = n;
            BMonthWidget.headers[n2].y = cellH;
            BMonthWidget.headers[n2].highX = (double)n + (cellW - highW) / (double)2;
            BMonthWidget.headers[n2].highY = cellH + (cellH - highH) / (double)2;
            n = (int)((double)n + cellW);
            ++n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Cell {
        String str;
        int dom;
        double highX;
        double highY;
        double strX;
        double strBaseY;
        double strW;
        double x;
        double y;
        boolean highlight;

        private final /* synthetic */ void this() {
            this.dom = -1;
            this.highlight = false;
        }

        Cell() {
            this.this();
        }
    }
}

